/*
 * Decompiled with CFR 0.152.
 */
package org.linkgrammar;

import java.io.IOException;
import java.io.Reader;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class JSONUtils {
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private String rawText;

    public static boolean getBool(String name, Map<String, String> msg, boolean def) {
        String x = msg.get(name);
        return x == null ? def : Boolean.valueOf(x);
    }

    public static int getInt(String name, Map<String, String> msg, int def) {
        String x = msg.get(name);
        return x == null ? def : Integer.parseInt(x);
    }

    public static double getDouble(String name, Map<String, String> msg, double def) {
        String x = msg.get(name);
        return x == null ? def : Double.parseDouble(x);
    }

    public static String jsonString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        b.append("\"");
        StringCharacterIterator it = new StringCharacterIterator(s);
        int c = it.first();
        while (c != 65535) {
            if (c == 34) {
                b.append("\\\"");
            } else if (c == 92) {
                b.append("\\\\");
            } else if (c == 47) {
                b.append("\\/");
            } else if (c == 8) {
                b.append("\\b");
            } else if (c == 12) {
                b.append("\\f");
            } else if (c == 10) {
                b.append("\\n");
            } else if (c == 13) {
                b.append("\\r");
            } else if (c == 9) {
                b.append("\\t");
            } else if (Character.isISOControl((char)c)) {
                int n = c;
                for (int i = 0; i < 4; ++i) {
                    int digit = (n & 0xF000) >> 12;
                    b.append(hex[digit]);
                    n <<= 4;
                }
            } else {
                b.append((char)c);
            }
            c = it.next();
        }
        b.append("\"");
        return b.toString();
    }

    public String getRawText() {
        return this.rawText;
    }

    public Map<String, String> readMsg(Reader in) throws IOException {
        int length = 0;
        char[] buf = new char[1024];
        int count = in.read(buf, length, buf.length - length);
        while (count > -1) {
            if ((length += count) == buf.length) {
                char[] nbuf = new char[buf.length + 512];
                System.arraycopy(buf, 0, nbuf, 0, buf.length);
                buf = nbuf;
            }
            if (buf[length - 1] == '\n') break;
            count = in.read(buf, length, buf.length - length);
        }
        this.rawText = new String(buf);
        HashMap<String, String> result = new HashMap<String, String>();
        boolean gotText = false;
        int start = -1;
        int column = -1;
        for (int offset = 0; offset < length - 1; ++offset) {
            String name;
            char c = buf[offset];
            if (start == -1) {
                start = offset;
                continue;
            }
            if (c == ':' && column == -1) {
                column = offset;
                name = new String(buf, start, column - start);
                if (!"text".equals(name = name.trim())) continue;
                gotText = true;
                continue;
            }
            if (c != '\u0000' && (gotText || c != ',')) continue;
            if (start == -1 || column == -1) {
                throw new RuntimeException("Malformed message:" + new String(buf, 0, length));
            }
            name = new String(buf, start, column - start);
            String value = new String(buf, column + 1, offset - column - 1);
            name = name.trim();
            value = value.trim();
            result.put(name, value);
            column = -1;
            start = -1;
        }
        if (start != -1 && column != -1) {
            String name = new String(buf, start, column - start);
            String value = new String(buf, column + 1, length - column - 1);
            name = name.trim();
            value = value.trim();
            result.put(name, value);
            column = -1;
            start = -1;
        }
        if (start != -1 || column != -1) {
            throw new RuntimeException("Malformed message:" + new String(buf, 0, length) + "Did you forget to say \"text:\" at the start of the message?");
        }
        return result;
    }
}

