/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sunflow.PluginRegistry;
import org.sunflow.core.GIEngine;
import org.sunflow.core.GlobalPhotonMapInterface;
import org.sunflow.core.Options;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class IrradianceCacheGIEngine
implements GIEngine {
    private int samples;
    private float tolerance;
    private float invTolerance;
    private float minSpacing;
    private float maxSpacing;
    private Node root;
    private ReentrantReadWriteLock rwl;
    private GlobalPhotonMapInterface globalPhotonMap;

    public boolean init(Options options, Scene scene) {
        this.samples = options.getInt("gi.irr-cache.samples", 256);
        this.tolerance = options.getFloat("gi.irr-cache.tolerance", 0.05f);
        this.invTolerance = 1.0f / this.tolerance;
        this.minSpacing = options.getFloat("gi.irr-cache.min_spacing", 0.05f);
        this.maxSpacing = options.getFloat("gi.irr-cache.max_spacing", 5.0f);
        this.root = null;
        this.rwl = new ReentrantReadWriteLock();
        this.globalPhotonMap = PluginRegistry.globalPhotonMapPlugins.createObject(options.getString("gi.irr-cache.gmap", null));
        this.samples = Math.max(0, this.samples);
        this.minSpacing = Math.max(0.001f, this.minSpacing);
        this.maxSpacing = Math.max(0.001f, this.maxSpacing);
        UI.printInfo(UI.Module.LIGHT, "Irradiance cache settings:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Samples: %d", this.samples);
        if (this.tolerance <= 0.0f) {
            UI.printInfo(UI.Module.LIGHT, "  * Tolerance: off", new Object[0]);
        } else {
            UI.printInfo(UI.Module.LIGHT, "  * Tolerance: %.3f", Float.valueOf(this.tolerance));
        }
        UI.printInfo(UI.Module.LIGHT, "  * Spacing: %.3f to %.3f", Float.valueOf(this.minSpacing), Float.valueOf(this.maxSpacing));
        Vector3 vector3 = scene.getBounds().getExtents();
        this.root = new Node(scene.getBounds().getCenter(), 1.0001f * MathUtils.max(vector3.x, vector3.y, vector3.z));
        return this.globalPhotonMap != null ? scene.calculatePhotons(this.globalPhotonMap, "global", 0, options) : true;
    }

    public Color getGlobalRadiance(ShadingState shadingState) {
        if (this.globalPhotonMap == null) {
            if (shadingState.getShader() != null) {
                return shadingState.getShader().getRadiance(shadingState);
            }
            return Color.BLACK;
        }
        return this.globalPhotonMap.getRadiance(shadingState.getPoint(), shadingState.getNormal());
    }

    public Color getIrradiance(ShadingState shadingState, Color color) {
        if (this.samples <= 0) {
            return Color.BLACK;
        }
        if (shadingState.getDiffuseDepth() > 0) {
            float f = (float)shadingState.getRandom(0, 0, 1);
            float f2 = (float)shadingState.getRandom(0, 1, 1);
            float f3 = (float)((double)(f * 2.0f) * Math.PI);
            float f4 = (float)Math.cos(f3);
            float f5 = (float)Math.sin(f3);
            float f6 = (float)Math.sqrt(f2);
            float f7 = (float)Math.sqrt(1.0f - f2);
            Vector3 vector3 = new Vector3();
            vector3.x = f4 * f6;
            vector3.y = f5 * f6;
            vector3.z = f7;
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            orthoNormalBasis.transform(vector3);
            Ray ray = new Ray(shadingState.getPoint(), vector3);
            ShadingState shadingState2 = shadingState.traceFinalGather(ray, 0);
            return shadingState2 != null ? this.getGlobalRadiance(shadingState2).copy().mul((float)Math.PI) : Color.BLACK;
        }
        this.rwl.readLock().lock();
        Color color2 = this.getIrradiance(shadingState.getPoint(), shadingState.getNormal());
        this.rwl.readLock().unlock();
        if (color2 == null) {
            color2 = Color.black();
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            float f = 0.0f;
            float f8 = Float.POSITIVE_INFINITY;
            Vector3 vector3 = new Vector3();
            for (int i = 0; i < this.samples; ++i) {
                float f9 = (float)shadingState.getRandom(i, 0, this.samples);
                float f10 = (float)shadingState.getRandom(i, 1, this.samples);
                float f11 = (float)((double)(f9 * 2.0f) * Math.PI);
                float f12 = (float)Math.cos(f11);
                float f13 = (float)Math.sin(f11);
                float f14 = (float)Math.sqrt(f10);
                float f15 = (float)Math.sqrt(1.0f - f10);
                vector3.x = f12 * f14;
                vector3.y = f13 * f14;
                vector3.z = f15;
                orthoNormalBasis.transform(vector3);
                Ray ray = new Ray(shadingState.getPoint(), vector3);
                ShadingState shadingState3 = shadingState.traceFinalGather(ray, i);
                if (shadingState3 == null) continue;
                f8 = Math.min(ray.getMax(), f8);
                f += 1.0f / ray.getMax();
                shadingState3.getInstance().prepareShadingState(shadingState3);
                color2.add(this.getGlobalRadiance(shadingState3));
            }
            color2.mul((float)Math.PI / (float)this.samples);
            f = (float)this.samples / f;
            this.rwl.writeLock().lock();
            this.insert(shadingState.getPoint(), shadingState.getNormal(), f, color2);
            this.rwl.writeLock().unlock();
        }
        return color2;
    }

    private void insert(Point3 point3, Vector3 vector3, float f, Color color) {
        if (this.tolerance <= 0.0f) {
            return;
        }
        Node node = this.root;
        f = MathUtils.clamp(f * this.tolerance, this.minSpacing, this.maxSpacing) * this.invTolerance;
        if (this.root.isInside(point3)) {
            while ((double)node.sideLength >= 4.0 * (double)f * (double)this.tolerance) {
                int n = 0;
                n |= point3.x > node.center.x ? 1 : 0;
                n |= point3.y > node.center.y ? 2 : 0;
                if (node.children[n |= point3.z > node.center.z ? 4 : 0] == null) {
                    Point3 point32 = new Point3(node.center);
                    point32.x = point32.x + ((n & 1) == 0 ? -node.quadSideLength : node.quadSideLength);
                    point32.y = point32.y + ((n & 2) == 0 ? -node.quadSideLength : node.quadSideLength);
                    point32.z = point32.z + ((n & 4) == 0 ? -node.quadSideLength : node.quadSideLength);
                    node.children[n] = new Node(point32, node.halfSideLength);
                }
                node = node.children[n];
            }
        }
        Sample sample = new Sample(point3, vector3, f, color);
        sample.next = node.first;
        node.first = sample;
    }

    private Color getIrradiance(Point3 point3, Vector3 vector3) {
        if (this.tolerance <= 0.0f) {
            return null;
        }
        Sample sample = new Sample(point3, vector3);
        float f = this.root.find(sample);
        return sample.irr == null ? null : sample.irr.mul(1.0f / f);
    }

    private static final class Sample {
        float pix;
        float piy;
        float piz;
        float nix;
        float niy;
        float niz;
        float invR0;
        Color irr;
        Sample next;

        Sample(Point3 point3, Vector3 vector3) {
            this.pix = point3.x;
            this.piy = point3.y;
            this.piz = point3.z;
            Vector3 vector32 = new Vector3(vector3).normalize();
            this.nix = vector32.x;
            this.niy = vector32.y;
            this.niz = vector32.z;
            this.irr = null;
            this.next = null;
        }

        Sample(Point3 point3, Vector3 vector3, float f, Color color) {
            this.pix = point3.x;
            this.piy = point3.y;
            this.piz = point3.z;
            Vector3 vector32 = new Vector3(vector3).normalize();
            this.nix = vector32.x;
            this.niy = vector32.y;
            this.niz = vector32.z;
            this.invR0 = 1.0f / f;
            this.irr = color;
            this.next = null;
        }
    }

    private final class Node {
        Node[] children = new Node[8];
        Sample first;
        Point3 center;
        float sideLength;
        float halfSideLength;
        float quadSideLength;

        Node(Point3 point3, float f) {
            for (int i = 0; i < 8; ++i) {
                this.children[i] = null;
            }
            this.center = new Point3(point3);
            this.sideLength = f;
            this.halfSideLength = 0.5f * f;
            this.quadSideLength = 0.5f * this.halfSideLength;
            this.first = null;
        }

        final boolean isInside(Point3 point3) {
            return Math.abs(point3.x - this.center.x) < this.halfSideLength && Math.abs(point3.y - this.center.y) < this.halfSideLength && Math.abs(point3.z - this.center.z) < this.halfSideLength;
        }

        final float find(Sample sample) {
            float f = 0.0f;
            Sample sample2 = this.first;
            while (sample2 != null) {
                float f2;
                float f3 = 1.0f - (sample.nix * sample2.nix + sample.niy * sample2.niy + sample.niz * sample2.niz);
                float f4 = (sample.pix - sample2.pix) * (sample.pix - sample2.pix) + (sample.piy - sample2.piy) * (sample.piy - sample2.piy) + (sample.piz - sample2.piz) * (sample.piz - sample2.piz);
                if (!(f3 > IrradianceCacheGIEngine.this.tolerance * IrradianceCacheGIEngine.this.tolerance) && !(f4 > IrradianceCacheGIEngine.this.maxSpacing * IrradianceCacheGIEngine.this.maxSpacing) && ((f2 = (float)(Math.sqrt(f4) * (double)sample2.invR0 + Math.sqrt(Math.max(f3, 0.0f)))) < IrradianceCacheGIEngine.this.tolerance || f4 < IrradianceCacheGIEngine.this.minSpacing * IrradianceCacheGIEngine.this.minSpacing)) {
                    float f5 = Math.min(1.0E10f, 1.0f / f2);
                    if (sample.irr != null) {
                        sample.irr.madd(f5, sample2.irr);
                    } else {
                        sample.irr = sample2.irr.copy().mul(f5);
                    }
                    f += f5;
                }
                sample2 = sample2.next;
            }
            for (int i = 0; i < 8; ++i) {
                if (this.children[i] == null || !(Math.abs(this.children[i].center.x - sample.pix) <= this.halfSideLength) || !(Math.abs(this.children[i].center.y - sample.piy) <= this.halfSideLength) || !(Math.abs(this.children[i].center.z - sample.piz) <= this.halfSideLength)) continue;
                f += this.children[i].find(sample);
            }
            return f;
        }
    }
}

