/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class SonyResultConvert
extends GPSLogConvertInterface {
    private boolean passToFindFieldsActivatedInLog = false;
    private int error;

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            object = (WindowedFile)object;
            GPSRecord.getLogFormatRecord(0);
            new GPSRecord();
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(29));
            }
            int n = 0;
            int n2 = 0;
            int n3 = ((WindowedFile)object).getSize();
            while (!this.stop && n2 + 26 < n3) {
                byte[] byArray;
                int n4 = 4096;
                if (n2 + 4096 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                try {
                    byArray = ((WindowedFile)object).fillBuffer(n2);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = ((WindowedFile)object).getPath() + "|" + ((WindowedFile)object).getLastError();
                    return -3;
                }
                block11: while (!this.stop && n5 + 26 < n4) {
                    int n6 = (byArray[n5] & 0xFF) << 8 | byArray[n5 + 1];
                    switch (n6) {
                        case 0: {
                            n5 += 2;
                            continue block11;
                        }
                        case 21068: {
                            n5 += 12;
                            continue block11;
                        }
                        case 21060: {
                            int n7 = n5;
                            Object object2 = byArray;
                            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
                            n7 += 2;
                            ++n7;
                            int n8 = ++n7;
                            int n9 = ++n7;
                            int n10 = ++n7;
                            int n11 = ++n7;
                            int n12 = ++n7;
                            int n13 = ++n7;
                            int n14 = ++n7;
                            int n15 = ++n7;
                            long l = (0xFFL & (long)object2[n8]) << 56 | (0xFFL & (long)object2[n9]) << 48 | (0xFFL & (long)object2[n10]) << 40 | (0xFFL & (long)object2[n11]) << 32 | (0xFFL & (long)object2[n12]) << 24 | (0xFFL & (long)object2[n13]) << 16 | (0xFFL & (long)object2[n14]) << 8 | 0xFFL & (long)object2[n15];
                            gPSRecord.longitude = JavaLibBridge.longBitsToDouble(l);
                            int n16 = ++n7;
                            int n17 = ++n7;
                            int n18 = ++n7;
                            int n19 = ++n7;
                            int n20 = ++n7;
                            int n21 = ++n7;
                            int n22 = ++n7;
                            int n23 = ++n7;
                            long l2 = (0xFFL & (long)object2[n16]) << 56 | (0xFFL & (long)object2[n17]) << 48 | (0xFFL & (long)object2[n18]) << 40 | (0xFFL & (long)object2[n19]) << 32 | (0xFFL & (long)object2[n20]) << 24 | (0xFFL & (long)object2[n21]) << 16 | (0xFFL & (long)object2[n22]) << 8 | 0xFFL & (long)object2[n23];
                            gPSRecord.latitude = JavaLibBridge.longBitsToDouble(l2);
                            int n24 = ++n7;
                            int n25 = ++n7;
                            gPSRecord.height = ((0xFF & object2[n24]) << 24 >> 16 | 0xFF & object2[n25]) * 10;
                            gPSRecord.utc = (0xFF & object2[++n7]) << 24 | (0xFF & object2[++n7]) << 16 | (0xFF & object2[++n7]) << 8 | 0xFF & object2[++n7];
                            gPSRecord.milisecond = 10 * (gPSRecord.utc % 100);
                            gPSRecord.utc /= 100;
                            object2 = gPSRecord;
                            gPSRecord.recCount = ++n;
                            gPSFileConverterInterface.addLogRecord((GPSRecord)object2);
                            n5 += 26;
                            continue block11;
                        }
                        case 21057: 
                        case 21072: 
                        case 21078: {
                            n5 += 8;
                            continue block11;
                        }
                    }
                    Generic.debug("Unknown entry " + JavaLibBridge.unsigned2hex(n6, 4) + "(" + JavaLibBridge.unsigned2hex(n2 + n5, 8) + ")", null);
                    n5 += 2;
                }
                n2 += n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    protected final Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(4096);
                this.errorInfo = bT747Path.toString() + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected final void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(29));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public final int getType() {
        return 20;
    }
}

