/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.io;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;

public class Native2ASCIIEncoding
implements Encoding {
    private final CharsetEncoder asciiEncoder = Charset.forName("ASCII").newEncoder();
    private final CharsetEncoding asciiEncoding = new CharsetEncoding("ASCII");

    @Override
    @Nonnull
    public Reader getTextReader(@Nonnull InputStream inputStream) throws IOException {
        return new Native2ASCIIReader(inputStream, false);
    }

    @Override
    @Nonnull
    public Writer getTextWriter(@Nonnull OutputStream outputStream) throws IOException {
        return new FilterWriter(this.asciiEncoding.getTextWriter(outputStream)){

            @Override
            @Nonnull
            public Writer append(@Nullable CharSequence charSequence) throws IOException {
                this.write(charSequence == null ? "null" : charSequence.toString());
                return this;
            }

            @Override
            @Nonnull
            public Writer append(@Nullable CharSequence charSequence, int n, int n2) throws IOException {
                CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
                this.write(charSequence2.subSequence(n, n2).toString());
                return this;
            }

            @Override
            @Nonnull
            public Writer append(char c) throws IOException {
                this.write(c);
                return this;
            }

            @Override
            public void write(@Nonnull String string) throws IOException {
                this.write(string, 0, string.length());
            }

            @Override
            public void write(@Nonnull char[] cArray) throws IOException {
                this.write(cArray, 0, cArray.length);
            }

            @Override
            public void write(@Nonnull String string, int n, int n2) throws IOException {
                this.write(string.substring(n, n + n2).toCharArray());
            }

            @Override
            public void write(@Nonnull char[] cArray, int n, int n2) throws IOException {
                char[] cArray2 = new char[n2 * 6];
                int n3 = 0;
                int n4 = n + n2;
                for (int i = n; i < n4; ++i) {
                    char c = cArray[i];
                    if (Native2ASCIIEncoding.this.asciiEncoder.canEncode(c)) {
                        cArray2[n3++] = c;
                        continue;
                    }
                    System.arraycopy(String.format("\\u%04X", c).toCharArray(), 0, cArray2, n3, 6);
                    n3 += 6;
                }
                super.write(cArray2, 0, n3);
            }

            @Override
            public void write(int n) throws IOException {
                if (Native2ASCIIEncoding.this.asciiEncoder.canEncode((char)n)) {
                    super.write(n);
                } else {
                    this.write(String.format("\\u%04X", n));
                }
            }
        };
    }

    @Override
    @Nonnull
    public Reader getPermissiveTextReader(@Nonnull InputStream inputStream) throws IOException {
        return new Native2ASCIIReader(inputStream, true);
    }

    @Nonnull
    Reader getTextReader(@Nonnull InputStream inputStream, @Nullable Class<? extends PushbackReader> clazz) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new Native2ASCIIReader(inputStream, false, clazz);
    }

    @Nonnull
    Reader getPermissiveTextReader(@Nonnull InputStream inputStream, @Nullable Class<? extends PushbackReader> clazz) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new Native2ASCIIReader(inputStream, true, clazz);
    }

    private static class Native2ASCIIReader
    extends FilterReader {
        private static final int MAX_SKIP_BUFFER_SIZE = 8192;
        private static final Encoding iso_8859_1Encoding = new CharsetEncoding("ISO-8859-1");
        private PushbackReader in;
        private boolean permissive;
        private char[] skipBuffer;
        private boolean escaped;

        private Native2ASCIIReader(@Nonnull InputStream inputStream, boolean bl) throws IOException {
            super(new PushbackReader(iso_8859_1Encoding.getTextReader(inputStream), 5));
            this.in = (PushbackReader)((FilterReader)this).in;
            this.permissive = bl;
        }

        private Native2ASCIIReader(@Nonnull InputStream inputStream, boolean bl, @Nullable Class<? extends PushbackReader> clazz) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
            super(clazz == null ? new PushbackReader(iso_8859_1Encoding.getTextReader(inputStream), 5) : (Reader)clazz.getConstructor(Reader.class, Integer.TYPE).newInstance(iso_8859_1Encoding.getTextReader(inputStream), 5));
            this.in = (PushbackReader)((FilterReader)this).in;
            this.permissive = bl;
        }

        @Override
        public int read() throws IOException {
            int n;
            int n2 = this.in.read();
            if (n2 != 92 || this.escaped) {
                this.escaped = false;
                return n2;
            }
            int n3 = this.in.read();
            if (n3 == -1) {
                return n2;
            }
            if (n3 != 117) {
                this.escaped = true;
                this.in.unread(n3);
                return n2;
            }
            char[] cArray = new char[]{'u', '\u0000', '\u0000', '\u0000', '\u0000'};
            n3 = 1 + this.in.read(cArray, 1, 4);
            if (n3 == 0) {
                if (this.permissive) {
                    this.escaped = true;
                    this.in.unread(117);
                    return n2;
                }
                throw new MalformedInputException(1);
            }
            while (n3 < 5) {
                n = this.in.read(cArray, n3, 5 - n3);
                if (n == -1) {
                    if (this.permissive) {
                        this.escaped = true;
                        this.in.unread(cArray, 0, n3);
                        return n2;
                    }
                    throw new MalformedInputException(1);
                }
                n3 += n;
            }
            for (n = 1; n < 5; ++n) {
                char c = cArray[n];
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                if (this.permissive) {
                    this.escaped = true;
                    this.in.unread(cArray, 0, n3);
                    return n2;
                }
                throw new MalformedInputException(1);
            }
            this.escaped = false;
            return Integer.parseInt(new String(cArray, 1, 4), 16);
        }

        @Override
        public int read(CharBuffer charBuffer) throws IOException {
            int n = charBuffer.remaining();
            char[] cArray = new char[n];
            int n2 = this.read(cArray, 0, n);
            if (n2 > 0) {
                charBuffer.put(cArray, 0, n2);
            }
            return n2;
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            return this.readn(cArray, n, n2);
        }

        private int readn(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2 + 5;
            char[] cArray2 = new char[n4];
            int n5 = this.in.read(cArray2);
            if (n5 == -1) {
                return n5;
            }
            int n6 = 0;
            int n7 = 0;
            block0: for (n3 = 0; n3 < n5 && n3 < n2; ++n3) {
                int n8;
                char c = cArray2[n3];
                if (c != '\\' || this.escaped) {
                    this.escaped = false;
                    cArray[n + n6++] = c;
                    continue;
                }
                if (n5 - n3 - 1 < 5) {
                    while (n5 < n3 + 1 + 5) {
                        n8 = this.in.read(cArray2, n5, n3 + 1 + 5 - n5);
                        if (n8 == -1) {
                            if (this.permissive || n5 - n3 - 1 == 0 || cArray2[n3 + 1] != 'u') {
                                this.escaped = true;
                                cArray[n + n6++] = c;
                                continue block0;
                            }
                            throw new MalformedInputException(1);
                        }
                        n5 += n8;
                    }
                }
                if (cArray2[n3 + 1] != 'u') {
                    this.escaped = true;
                    cArray[n + n6++] = c;
                    continue;
                }
                int n9 = n3 + 6;
                for (n8 = n3 + 2; n8 < n9; ++n8) {
                    char c2 = cArray2[n8];
                    if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') continue;
                    if (this.permissive) {
                        this.escaped = true;
                        cArray[n + n6++] = c;
                        continue block0;
                    }
                    throw new MalformedInputException(1);
                }
                this.escaped = false;
                cArray[n + n6++] = (char)Integer.parseInt(new String(cArray2, n3 + 2, 4), 16);
                n7 += Math.min(n2 - n3 - 1, 5);
                n3 += 5;
            }
            this.in.unread(cArray2, n3, n5 - n3);
            if (n7 == 0) {
                return n6;
            }
            n5 = this.readn(cArray, n + n6, n7);
            if (n5 == -1) {
                return n6;
            }
            return n6 + n5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            long l2;
            if (l < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            int n = (int)Math.min(l, 8192L);
            if (this.skipBuffer == null || this.skipBuffer.length < n) {
                this.skipBuffer = new char[n];
            }
            PushbackReader pushbackReader = this.in;
            synchronized (pushbackReader) {
                int n2;
                for (l2 = l; l2 > 0L && (n2 = this.read(this.skipBuffer, 0, (int)Math.min(l2, (long)n))) != -1; l2 -= (long)n2) {
                }
            }
            return l - l2;
        }
    }
}

