/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.OutputStream;
import java.util.Arrays;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;
    private boolean myIsShared;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this(new byte[size]);
    }

    public UnsyncByteArrayOutputStream(byte[] buffer) {
        this.myBuffer = buffer;
    }

    @Override
    public void write(int b) {
        int newcount = this.myCount + 1;
        if (newcount > this.myBuffer.length || this.myIsShared) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, newcount > this.myBuffer.length ? Math.max(this.myBuffer.length << 1, newcount) : this.myBuffer.length);
            this.myIsShared = false;
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.myCount + len;
        if (newcount > this.myBuffer.length || this.myIsShared) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, newcount > this.myBuffer.length ? Math.max(this.myBuffer.length << 1, newcount) : this.myBuffer.length);
            this.myIsShared = false;
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = newcount;
    }

    public void reset() {
        this.myCount = 0;
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount);
    }
}

