/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.annotations.jvm.ReadOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessor;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.IntervalMetaInfo;
import org.jetbrains.kotlin.codegen.inline.IntervalWithHandler;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.MaxLocalsCalculator;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.TryBlockCluster;
import org.jetbrains.kotlin.codegen.inline.TryBlockClusteringKt;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodePosition;
import org.jetbrains.kotlin.codegen.inline.TryCatchPosition;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InternalFinallyBlockInliner
extends CoveringTryCatchNodeProcessor {
    @NotNull
    private final MethodNode inlineFun;

    public static void processInlineFunFinallyBlocks(@NotNull MethodNode inlineFun, int lambdaTryCatchBlockNodes, int finallyParamOffset) {
        int index2 = 0;
        ArrayList<TryCatchBlockNodeInfo> inlineFunTryBlockInfo = new ArrayList<TryCatchBlockNodeInfo>();
        for (TryCatchBlockNode block : inlineFun.tryCatchBlocks) {
            inlineFunTryBlockInfo.add(new TryCatchBlockNodeInfo(block, index2++ < lambdaTryCatchBlockNodes));
        }
        ArrayList<LocalVarNodeWrapper> localVars = new ArrayList<LocalVarNodeWrapper>();
        for (LocalVariableNode var : inlineFun.localVariables) {
            localVars.add(new LocalVarNodeWrapper(var));
        }
        if (InternalFinallyBlockInliner.hasFinallyBlocks(inlineFunTryBlockInfo)) {
            new InternalFinallyBlockInliner(inlineFun, inlineFunTryBlockInfo, localVars, finallyParamOffset).processInlineFunFinallyBlocks();
        }
    }

    private InternalFinallyBlockInliner(@NotNull MethodNode inlineFun, @NotNull List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo, @NotNull List<LocalVarNodeWrapper> localVariableInfo, int finallyParamOffset) {
        super(finallyParamOffset);
        this.inlineFun = inlineFun;
        for (TryCatchBlockNodeInfo block : inlineFunTryBlockInfo) {
            this.getTryBlocksMetaInfo().addNewInterval(block);
        }
        for (LocalVarNodeWrapper wrapper : localVariableInfo) {
            this.getLocalVarsMetaInfo().addNewInterval(wrapper);
        }
    }

    private int initAndGetVarIndexForNonLocalReturnValue() {
        MaxLocalsCalculator tempCalcNode = new MaxLocalsCalculator(458752, this.inlineFun.access, this.inlineFun.desc, null);
        this.inlineFun.accept(tempCalcNode);
        return tempCalcNode.getMaxLocals();
    }

    private void processInlineFunFinallyBlocks() {
        int nextTempNonLocalVarIndex = this.initAndGetVarIndexForNonLocalReturnValue();
        InsnList instructions = this.inlineFun.instructions;
        AbstractInsnNode curIns = instructions.getLast();
        while (curIns != null) {
            this.processInstruction(curIns, false);
            if (!InlineCodegenUtilsKt.isReturnOpcode(curIns.getOpcode()) || !InlineCodegenUtilsKt.isMarkedReturn(curIns)) {
                curIns = curIns.getPrevious();
                continue;
            }
            List<TryCatchBlockNodeInfo> currentCoveringNodesFromInnermost = this.sortTryCatchBlocks(new ArrayList<TryCatchBlockNodeInfo>(this.getTryBlocksMetaInfo().getCurrentIntervals()));
            InternalFinallyBlockInliner.checkCoveringBlocksInvariant(Lists.reverse(currentCoveringNodesFromInnermost));
            if (currentCoveringNodesFromInnermost.isEmpty() || currentCoveringNodesFromInnermost.get(currentCoveringNodesFromInnermost.size() - 1).getOnlyCopyNotProcess()) {
                curIns = curIns.getPrevious();
                continue;
            }
            AbstractInsnNode markedReturn = curIns;
            AbstractInsnNode instrInsertFinallyBefore = markedReturn.getPrevious();
            AbstractInsnNode nextPrev = instrInsertFinallyBefore.getPrevious();
            assert (markedReturn.getNext() instanceof LabelNode) : "Label should be occurred after non-local return";
            LabelNode newFinallyEnd = (LabelNode)markedReturn.getNext();
            Type nonLocalReturnType = InlineCodegenUtilsKt.getReturnType(markedReturn.getOpcode());
            List<TryBlockCluster<TryCatchBlockNodeInfo>> clustersFromInnermost = TryBlockClusteringKt.doClustering(currentCoveringNodesFromInnermost);
            Iterator<TryBlockCluster<TryCatchBlockNodeInfo>> tryCatchBlockIterator = clustersFromInnermost.iterator();
            InternalFinallyBlockInliner.checkClusterInvariant(clustersFromInnermost);
            int originalDepthIndex = 0;
            while (tryCatchBlockIterator.hasNext()) {
                boolean generateAloadAstore;
                TryBlockCluster<TryCatchBlockNodeInfo> clusterToFindFinally = tryCatchBlockIterator.next();
                List<TryCatchBlockNodeInfo> clusterBlocks = clusterToFindFinally.getBlocks();
                TryCatchBlockNodeInfo nodeWithDefaultHandlerIfExists = clusterBlocks.get(clusterBlocks.size() - 1);
                FinallyBlockInfo finallyInfo = this.findFinallyBlockBody(nodeWithDefaultHandlerIfExists, this.getTryBlocksMetaInfo().getAllIntervals());
                if (finallyInfo == null) continue;
                if (nodeWithDefaultHandlerIfExists.getOnlyCopyNotProcess()) {
                    throw new RuntimeException("Lambda try blocks should be skipped");
                }
                ++originalDepthIndex;
                instructions.resetLabels();
                List<TryCatchBlockNodePosition> tryCatchBlockInlinedInFinally = this.findTryCatchBlocksInlinedInFinally(finallyInfo);
                MethodNode finallyBlockCopy = InlineCodegenUtilsKt.createEmptyMethodNode();
                Label newFinallyStart = new Label();
                Label insertedBlockEnd = new Label();
                boolean bl = generateAloadAstore = nonLocalReturnType != Type.VOID_TYPE && !finallyInfo.isEmpty();
                if (generateAloadAstore) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(54), nextTempNonLocalVarIndex);
                }
                finallyBlockCopy.visitLabel(newFinallyStart);
                Set<LabelNode> labelsInsideFinally = InternalFinallyBlockInliner.rememberOriginalLabelNodes(finallyInfo);
                for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
                    boolean isInsOrJumpInsideFinally = !(currentIns instanceof JumpInsnNode) || labelsInsideFinally.contains(((JumpInsnNode)currentIns).label);
                    InternalFinallyBlockInliner.copyInstruction(finallyBlockCopy, currentIns, isInsOrJumpInsideFinally, originalDepthIndex);
                }
                if (generateAloadAstore) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(21), nextTempNonLocalVarIndex);
                    nextTempNonLocalVarIndex += nonLocalReturnType.getSize();
                }
                finallyBlockCopy.visitLabel(insertedBlockEnd);
                InlineCodegenUtilsKt.insertNodeBefore(finallyBlockCopy, this.inlineFun, instrInsertFinallyBefore);
                this.updateExceptionTable(clusterBlocks, newFinallyStart, newFinallyEnd, tryCatchBlockInlinedInFinally, labelsInsideFinally, (LabelNode)insertedBlockEnd.info);
            }
            for (curIns = markedReturn.getPrevious(); curIns != null && curIns != nextPrev; curIns = curIns.getPrevious()) {
                this.processInstruction(curIns, false);
            }
            if (instrInsertFinallyBefore.getPrevious() == nextPrev || curIns == null) continue;
            LabelNode startNode = new LabelNode();
            LabelNode endNode = new LabelNode();
            instructions.insert(curIns, startNode);
            instructions.insert(markedReturn, endNode);
            this.getLocalVarsMetaInfo().splitCurrentIntervals(new SimpleInterval(startNode, endNode), true);
        }
        this.substituteTryBlockNodes(this.inlineFun);
        this.substituteLocalVarTable(this.inlineFun);
    }

    private static void copyInstruction(@NotNull MethodNode finallyBlockCopy, @NotNull AbstractInsnNode currentIns, boolean isInsOrJumpInsideFinally, int depthShift) {
        if (isInsOrJumpInsideFinally) {
            if (InlineCodegenUtilsKt.isFinallyMarker(currentIns.getNext())) {
                Integer constant = InlineCodegenUtilsKt.getConstant(currentIns);
                finallyBlockCopy.visitLdcInsn(constant + depthShift);
            } else {
                currentIns.accept(finallyBlockCopy);
            }
        } else {
            finallyBlockCopy.instructions.add(new JumpInsnNode(currentIns.getOpcode(), ((JumpInsnNode)currentIns).label));
        }
    }

    private static void checkCoveringBlocksInvariant(@ReadOnly @NotNull List<TryCatchBlockNodeInfo> currentCoveringNodesFromOuterMost) {
        boolean isWasOnlyLocal = false;
        for (TryCatchBlockNodeInfo info : currentCoveringNodesFromOuterMost) {
            assert (!isWasOnlyLocal || info.getOnlyCopyNotProcess()) : "There are some problems with try-catch structure";
            isWasOnlyLocal = info.getOnlyCopyNotProcess();
        }
    }

    private static void checkClusterInvariant(List<TryBlockCluster<TryCatchBlockNodeInfo>> clusters) {
        boolean isWasOnlyLocal = false;
        for (TryBlockCluster<TryCatchBlockNodeInfo> cluster : Lists.reverse(clusters)) {
            TryCatchBlockNodeInfo info = cluster.getBlocks().get(0);
            assert (!isWasOnlyLocal || info.getOnlyCopyNotProcess());
            if (!info.getOnlyCopyNotProcess()) continue;
            isWasOnlyLocal = true;
        }
    }

    @NotNull
    private static Set<LabelNode> rememberOriginalLabelNodes(@NotNull FinallyBlockInfo finallyInfo) {
        HashSet<LabelNode> labelsInsideFinally = new HashSet<LabelNode>();
        for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
            if (!(currentIns instanceof LabelNode)) continue;
            labelsInsideFinally.add((LabelNode)currentIns);
        }
        return labelsInsideFinally;
    }

    private void updateExceptionTable(@NotNull List<TryCatchBlockNodeInfo> updatingClusterBlocks, @NotNull Label newFinallyStart, @NotNull LabelNode newFinallyEnd, @NotNull List<TryCatchBlockNodePosition> tryCatchBlockPresentInFinally, @NotNull Set<LabelNode> labelsInsideFinally, @NotNull LabelNode insertedBlockEnd) {
        TryBlockCluster singleCluster;
        List<TryBlockCluster<TryCatchBlockNodePosition>> clusters = TryBlockClusteringKt.doClustering(tryCatchBlockPresentInFinally);
        HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>> handler2Cluster = new HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>>();
        IntervalMetaInfo<TryCatchBlockNodeInfo> tryBlocksMetaInfo = this.getTryBlocksMetaInfo();
        for (TryBlockCluster<TryCatchBlockNodePosition> cluster : clusters) {
            TryCatchBlockNodePosition defaultHandler;
            List<TryCatchBlockNodePosition> clusterBlocks = cluster.getBlocks();
            TryCatchBlockNodePosition block0 = clusterBlocks.get(0);
            TryCatchPosition clusterPosition = block0.getPosition();
            if (clusterPosition == TryCatchPosition.INNER) {
                for (TryCatchBlockNodePosition position : clusterBlocks) {
                    assert (clusterPosition == position.getPosition()) : "Wrong inner tryCatchBlock structure";
                    TryCatchBlockNode tryCatchBlockNode = position.getNodeInfo().getNode();
                    assert (this.inlineFun.instructions.indexOf(tryCatchBlockNode.start) <= this.inlineFun.instructions.indexOf(tryCatchBlockNode.end));
                    TryCatchBlockNode additionalTryCatchBlock = new TryCatchBlockNode((LabelNode)tryCatchBlockNode.start.getLabel().info, (LabelNode)tryCatchBlockNode.end.getLabel().info, InternalFinallyBlockInliner.getNewOrOldLabel(tryCatchBlockNode.handler, labelsInsideFinally), tryCatchBlockNode.type);
                    assert (this.inlineFun.instructions.indexOf(additionalTryCatchBlock.start) <= this.inlineFun.instructions.indexOf(additionalTryCatchBlock.end));
                    tryBlocksMetaInfo.addNewInterval(new TryCatchBlockNodeInfo(additionalTryCatchBlock, true));
                }
                continue;
            }
            if (clusterPosition == TryCatchPosition.END) {
                defaultHandler = cluster.getDefaultHandler();
                assert (defaultHandler != null) : "Default handler should be present";
                handler2Cluster.put(defaultHandler.getHandler(), cluster);
                continue;
            }
            assert (clusterPosition == TryCatchPosition.START);
            defaultHandler = cluster.getDefaultHandler();
            assert (defaultHandler != null) : "Default handler should be present";
            TryBlockCluster endCluster = (TryBlockCluster)handler2Cluster.remove(defaultHandler.getHandler());
            assert (endCluster != null) : "Could find start cluster for  " + (Object)((Object)clusterPosition);
            Iterator<TryCatchBlockNodePosition> startBlockPositions = clusterBlocks.iterator();
            for (TryCatchBlockNodePosition endBlockPosition : endCluster.getBlocks()) {
                TryCatchBlockNodeInfo startNode = startBlockPositions.next().getNodeInfo();
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                assert (Objects.equal(startNode.getType(), endNode.getType())) : "Different handler types : " + startNode.getType() + " " + endNode.getType();
                this.getTryBlocksMetaInfo().split(endNode, new SimpleInterval((LabelNode)endNode.getNode().end.getLabel().info, (LabelNode)startNode.getStartLabel().getLabel().info), false);
            }
        }
        if (handler2Cluster.size() == 1 && ((TryCatchBlockNodePosition)(singleCluster = (TryBlockCluster)handler2Cluster.values().iterator().next()).getBlocks().get(0)).getPosition() == TryCatchPosition.END) {
            for (TryCatchBlockNodePosition endBlockPosition : singleCluster.getBlocks()) {
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                this.getTryBlocksMetaInfo().split(endNode, new SimpleInterval((LabelNode)endNode.getNode().end.getLabel().info, (LabelNode)insertedBlockEnd.getLabel().info), false);
            }
            handler2Cluster.clear();
        }
        assert (handler2Cluster.isEmpty()) : "Unmatched clusters " + handler2Cluster.size();
        SimpleInterval splitBy = new SimpleInterval((LabelNode)newFinallyStart.info, newFinallyEnd);
        for (TryCatchBlockNodeInfo block : updatingClusterBlocks) {
            SplitPair<TryCatchBlockNodeInfo> split = tryBlocksMetaInfo.splitAndRemoveIntervalFromCurrents(block, splitBy, false);
            this.checkFinally(split.getNewPart());
            this.checkFinally(split.getPatchedPart());
            assert (!block.isEmpty()) : "Finally block should be non-empty";
        }
        this.sortTryCatchBlocks(tryBlocksMetaInfo.getAllIntervals());
    }

    private static LabelNode getNewOrOldLabel(LabelNode oldHandler, @NotNull Set<LabelNode> labelsInsideFinally) {
        if (labelsInsideFinally.contains(oldHandler)) {
            return (LabelNode)oldHandler.getLabel().info;
        }
        return oldHandler;
    }

    private static boolean hasFinallyBlocks(List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo) {
        for (TryCatchBlockNodeInfo block : inlineFunTryBlockInfo) {
            if (block.getOnlyCopyNotProcess() || block.getNode().type != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private FinallyBlockInfo findFinallyBlockBody(@NotNull TryCatchBlockNodeInfo tryCatchBlock, @ReadOnly @NotNull List<TryCatchBlockNodeInfo> tryCatchBlocks) {
        ArrayList<TryCatchBlockNodeInfo> sameDefaultHandler = new ArrayList<TryCatchBlockNodeInfo>();
        LabelNode defaultHandler = null;
        boolean afterStartBlock = false;
        for (TryCatchBlockNodeInfo block : tryCatchBlocks) {
            if (tryCatchBlock == block) {
                afterStartBlock = true;
            }
            if (!afterStartBlock || block.getNode().type != null || (InlineCodegenUtilsKt.firstLabelInChain(tryCatchBlock.getNode().start) != InlineCodegenUtilsKt.firstLabelInChain(block.getNode().start) || InlineCodegenUtilsKt.firstLabelInChain(tryCatchBlock.getNode().end) != InlineCodegenUtilsKt.firstLabelInChain(block.getNode().end)) && defaultHandler != InlineCodegenUtilsKt.firstLabelInChain(block.getNode().handler)) continue;
            sameDefaultHandler.add(block);
            if (defaultHandler != null) continue;
            defaultHandler = InlineCodegenUtilsKt.firstLabelInChain(block.getNode().handler);
        }
        if (sameDefaultHandler.isEmpty()) {
            return null;
        }
        TryCatchBlockNodeInfo nextIntervalWithSameDefaultHandler = (TryCatchBlockNodeInfo)sameDefaultHandler.get(1);
        LabelNode startFinallyChain = tryCatchBlock.getNode().end;
        AbstractInsnNode meaningful = MethodInlinerUtilKt.getNextMeaningful(startFinallyChain);
        assert (meaningful != null) : "Can't find meaningful in finally block" + startFinallyChain;
        Integer finallyDepth = InlineCodegenUtilsKt.getConstant(meaningful);
        AbstractInsnNode endFinallyChainExclusive = nextIntervalWithSameDefaultHandler.getNode().start;
        AbstractInsnNode current = meaningful.getNext();
        while (endFinallyChainExclusive != current) {
            Integer currentDepth;
            if (!InlineCodegenUtilsKt.isFinallyEnd(current = current.getNext()) || !(currentDepth = Integer.valueOf(InlineCodegenUtilsKt.getConstant(current.getPrevious()))).equals(finallyDepth)) continue;
            endFinallyChainExclusive = current.getNext();
            break;
        }
        FinallyBlockInfo finallyInfo = new FinallyBlockInfo(startFinallyChain.getNext(), endFinallyChainExclusive);
        this.checkFinally(finallyInfo);
        return finallyInfo;
    }

    private void checkFinally(FinallyBlockInfo finallyInfo) {
        this.checkFinally(finallyInfo.startIns, finallyInfo.endInsExclusive);
    }

    private void checkFinally(IntervalWithHandler intervalWithHandler) {
        this.checkFinally(intervalWithHandler.getStartLabel(), intervalWithHandler.getEndLabel());
    }

    private void checkFinally(AbstractInsnNode startIns, AbstractInsnNode endInsExclusive) {
        if (this.inlineFun.instructions.indexOf(startIns) >= this.inlineFun.instructions.indexOf(endInsExclusive)) {
            throw new AssertionError((Object)("Inconsistent finally: block end occurs before start " + InternalFinallyBlockInliner.traceInterval(endInsExclusive, startIns)));
        }
    }

    @NotNull
    private List<TryCatchBlockNodePosition> findTryCatchBlocksInlinedInFinally(@NotNull FinallyBlockInfo finallyInfo) {
        ArrayList<TryCatchBlockNodePosition> result2 = new ArrayList<TryCatchBlockNodePosition>();
        HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition> processedBlocks = new HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition>();
        for (AbstractInsnNode curInstr = finallyInfo.startIns; curInstr != finallyInfo.endInsExclusive; curInstr = curInstr.getNext()) {
            if (!(curInstr instanceof LabelNode)) continue;
            LabelNode curLabel = (LabelNode)curInstr;
            List<TryCatchBlockNodeInfo> startedTryBlocks = this.getStartNodes(curLabel);
            for (TryCatchBlockNodeInfo block : startedTryBlocks) {
                assert (!processedBlocks.containsKey(block)) : "Try catch block already processed before start label!!! " + block;
                TryCatchBlockNodePosition info = new TryCatchBlockNodePosition(block, TryCatchPosition.START);
                processedBlocks.put(block, info);
                result2.add(info);
            }
            List<TryCatchBlockNodeInfo> endedTryBlocks = this.getEndNodes(curLabel);
            for (TryCatchBlockNodeInfo block : endedTryBlocks) {
                TryCatchBlockNodePosition info = (TryCatchBlockNodePosition)processedBlocks.get(block);
                if (info != null) {
                    assert (info.getPosition() == TryCatchPosition.START);
                    info.setPosition(TryCatchPosition.INNER);
                    continue;
                }
                info = new TryCatchBlockNodePosition(block, TryCatchPosition.END);
                processedBlocks.put(block, info);
                result2.add(info);
            }
        }
        return result2;
    }

    @Override
    public int instructionIndex(@NotNull AbstractInsnNode inst) {
        return this.inlineFun.instructions.indexOf(inst);
    }

    private static String traceInterval(AbstractInsnNode startNode, AbstractInsnNode stopNode) {
        Textifier p = new Textifier();
        TraceMethodVisitor visitor2 = new TraceMethodVisitor(p);
        while (startNode != stopNode) {
            startNode.accept(visitor2);
            startNode = startNode.getNext();
        }
        startNode.accept(visitor2);
        StringWriter out = new StringWriter();
        p.print(new PrintWriter(out));
        return out.toString();
    }

    private static class FinallyBlockInfo {
        final AbstractInsnNode startIns;
        final AbstractInsnNode endInsExclusive;

        private FinallyBlockInfo(@NotNull AbstractInsnNode inclusiveStart, @NotNull AbstractInsnNode exclusiveEnd) {
            this.startIns = inclusiveStart;
            this.endInsExclusive = exclusiveEnd;
        }

        public boolean isEmpty() {
            AbstractInsnNode end;
            if (!(this.startIns instanceof LabelNode)) {
                return false;
            }
            for (end = this.endInsExclusive; end != this.startIns && end instanceof LabelNode; end = end.getPrevious()) {
            }
            return this.startIns == end;
        }
    }
}

