/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.ReplicaGroupDescriptor;
import com.zeroc.IceGridGUI.Application.ListTreeNode;
import com.zeroc.IceGridGUI.Application.ReplicaGroup;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;

class ReplicaGroups
extends ListTreeNode {
    private List<ReplicaGroupDescriptor> _descriptors;
    private static JPopupMenu _popup;

    public static List<ReplicaGroupDescriptor> copyDescriptors(List<ReplicaGroupDescriptor> descriptors) {
        LinkedList<ReplicaGroupDescriptor> copy = new LinkedList<ReplicaGroupDescriptor>();
        for (ReplicaGroupDescriptor p : descriptors) {
            copy.add(ReplicaGroup.copyDescriptor(p));
        }
        return copy;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof ReplicaGroupDescriptor;
        }
        actions[4] = true;
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(4));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void newReplicaGroup() {
        ReplicaGroupDescriptor descriptor = new ReplicaGroupDescriptor(this.makeNewChildId("NewReplicaGroup"), null, "", new LinkedList(), "", "");
        this.newReplicaGroup(descriptor);
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        ReplicaGroupDescriptor d = ReplicaGroup.copyDescriptor((ReplicaGroupDescriptor)descriptor);
        d.id = this.makeNewChildId(d.id);
        this.newReplicaGroup(d);
    }

    ReplicaGroups(TreeNode parent, List<ReplicaGroupDescriptor> desc) throws UpdateFailedException {
        super(false, parent, "Replica Groups");
        this._descriptors = desc;
        for (ReplicaGroupDescriptor p : this._descriptors) {
            this.insertChild(new ReplicaGroup(false, this, p), false);
        }
    }

    LinkedList<ReplicaGroupDescriptor> getUpdates() {
        LinkedList<ReplicaGroupDescriptor> updates = new LinkedList<ReplicaGroupDescriptor>();
        for (TreeNodeBase p : this._children) {
            ReplicaGroup ra = (ReplicaGroup)p;
            if (!ra.getEditable().isNew() && !ra.getEditable().isModified()) continue;
            updates.add((ReplicaGroupDescriptor)ra.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        for (TreeNodeBase p : this._children) {
            ReplicaGroup rg = (ReplicaGroup)p;
            rg.commit();
        }
    }

    void update(List<ReplicaGroupDescriptor> descriptors, String[] removeReplicaGroups) {
        this._descriptors = descriptors;
        this.removeChildren(removeReplicaGroups);
        ArrayList<ReplicaGroup> updatedChildren = new ArrayList<ReplicaGroup>();
        for (ReplicaGroupDescriptor p : descriptors) {
            ReplicaGroup child = (ReplicaGroup)this.findChild(p.id);
            if (child == null) {
                try {
                    this.insertChild(new ReplicaGroup(false, this, p), true);
                    continue;
                }
                catch (UpdateFailedException e) {
                    assert (false);
                    continue;
                }
            }
            child.rebuild(p);
            updatedChildren.add(child);
        }
        this.childrenChanged(updatedChildren);
    }

    @Override
    Object getDescriptor() {
        return this._descriptors;
    }

    void removeDescriptor(Object descriptor) {
        Iterator<ReplicaGroupDescriptor> p = this._descriptors.iterator();
        while (p.hasNext()) {
            if (descriptor != p.next()) continue;
            p.remove();
            break;
        }
    }

    void tryAdd(ReplicaGroupDescriptor descriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertChild(new ReplicaGroup(true, this, descriptor), true);
        if (addDescriptor) {
            this._descriptors.add(descriptor);
        }
    }

    private void newReplicaGroup(ReplicaGroupDescriptor descriptor) {
        ReplicaGroup replicaGroup;
        block2: {
            replicaGroup = new ReplicaGroup((TreeNode)this, descriptor);
            try {
                this.insertChild(replicaGroup, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(replicaGroup);
    }
}

