/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.kn;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Omsk = new String[] {
               "\u0c93\u0cae\u0ccd\u200c\u0cb8\u0ccd\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "OST",
               "\u0c93\u0cae\u0ccd\u0cb8\u0ccd\u200c\u0c95\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "OST",
               "\u0c93\u0cae\u0ccd\u200c\u200c\u0cb8\u0ccd\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HAST",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "HADT",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf \u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb7\u0cbf\u0caf\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "\u0cb8\u0c96\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SST",
               "\u0cb6\u0cbe\u0c95\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "SST",
               "\u0cb8\u0c96\u0cbe\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c95\u0c9d\u0c95\u0ccd\u200c\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WEST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WEST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "BST",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "BST",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb8\u0cae\u0caf",
               "BT",
            };
        final String[] Hovd = new String[] {
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca6\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HST",
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca1\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "HST",
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca6\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "\u0c85\u0cae\u0cc7\u0c9c\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cae\u0cc7\u0c9c\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cae\u0cc6\u0c9c\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0cbe\u0c9f\u0cca\u0cb0\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "UBST",
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0ca4\u0ccb\u0cb0\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "UBST",
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0cbe\u0c9f\u0cca\u0cb0\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0c87\u0c82\u0ca1\u0cca\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb8\u0cae\u0caf",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PST",
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "PDT",
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WAST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WAST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cae\u0caf",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NST",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "NDT",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "VT",
            };
        final String[] America_Central = new String[] {
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Argentina = new String[] {
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "LHST",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "LHDT",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0cc6 \u0cb8\u0cae\u0caf",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "\u0cae\u0c95\u0ccd\u0cb5\u0cbe\u0cb0\u0cbf \u0cb8\u0cae\u0caf",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AEDT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "IST",
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cbe\u0cb2\u0ccd\u0cb8\u0ca8\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0c95\u0cbe\u0cb2",
               "CST",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c95\u0c9d\u0c95\u0ccd\u200c\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "EDT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0cb8\u0cae\u0caf",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AWDT",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACWDT",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cae\u0caf",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0c95\u0ccd\u0cb0\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0c95\u0ccd\u0cb8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "KST",
               "\u0c95\u0ccd\u0cb0\u0cbe\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "KST",
               "\u0c95\u0ccd\u0cb0\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0c95\u0ccd\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0c87\u0c82\u0ca1\u0cca\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0cb8\u0cae\u0caf",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "FNST",
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "FNST",
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cb8\u0cae\u0caf",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NST",
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0c95\u0cbe\u0cb2",
               "NST",
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "MDT",
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CEST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CEST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "CET",
            };
        final String[] India = new String[] {
               "\u0cad\u0cbe\u0cb0\u0ca4\u0cc0\u0caf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Alaska = new String[] {
               "\u0c85\u0cb2\u0cb8\u0ccd\u0c95\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AKST",
               "\u200c\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AKDT",
               "\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACDT",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "CAT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "EEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ADT",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Magadan = new String[] {
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c\u0ca8 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c\u0ca8 \u0cb8\u0cae\u0caf",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "Europe/Samara", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Asia/Colombo", India },
            { "Europe/Volgograd", Volgograd },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Zurich", Europe_Central },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Stockholm", Europe_Central },
            { "America/Cayman", America_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Europe/Warsaw", Europe_Central },
            { "America/Monterrey", America_Central },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
