/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class MultiAxesStaticChart
extends JPanel {
    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            JFrame jFrame = new JFrame(MultiAxesStaticChart.class.getName());
            jFrame.getContentPane().add(new MultiAxesStaticChart());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            jFrame.setSize(600, 600);
            jFrame.setLocation(i % 3 * 200, i / 3 * 100);
            jFrame.setVisible(true);
        }
    }

    private MultiAxesStaticChart() {
        TracePoint2D copyPoint;
        this.setLayout(new BorderLayout());
        Chart2D chart = new Chart2D();
        chart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        Trace2DSimple apples = new Trace2DSimple();
        apples.setColor(Color.RED);
        apples.setName("Apples");
        double time = System.currentTimeMillis();
        for (int i = 0; i < 120; ++i) {
            apples.addPoint(time + (double)(i * 10000), (10.0 + Math.random()) * (double)i);
        }
        Trace2DSimple pears = new Trace2DSimple();
        pears.setColor(Color.BLUE);
        pears.setName("Pears");
        Iterator<TracePoint2D> it = apples.iterator();
        int i = 0;
        while (it.hasNext()) {
            copyPoint = it.next();
            pears.addPoint((double)i * 0.001, copyPoint.getY() + Math.random() * 1000.0);
            ++i;
        }
        Trace2DSimple carrots = new Trace2DSimple();
        carrots.setColor(Color.MAGENTA);
        carrots.setName("Carrots");
        it = apples.iterator();
        i = 0;
        while (it.hasNext()) {
            copyPoint = it.next();
            carrots.addPoint(i * 100, 100.0 - copyPoint.getY());
            ++i;
        }
        AxisLinear yAxisApples = new AxisLinear();
        yAxisApples.getAxisTitle().setTitle("Y-Apples");
        yAxisApples.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear yAxisPears = new AxisLinear();
        yAxisPears.getAxisTitle().setTitle("Y-Pears");
        yAxisPears.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear yAxisCarrots = new AxisLinear();
        yAxisCarrots.getAxisTitle().setTitle("Y-Carrots");
        yAxisCarrots.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart.setAxisYLeft(yAxisApples);
        chart.setAxisYRight(yAxisPears);
        chart.addAxisYLeft(yAxisCarrots);
        AxisLinear xAxisApples = new AxisLinear();
        xAxisApples.getAxisTitle().setTitle("X-Apples");
        xAxisApples.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear xAxisPears = new AxisLinear();
        xAxisPears.getAxisTitle().setTitle("X-Pears");
        xAxisPears.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear xAxisCarrots = new AxisLinear();
        xAxisCarrots.getAxisTitle().setTitle("X-Carrots");
        xAxisCarrots.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart.setAxisXBottom(xAxisApples);
        chart.setAxisXTop(xAxisPears);
        chart.addAxisXBottom(xAxisCarrots);
        chart.addTrace(apples, xAxisApples, yAxisApples);
        chart.addTrace(pears, xAxisPears, yAxisPears);
        chart.addTrace(carrots, xAxisCarrots, yAxisCarrots);
        this.add((Component)new ChartPanel(chart), "Center");
    }
}

