/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collections;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private final Netty4HttpServerTransport serverTransport;
    private final boolean httpPipeliningEnabled;
    private final boolean detailedErrorsEnabled;
    private final ThreadContext threadContext;

    Netty4HttpRequestHandler(Netty4HttpServerTransport serverTransport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        this.serverTransport = serverTransport;
        this.httpPipeliningEnabled = serverTransport.pipelining;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.threadContext = threadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request;
        HttpPipelinedRequest pipelinedRequest;
        if (this.httpPipeliningEnabled && msg instanceof HttpPipelinedRequest) {
            pipelinedRequest = (HttpPipelinedRequest)msg;
            request = (FullHttpRequest)pipelinedRequest.last();
        } else {
            pipelinedRequest = null;
            request = (FullHttpRequest)msg;
        }
        boolean success = false;
        try {
            Netty4HttpChannel innerChannel;
            Netty4HttpRequest innerHttpRequest;
            DefaultFullHttpRequest copy = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), Unpooled.copiedBuffer((ByteBuf)request.content()), request.headers(), request.trailingHeaders());
            Throwable badRequestCause = null;
            try {
                innerHttpRequest = new Netty4HttpRequest(this.serverTransport.xContentRegistry, (FullHttpRequest)copy, ctx.channel());
            }
            catch (RestRequest.ContentTypeHeaderException e) {
                badRequestCause = e;
                innerHttpRequest = this.requestWithoutContentTypeHeader((FullHttpRequest)copy, ctx.channel(), (Exception)badRequestCause);
            }
            catch (RestRequest.BadParameterException e) {
                badRequestCause = e;
                innerHttpRequest = this.requestWithoutParameters((FullHttpRequest)copy, ctx.channel());
            }
            Netty4HttpRequest httpRequest = innerHttpRequest;
            try {
                innerChannel = new Netty4HttpChannel(this.serverTransport, httpRequest, pipelinedRequest, this.detailedErrorsEnabled, this.threadContext);
            }
            catch (IllegalArgumentException e) {
                if (badRequestCause == null) {
                    badRequestCause = e;
                } else {
                    badRequestCause.addSuppressed(e);
                }
                Netty4HttpRequest innerRequest = new Netty4HttpRequest(this.serverTransport.xContentRegistry, Collections.emptyMap(), copy.uri(), (FullHttpRequest)copy, ctx.channel());
                innerChannel = new Netty4HttpChannel(this.serverTransport, innerRequest, pipelinedRequest, this.detailedErrorsEnabled, this.threadContext);
            }
            Netty4HttpChannel channel = innerChannel;
            if (request.decoderResult().isFailure()) {
                this.serverTransport.dispatchBadRequest(httpRequest, (RestChannel)channel, request.decoderResult().cause());
            } else if (badRequestCause != null) {
                this.serverTransport.dispatchBadRequest(httpRequest, (RestChannel)channel, badRequestCause);
            } else {
                this.serverTransport.dispatchRequest(httpRequest, (RestChannel)channel);
            }
            success = true;
        }
        finally {
            if (!success && pipelinedRequest != null) {
                pipelinedRequest.release();
            }
        }
    }

    private Netty4HttpRequest requestWithoutContentTypeHeader(FullHttpRequest request, Channel channel, Exception badRequestCause) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        headersWithoutContentTypeHeader.add(request.headers());
        headersWithoutContentTypeHeader.remove("Content-Type");
        DefaultFullHttpRequest requestWithoutContentTypeHeader = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), request.content(), (HttpHeaders)headersWithoutContentTypeHeader, request.trailingHeaders());
        try {
            return new Netty4HttpRequest(this.serverTransport.xContentRegistry, (FullHttpRequest)requestWithoutContentTypeHeader, channel);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return this.requestWithoutParameters((FullHttpRequest)requestWithoutContentTypeHeader, channel);
        }
    }

    private Netty4HttpRequest requestWithoutParameters(FullHttpRequest request, Channel channel) {
        return new Netty4HttpRequest(this.serverTransport.xContentRegistry, Collections.emptyMap(), request.uri(), request, channel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        this.serverTransport.exceptionCaught(ctx, cause);
    }
}

