/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.lucene.index.FreqTermsEnum;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.significant.GlobalOrdinalsSignificantTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource, SignificantTermsAggregatorFactory>
implements Releasable {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(SignificantTermsAggregatorFactory.class));
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private String indexedFieldName;
    private MappedFieldType fieldType;
    private FilterableTermsEnum termsEnum;
    private int numberOfAggregatorsCreated;
    final Query filter;
    private final int supersetNumDocs;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    public SignificantTermsAggregatorFactory(String name, ValuesSourceConfig<ValuesSource> config, IncludeExclude includeExclude, String executionHint, QueryBuilder filterBuilder, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        if (!config.unmapped()) {
            this.fieldType = config.fieldContext().fieldType();
            this.indexedFieldName = this.fieldType.name();
        }
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.filter = filterBuilder == null ? null : filterBuilder.toFilter(context.getQueryShardContext());
        ContextIndexSearcher searcher = context.searcher();
        this.supersetNumDocs = this.filter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.filter);
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    public long getSupersetNumDocs() {
        return this.supersetNumDocs;
    }

    private FilterableTermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.context.searcher().getIndexReader();
        this.termsEnum = this.numberOfAggregatorsCreated > 1 ? new FreqTermsEnum(reader, field, true, false, this.filter, this.context.bigArrays()) : new FilterableTermsEnum(reader, this.indexedFieldName, 0, this.filter);
        return this.termsEnum;
    }

    private long getBackgroundFrequency(String value) throws IOException {
        Query query = this.fieldType.termQuery(value, this.context.getQueryShardContext());
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            FilterableTermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.filter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.filter, BooleanClause.Occur.FILTER).build();
        }
        return this.context.searcher().count(query);
    }

    public long getBackgroundFrequency(BytesRef termBytes) throws IOException {
        String value = this.config.format().format(termBytes).toString();
        return this.getBackgroundFrequency(value);
    }

    public long getBackgroundFrequency(long termNum) throws IOException {
        String value = this.config.format().format(termNum).toString();
        return this.getBackgroundFrequency(value);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return SignificantTermsAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        ++this.numberOfAggregatorsCreated;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize(), this.context.numberOfShards() == 1));
        }
        if (valuesSource instanceof ValuesSource.Bytes) {
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint, DEPRECATION_LOGGER);
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = ExecutionMode.GLOBAL_ORDINALS;
            }
            assert (execution != null);
            DocValueFormat format = this.config.format();
            if (this.includeExclude != null && this.includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(this.name, this.factories, valuesSource, format, bucketCountThresholds, this.includeExclude, this.context, parent, this.significanceHeuristic, this, pipelineAggregators, metaData);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            IncludeExclude.LongFilter longFilter = null;
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter(this.config.format());
            }
            return new SignificantLongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), bucketCountThresholds, this.context, parent, this.significanceHeuristic, this, longFilter, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("significant_terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    @Override
    public void close() {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new SignificantStringTermsAggregator(name, factories, valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, significanceHeuristic, termsAggregatorFactory, pipelineAggregators, metaData);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                boolean remapGlobalOrd = true;
                if (!Aggregator.descendsFromBucketAggregator(parent) && factories == AggregatorFactories.EMPTY && includeExclude == null) {
                    remapGlobalOrd = false;
                }
                return new GlobalOrdinalsSignificantTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, remapGlobalOrd, significanceHeuristic, termsAggregatorFactory, pipelineAggregators, metaData);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            if ("global_ordinals".equals(value)) {
                return GLOBAL_ORDINALS;
            }
            if ("global_ordinals_hash".equals(value)) {
                deprecationLogger.deprecated("global_ordinals_hash is deprecated. Please use [global_ordinals] instead.", new Object[0]);
                return GLOBAL_ORDINALS;
            }
            if ("map".equals(value)) {
                return MAP;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, SearchContext var7, Aggregator var8, SignificanceHeuristic var9, SignificantTermsAggregatorFactory var10, List<PipelineAggregator> var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

