/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedPropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classAsReceiver", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createFieldForEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerEnumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "enumEntry", "klass", "lowerExternalEnumEntry", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetFieldImpl;", "backend.js"})
public final class EnumUsageLowering
implements FileLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ EnumUsageLowering this$0;

            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrEnumEntry enumEntry = (IrEnumEntry)expression2.getSymbol().getOwner();
                IrDeclarationParent irDeclarationParent = enumEntry.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                IrClass klass2 = (IrClass)irDeclarationParent;
                return klass2.isExternal() ? (IrDeclarationReference)EnumUsageLowering.access$lowerExternalEnumEntry(this.this$0, enumEntry, klass2) : (IrDeclarationReference)EnumUsageLowering.access$lowerEnumEntry(this.this$0, enumEntry, klass2);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IrGetFieldImpl lowerExternalEnumEntry(IrEnumEntry enumEntry, IrClass klass2) {
        Object object;
        void $receiver$iv;
        Map<IrEnumEntrySymbol, IrField> map2 = this.context.getEnumEntryExternalToInstanceField();
        Object key$iv = enumEntry.getSymbol();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            IrField answer$iv = this.createFieldForEntry(enumEntry, klass2);
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map2 = object;
        IrField it = (IrField)((Object)map2);
        return JsIrBuilder.INSTANCE.buildGetField((IrFieldSymbol)it.getSymbol(), this.classAsReceiver(klass2), null, IrUtilsKt.getDefaultType(klass2));
    }

    private final IrExpression classAsReceiver(IrClass irClass) {
        IrSimpleFunctionSymbol intrinsic = this.context.getIntrinsics().getJsClass();
        return JsIrBuilder.INSTANCE.buildCall(intrinsic, this.context.getIrBuiltIns().getAnyType(), CollectionsKt.listOf(IrUtilsKt.getDefaultType(irClass)));
    }

    private final IrField createFieldForEntry(IrEnumEntry entry, IrClass irClass) {
        IrFieldImpl irFieldImpl;
        IrEnumEntry irEnumEntry;
        WrappedPropertyDescriptor descriptor2 = new WrappedPropertyDescriptor(null, null, 3, null);
        IrFieldSymbolImpl symbol2 = new IrFieldSymbolImpl(descriptor2);
        IrEnumEntry $receiver = irEnumEntry = entry;
        int n = $receiver.getStartOffset();
        int n2 = $receiver.getEndOffset();
        IrDeclarationOrigin irDeclarationOrigin = $receiver.getOrigin();
        IrFieldSymbol irFieldSymbol = symbol2;
        Name name = $receiver.getName();
        IrType irType = IrUtilsKt.getDefaultType(irClass);
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
        IrFieldImpl it = irFieldImpl = new IrFieldImpl(n, n2, irDeclarationOrigin, irFieldSymbol, name, irType, visibility, false, true, true);
        descriptor2.bind((IrDeclaration)it);
        it.setParent(irClass);
        Collection collection = irClass.getDeclarations();
        collection.add(it);
        return irFieldImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall lowerEnumEntry(IrEnumEntry enumEntry, IrClass klass2) {
        Object object;
        void $receiver$iv;
        Map<IrEnumEntrySymbol, IrSimpleFunction> map2 = this.context.getEnumEntryToGetInstanceFunction();
        Object key$iv = enumEntry.getSymbol();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            String string = klass2.getName().getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull(string, "klass.name.identifier");
            IrSimpleFunction answer$iv = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, EnumClassLoweringKt.access$createEntryAccessorName(string, enumEntry), EnumClassLoweringKt.access$getType(enumEntry, klass2), (IrDeclarationParent)klass2, null, null, false, false, false, false, null, 1016, null);
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map2 = object;
        IrSimpleFunction $receiver = (IrSimpleFunction)((Object)map2);
        return JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, $receiver.getSymbol(), null, null, 6, null);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public EnumUsageLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    public static final /* synthetic */ IrGetFieldImpl access$lowerExternalEnumEntry(EnumUsageLowering $this, IrEnumEntry enumEntry, IrClass klass2) {
        return $this.lowerExternalEnumEntry(enumEntry, klass2);
    }

    public static final /* synthetic */ IrCall access$lowerEnumEntry(EnumUsageLowering $this, IrEnumEntry enumEntry, IrClass klass2) {
        return $this.lowerEnumEntry(enumEntry, klass2);
    }
}

