/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

public class ProtegeScrollBarUI
extends ScrollBarUI {
    public static final int DIM = 12;
    private AdjustmentListener adjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ProtegeScrollBarUI.this.scrollBar.repaint();
        }
    };
    private Point mouseDown;
    private Point lastDrag;
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            ProtegeScrollBarUI.this.mouseOver = true;
            ProtegeScrollBarUI.this.scrollBar.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ProtegeScrollBarUI.this.mouseOver = false;
            ProtegeScrollBarUI.this.scrollBar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ProtegeScrollBarUI.this.mouseDown = e.getPoint();
            ProtegeScrollBarUI.this.lastDrag = ProtegeScrollBarUI.this.mouseDown;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ProtegeScrollBarUI.this.handleDragBy(e.getX() - ((ProtegeScrollBarUI)ProtegeScrollBarUI.this).lastDrag.x, e.getY() - ((ProtegeScrollBarUI)ProtegeScrollBarUI.this).lastDrag.y);
            ProtegeScrollBarUI.this.lastDrag = e.getPoint();
        }
    };
    private JScrollBar scrollBar;
    private boolean mouseOver;

    public static ComponentUI createUI(JComponent x) {
        return new ProtegeScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollBar = (JScrollBar)c;
        c.addMouseListener(this.mouseListener);
        ((JScrollBar)c).addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        ((JScrollBar)c).removeAdjustmentListener(this.adjustmentListener);
    }

    private void handleDragBy(int dX, int dY) {
        if (this.scrollBar.getOrientation() == 1) {
            this.scrollBar.setValue(this.scrollBar.getValue() + dY);
        } else {
            this.scrollBar.setValue(this.scrollBar.getValue() + dX);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollBar.getOrientation() == 1) {
            return new Dimension(12, c.getHeight());
        }
        return new Dimension(c.getWidth(), 12);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle thumbRect;
        super.paint(g, c);
        this.paintTrack(g, c, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        int visibleAmount = this.scrollBar.getVisibleAmount();
        BoundedRangeModel model = this.scrollBar.getModel();
        int max = model.getMaximum() - model.getExtent();
        int min = model.getMinimum();
        int pos = model.getValue();
        if (this.scrollBar.getOrientation() == 1) {
            int range = c.getHeight();
            int size = (int)(1.0 * (double)visibleAmount / (double)model.getMaximum() * (double)range);
            double percentage = (double)pos * 1.0 / (double)(max - min);
            int thumbY = (int)(percentage * (double)(range - size));
            thumbRect = new Rectangle(2, thumbY, 8, size);
        } else {
            int range = c.getWidth();
            int size = (int)(1.0 * (double)visibleAmount / (double)model.getMaximum() * (double)range);
            double offset = (double)pos * 1.0 / (double)(max - min);
            int thumbX = (int)(offset * (double)(range - size));
            thumbRect = new Rectangle(thumbX, 2, size, 8);
        }
        this.paintThumb(g, c, thumbRect);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(new Color(240, 240, 240));
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        g.setColor(new Color(160, 160, 160));
        if (this.scrollBar.getOrientation() == 1) {
            g.drawLine(trackBounds.x, trackBounds.y, trackBounds.x, trackBounds.y + trackBounds.height);
        } else {
            g.drawLine(trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y);
            g.drawLine(trackBounds.x + trackBounds.width, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (this.mouseOver) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }
}

