#ifndef _EFL_UI_FOCUS_MANAGER_CALC_EO_H_
#define _EFL_UI_FOCUS_MANAGER_CALC_EO_H_

#ifndef _EFL_UI_FOCUS_MANAGER_CALC_EO_CLASS_TYPE
#define _EFL_UI_FOCUS_MANAGER_CALC_EO_CLASS_TYPE

typedef Eo Efl_Ui_Focus_Manager_Calc;

#endif

#ifndef _EFL_UI_FOCUS_MANAGER_CALC_EO_TYPES
#define _EFL_UI_FOCUS_MANAGER_CALC_EO_TYPES


#endif
/**
 * @brief Calculates the directions of Efl.Ui.Focus.Direction
 *
 * Each registered item will get an other registered object in each direction.
 * You can get items for the currently focused item if you call request move.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
#define EFL_UI_FOCUS_MANAGER_CALC_CLASS efl_ui_focus_manager_calc_class_get()

EWAPI const Efl_Class *efl_ui_focus_manager_calc_class_get(void);

/**
 * @brief Register a new item in the graph.
 *
 * @c parent can not be @c null, it will be used as the parent in the logical
 * tree. @c redirect will be set as redirect property on that manager, once
 * @c child gets focused.
 *
 * @param[in] obj The object.
 * @param[in] child The object to register
 * @param[in] parent The parent to use in the logical tree
 * @param[in] redirect The redirect manager to set once this child is focused
 * can be NULL for no redirect
 *
 * @return @c true if successful, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI Eina_Bool efl_ui_focus_manager_calc_register(Eo *obj, Efl_Ui_Focus_Object *child, Efl_Ui_Focus_Object *parent, Efl_Ui_Focus_Manager *redirect) EINA_ARG_NONNULL(2, 3);

/**
 * @brief Register a new item only for the logical parent.
 *
 * The item can never get focus, it just helps to build a tree out of the items
 * that are.
 *
 * @param[in] obj The object.
 * @param[in] child The object to register
 * @param[in] parent The parent to use in the logical tree
 * @param[in] redirect The redirect manager to set once this child is focused
 * can be @c null for no redirect
 *
 * @return @c true if successful, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI Eina_Bool efl_ui_focus_manager_calc_register_logical(Eo *obj, Efl_Ui_Focus_Object *child, Efl_Ui_Focus_Object *parent, Efl_Ui_Focus_Manager *redirect) EINA_ARG_NONNULL(2, 3);

/**
 * @brief Set a new redirect object for the given child.
 *
 * Once @c child is focused the redirect manager will be set in the redirect
 * property. Set redirect to @c null if nothing should happen.
 *
 * @param[in] obj The object.
 * @param[in] child The child to update
 * @param[in] redirect Once @c child is focused this element will be set as
 * redirect
 *
 * @return @c true if successful, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI Eina_Bool efl_ui_focus_manager_calc_update_redirect(Eo *obj, Efl_Ui_Focus_Object *child, Efl_Ui_Focus_Manager *redirect) EINA_ARG_NONNULL(2);

/**
 * @brief Set a new logical parent for the given child.
 *
 * @param[in] obj The object.
 * @param[in] child The child to update
 * @param[in] parent The parent which now will be the logical parent of child
 *
 * @return @c true if successful, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI Eina_Bool efl_ui_focus_manager_calc_update_parent(Eo *obj, Efl_Ui_Focus_Object *child, Efl_Ui_Focus_Object *parent) EINA_ARG_NONNULL(2, 3);

/**
 * @brief Give the list of children a different order.
 *
 * @param[in] obj The object.
 * @param[in] parent the parent to update
 * @param[in] children the list with the new order
 *
 * @return @c true if successful, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI Eina_Bool efl_ui_focus_manager_calc_update_children(Eo *obj, Efl_Ui_Focus_Object *parent, Eina_List *children) EINA_ARG_NONNULL(2);

/**
 * @brief Give the given order to the parent's child.
 *
 * Children from the list which are not true children are ignored.
 *
 * @param[in] obj The object.
 * @param[in] parent the parent to update
 * @param[in] children the order of items
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI void efl_ui_focus_manager_calc_update_order(Eo *obj, Efl_Ui_Focus_Object *parent, Eina_List *children) EINA_ARG_NONNULL(2);

/**
 * @brief Unregister the given item from the focus graph.
 *
 * @param[in] obj The object.
 * @param[in] child The child to unregister.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Manager_Calc
 */
EOAPI void efl_ui_focus_manager_calc_unregister(Eo *obj, Efl_Ui_Focus_Object *child);

#endif
