/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public abstract class ProfilerTabbedView {
    public static ProfilerTabbedView createTop(boolean minimizeInnerMargin, boolean minimizeOuterMargin, ChangeListener listener) {
        return ProfilerTabbedView.create(1, minimizeInnerMargin, minimizeOuterMargin, listener);
    }

    public static ProfilerTabbedView createBottom(boolean minimizeInnerMargin, boolean minimizeOuterMargin, ChangeListener listener) {
        return ProfilerTabbedView.create(3, minimizeInnerMargin, minimizeOuterMargin, listener);
    }

    private static ProfilerTabbedView create(int tabPlacement, boolean minimizeInnerMargin, boolean minimizeOuterMargin, ChangeListener listener) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(tabPlacement, 0, minimizeInnerMargin, minimizeOuterMargin, listener) : new Impl(tabPlacement, 0, minimizeInnerMargin, minimizeOuterMargin, listener);
    }

    public abstract JComponent getComponent();

    public abstract void addView(String var1, Icon var2, String var3, JComponent var4, boolean var5);

    public abstract boolean containsView(JComponent var1);

    public abstract void replaceView(JComponent var1, String var2, Icon var3, String var4, JComponent var5, boolean var6);

    public abstract void updateView(JComponent var1, String var2, Icon var3, String var4);

    public abstract void removeView(JComponent var1);

    public abstract void removeAllViews();

    public abstract int getViewsCount();

    public abstract void setViewName(JComponent var1, String var2);

    public abstract String getViewName(JComponent var1);

    public abstract void setViewEnabled(JComponent var1, boolean var2);

    public abstract boolean isViewEnabled(JComponent var1);

    public abstract void selectView(JComponent var1);

    public abstract void selectView(int var1);

    public abstract void selectPreviousView();

    public abstract void selectNextView();

    public abstract JComponent getSelectedView();

    public abstract void highlightView(JComponent var1);

    public abstract void setFocusMaster(Component var1);

    protected ProfilerTabbedView() {
    }

    public static class Impl
    extends ProfilerTabbedView {
        private final ChangeListener listener;
        private final int tabPlacement;
        private final int tabLayoutPolicy;
        private final boolean minimizeInnerMargin;
        private final boolean minimizeOuterMargin;
        private final JComponent component;
        private JComponent firstView;
        private String firstName;
        private Icon firstIcon;
        private String firstDescription;
        private boolean firstClosable;
        private JTabbedPane tabs;
        private Component focusMaster;
        private static final int HIGHLIGHTS_COUNT = 2;
        private static final int HIGHLIGHTS_DURATION = 300;
        private final Map<TabbedPaneViewport, Integer> highlights = new HashMap<TabbedPaneViewport, Integer>();

        protected Impl(int tabPlacement, int tabLayoutPolicy, boolean minimizeOuterMargin, boolean minimizeInnerMargin, ChangeListener listener) {
            this.listener = listener;
            this.tabPlacement = tabPlacement;
            this.tabLayoutPolicy = tabLayoutPolicy;
            this.minimizeInnerMargin = minimizeInnerMargin;
            this.minimizeOuterMargin = minimizeOuterMargin;
            this.component = new JPanel(new BorderLayout());
            this.component.setOpaque(false);
            this.component.getActionMap().put("PreviousViewAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.selectPreviousView();
                }
            });
            this.component.getActionMap().put("NextViewAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.selectNextView();
                }
            });
            this.setFocusMaster(null);
        }

        @Override
        public void setFocusMaster(Component focusMaster) {
            this.focusMaster = focusMaster == null ? this.component : focusMaster;
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public void addView(String name, Icon icon, String description, JComponent view, boolean closable) {
            if (this.tabs == null) {
                if (this.firstView == null) {
                    this.firstView = view;
                    this.firstName = name;
                    this.firstIcon = icon;
                    this.firstDescription = description;
                    this.firstClosable = closable;
                    this.component.add((Component)view, "Center");
                    this.fireChanged();
                } else {
                    this.component.remove(this.firstView);
                    this.tabs = this.createTabs(this.tabPlacement, this.tabLayoutPolicy, this.minimizeOuterMargin);
                    this.tabs.addTab(Impl.tabName(this.firstName, this.firstClosable), this.firstIcon, this.createViewport(this.firstView, this.firstClosable), this.firstDescription);
                    this.tabs.addTab(Impl.tabName(name, closable), icon, this.createViewport(view, closable), description);
                    this.component.add((Component)this.tabs, "Center");
                    this.firstView = null;
                    this.firstName = null;
                    this.firstIcon = null;
                    this.firstDescription = null;
                }
            } else {
                this.tabs.addTab(Impl.tabName(name, closable), icon, this.createViewport(view, closable), description);
            }
        }

        private static String tabName(String name, boolean closable) {
            return name + (closable ? " " : "");
        }

        @Override
        public boolean containsView(JComponent view) {
            if (this.tabs == null) {
                return Objects.equals(view, this.firstView);
            }
            TabbedPaneViewport viewport = this.createViewport(view, false);
            return this.tabs.indexOfComponent(viewport) != -1;
        }

        @Override
        public void replaceView(JComponent oldView, String name, Icon icon, String description, JComponent newView, boolean closable) {
            if (this.tabs == null && oldView == this.firstView) {
                this.component.remove(this.firstView);
                this.firstView = newView;
                this.firstName = name;
                this.firstIcon = icon;
                this.firstDescription = description;
                this.firstClosable = closable;
                this.component.add((Component)newView, "Center");
                this.component.invalidate();
                this.component.revalidate();
                this.component.repaint();
            } else {
                TabbedPaneViewport oldViewport = TabbedPaneViewport.fromView(oldView);
                int idx = this.tabs.indexOfComponent(oldViewport);
                this.tabs.setTitleAt(idx, name);
                this.tabs.setIconAt(idx, icon);
                this.tabs.setToolTipTextAt(idx, description);
                this.tabs.setComponentAt(idx, this.createViewport(newView, closable));
            }
        }

        @Override
        public void updateView(JComponent view, String name, Icon icon, String description) {
            if (this.tabs == null && view == this.firstView) {
                this.firstName = name;
                this.firstIcon = icon;
                this.firstDescription = description;
            } else {
                TabbedPaneViewport viewport = TabbedPaneViewport.fromView(view);
                int idx = this.tabs.indexOfComponent(viewport);
                this.tabs.setTitleAt(idx, name);
                this.tabs.setIconAt(idx, icon);
                this.tabs.setToolTipTextAt(idx, description);
            }
        }

        @Override
        public void removeView(JComponent view) {
            if (this.tabs != null) {
                if (this.tabs.getTabCount() > 2) {
                    this.tabs.remove(TabbedPaneViewport.fromView(view));
                } else {
                    this.tabs.remove(TabbedPaneViewport.fromView(view));
                    TabbedPaneViewport singleViewport = (TabbedPaneViewport)this.tabs.getComponentAt(0);
                    this.firstName = this.tabs.getTitleAt(0);
                    this.firstIcon = this.tabs.getIconAt(0);
                    this.firstDescription = this.tabs.getToolTipTextAt(0);
                    this.firstClosable = singleViewport.isClosable();
                    this.firstView = singleViewport.disposeView();
                    this.component.remove(this.tabs);
                    this.component.add((Component)this.firstView, "Center");
                    this.tabs = null;
                }
            } else if (this.firstView == view) {
                this.component.remove(this.firstView);
                this.firstView = null;
                this.firstName = null;
                this.firstIcon = null;
                this.firstDescription = null;
                this.fireChanged();
            }
        }

        @Override
        public void removeAllViews() {
            if (this.getViewsCount() == 0) {
                return;
            }
            this.component.removeAll();
            this.tabs = null;
            this.firstView = null;
            this.firstName = null;
            this.firstIcon = null;
            this.firstDescription = null;
            this.fireChanged();
        }

        @Override
        public int getViewsCount() {
            return this.tabs != null ? this.tabs.getTabCount() : (this.firstView != null ? 1 : 0);
        }

        private int getViewIndex(JComponent view) {
            if (this.tabs == null) {
                return view == this.firstView ? 0 : -1;
            }
            return this.tabs.indexOfComponent(TabbedPaneViewport.fromView(view));
        }

        @Override
        public final void setViewName(JComponent view, String name) {
            if (this.tabs == null) {
                this.firstName = name;
            } else {
                this.tabs.setTitleAt(this.getViewIndex(view), name);
            }
        }

        @Override
        public final String getViewName(JComponent view) {
            if (this.tabs == null) {
                return this.firstName;
            }
            return this.tabs.getTitleAt(this.getViewIndex(view));
        }

        @Override
        public void setViewEnabled(JComponent view, boolean enabled) {
            if (this.tabs != null) {
                this.tabs.setEnabledAt(this.getViewIndex(view), enabled);
            }
        }

        @Override
        public boolean isViewEnabled(JComponent view) {
            if (this.tabs == null) {
                return view == this.firstView;
            }
            return this.tabs.isEnabledAt(this.getViewIndex(view));
        }

        @Override
        public void selectView(JComponent view) {
            if (this.tabs != null) {
                this.tabs.setSelectedComponent(TabbedPaneViewport.fromView(view));
            }
        }

        @Override
        public void selectView(int index) {
            if (this.tabs != null) {
                this.tabs.setSelectedIndex(index);
            }
        }

        @Override
        public void selectPreviousView() {
            if (this.tabs != null) {
                this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
            }
        }

        @Override
        public void selectNextView() {
            if (this.tabs != null) {
                this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
            }
        }

        @Override
        public JComponent getSelectedView() {
            if (this.firstView != null) {
                return this.firstView;
            }
            if (this.tabs == null) {
                return null;
            }
            return ((TabbedPaneViewport)this.tabs.getSelectedComponent()).getView();
        }

        @Override
        public void highlightView(JComponent view) {
            this.highlightTab(this.createViewport(view, false));
        }

        protected final void fireChanged() {
            if (this.listener != null) {
                this.listener.stateChanged(new ChangeEvent(this));
            }
        }

        protected final TabbedPaneViewport createViewport(JComponent view, boolean closable) {
            return new TabbedPaneViewport(view, closable){

                @Override
                Component getFocusMaster() {
                    return focusMaster;
                }

                @Override
                int getTabPlacement() {
                    return tabPlacement;
                }

                @Override
                boolean minimizeInnerMargin() {
                    return minimizeInnerMargin;
                }
            };
        }

        protected final JTabbedPane createTabs(int tabPlacement, int tabLayoutPolicy, boolean minimizeOuterMargin) {
            JTabbedPane tp = TabbedPaneFactory.createCloseButtonTabbedPane();
            tp.setTabPlacement(tabPlacement);
            tp.setTabLayoutPolicy(tabLayoutPolicy);
            tp.setOpaque(false);
            if (minimizeOuterMargin) {
                if (UIUtils.isAquaLookAndFeel()) {
                    tp.setBorder(BorderFactory.createEmptyBorder(-13, -11, 0, -10));
                }
                if (UIUtils.isNimbusLookAndFeel()) {
                    if (tabPlacement == 1) {
                        tp.setBorder(BorderFactory.createEmptyBorder(-4, 0, 0, 0));
                    } else {
                        tp.setBorder(BorderFactory.createEmptyBorder(0, 0, -4, 0));
                    }
                } else {
                    tp.setBorder(BorderFactory.createEmptyBorder());
                    Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
                    int bottomOffset = 0;
                    if (UIUtils.isMetalLookAndFeel()) {
                        bottomOffset = -i.bottom + 1;
                    } else if (UIUtils.isWindowsLookAndFeel()) {
                        bottomOffset = -i.bottom;
                    }
                    if (i != null) {
                        tp.setBorder(BorderFactory.createEmptyBorder(-i.top, -i.left, bottomOffset, -i.right));
                    }
                }
            }
            tp.getActionMap().getParent().remove("navigatePageUp");
            tp.getActionMap().getParent().remove("navigatePageDown");
            tp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (listener != null) {
                        listener.stateChanged(e);
                    }
                }
            });
            tp.addPropertyChangeListener("close", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.removeView(((TabbedPaneViewport)evt.getNewValue()).getView());
                }
            });
            return tp;
        }

        private void highlightTab(TabbedPaneViewport viewport) {
            Integer icount = this.highlights.get(viewport);
            if (icount == null) {
                this.highlights.put(viewport, 2);
                this.highlightTabImpl(viewport);
            } else if (icount < 2) {
                this.highlights.put(viewport, 2);
            }
        }

        private void highlightTabImpl(final TabbedPaneViewport viewport) {
            if (this.tabs == null) {
                this.highlights.remove(viewport);
                return;
            }
            Integer icount = this.highlights.get(viewport);
            if (icount == null) {
                return;
            }
            if (icount == 0) {
                this.highlights.remove(viewport);
                return;
            }
            int idx = this.tabs.indexOfComponent(viewport);
            if (idx == -1) {
                this.highlights.remove(viewport);
                return;
            }
            final String originalTitle = this.tabs.getTitleAt(idx);
            String highlightTitle = "<html><font color='blue'>" + originalTitle + "</font></html>";
            final Icon originalIcon = this.tabs.getIconAt(idx);
            Image image = ImageUtilities.icon2Image((Icon)originalIcon);
            RGBImageFilter filter = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    int a = rgb >> 24 & 0xFF;
                    return a << 24 | (r / 2 & 0xFF) << 16 | (g / 2 & 0xFF) << 8 | b;
                }
            };
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
            Icon highlightIcon = ImageUtilities.image2Icon((Image)Toolkit.getDefaultToolkit().createImage(prod));
            this.decorateTab(viewport, highlightTitle, highlightIcon);
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.decorateTab(viewport, originalTitle, originalIcon);
                    Integer icount = (Integer)highlights.get(viewport);
                    if (icount == null) {
                        return;
                    }
                    icount = icount - 1;
                    highlights.put(viewport, icount);
                    this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.highlightTabImpl(viewport);
                        }
                    }, 300);
                }
            }, 300);
        }

        private void decorateTab(TabbedPaneViewport viewport, String title, Icon icon) {
            if (this.tabs == null) {
                return;
            }
            int idx = this.tabs.indexOfComponent(viewport);
            if (idx == -1) {
                return;
            }
            this.tabs.setTitleAt(idx, title);
            this.tabs.setIconAt(idx, icon);
        }

        private void invokeLater(final Runnable task, int time) {
            final Timer timer = new Timer(time, null);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    timer.stop();
                    task.run();
                }
            });
            timer.start();
        }

        private static abstract class TabbedPaneViewport
        extends JPanel {
            private final JComponent content;
            private Reference<Component> lastFocusOwner;

            TabbedPaneViewport(JComponent view, boolean closable) {
                super(new BorderLayout());
                this.content = view;
                this.setOpaque(false);
                this.setFocusable(false);
                this.add((Component)view, "Center");
                if (!closable) {
                    this.putClientProperty("noCloseButton", Boolean.TRUE);
                }
                view.putClientProperty("TabbedPaneViewport", this);
                final PropertyChangeListener focusListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        Component c = evt.getNewValue() instanceof Component ? (Component)evt.getNewValue() : null;
                        this.processFocusedComponent(c);
                    }

                    private void processFocusedComponent(Component c) {
                        Component cc = c;
                        while (c != null) {
                            if (c == this.getFocusMaster()) {
                                lastFocusOwner = new WeakReference<Component>(cc);
                                return;
                            }
                            c = c.getParent();
                        }
                    }
                };
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L) {
                            if (this.isShowing()) {
                                Component lastFocus;
                                Component component = lastFocus = lastFocusOwner == null ? null : (Component)lastFocusOwner.get();
                                if (lastFocus != null) {
                                    lastFocus.requestFocusInWindow();
                                } else {
                                    content.requestFocusInWindow();
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (lastFocus != null) {
                                            lastFocus.requestFocusInWindow();
                                        } else {
                                            content.requestFocusInWindow();
                                        }
                                    }
                                });
                                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", focusListener);
                            } else {
                                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", focusListener);
                            }
                        }
                    }
                });
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TabbedPaneViewport)) {
                    return false;
                }
                return this.content.equals(((TabbedPaneViewport)o).content);
            }

            public int hashCode() {
                return this.content.hashCode();
            }

            boolean isClosable() {
                return !Boolean.TRUE.equals(this.getClientProperty("noCloseButton"));
            }

            JComponent getView() {
                return this.content;
            }

            JComponent disposeView() {
                this.content.putClientProperty("TabbedPaneViewport", null);
                this.removeAll();
                return this.content;
            }

            static TabbedPaneViewport fromView(JComponent view) {
                return (TabbedPaneViewport)view.getClientProperty("TabbedPaneViewport");
            }

            abstract Component getFocusMaster();

            abstract int getTabPlacement();

            abstract boolean minimizeInnerMargin();

            @Override
            public void reshape(int x, int y, int w, int h) {
                if (this.minimizeInnerMargin()) {
                    Rectangle r = this.offsetRect();
                    super.reshape(x + r.x, y + r.y, w + r.width, h + r.height);
                } else {
                    super.reshape(x, y, w, h);
                }
            }

            private Rectangle offsetRect() {
                Rectangle rect = new Rectangle();
                if (UIUtils.isNimbus()) {
                    rect.height = 4;
                    if (this.getTabPlacement() == 1) {
                        rect.y -= rect.height;
                    }
                } else if (UIUtils.isGTKLookAndFeel()) {
                    rect.height = 1;
                    if (this.getTabPlacement() == 1) {
                        rect.y -= rect.height++;
                    }
                } else {
                    Insets tai = UIManager.getInsets("TabbedPane.tabAreaInsets");
                    Insets cbi = UIManager.getInsets("TabbedPane.contentBorderInsets");
                    if (tai != null && cbi != null) {
                        if (this.getTabPlacement() == 1) {
                            rect.y -= cbi.bottom;
                            rect.height -= rect.y;
                        } else {
                            rect.height = tai.bottom + cbi.bottom - 1;
                        }
                    }
                }
                return rect;
            }
        }
    }

    public static abstract class Provider {
        public abstract ProfilerTabbedView create(int var1, int var2, boolean var3, boolean var4, ChangeListener var5);
    }
}

