/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.wire.DependencyVerifier;

final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    @Override
    public <T> Void visit(Binding<T> binding2) {
        Key<T> key2 = binding2.getKey();
        if (!this.localKeys.contains(key2)) {
            if (Boolean.TRUE.equals(binding2.acceptTargetVisitor(this.verifier))) {
                this.localKeys.add(key2);
                binding2.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding2, null);
            }
        }
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

