/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.deps.AffectedClasses;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class ClasspathChangeDependentsFinder {
    private final ClasspathSnapshot classpathSnapshot;
    private final PreviousCompilation previousCompilation;

    public ClasspathChangeDependentsFinder(ClasspathSnapshot classpathSnapshot, PreviousCompilation previousCompilation) {
        this.classpathSnapshot = classpathSnapshot;
        this.previousCompilation = previousCompilation;
    }

    public DependentsSet getActualDependents(InputFileDetails entryChangeDetails, File classpathEntry) {
        if (entryChangeDetails.isAdded()) {
            if (this.classpathSnapshot.isAnyClassDuplicated(classpathEntry)) {
                return DependentsSet.dependencyToAll("at least one of the classes of '" + classpathEntry + "' is already present in classpath");
            }
            return DependentsSet.empty();
        }
        final ClasspathEntrySnapshot previous = this.previousCompilation.getClasspathEntrySnapshot(entryChangeDetails.getFile());
        if (previous == null) {
            return DependentsSet.dependencyToAll("missing classpath entry snapshot of '" + classpathEntry + "' from previous build");
        }
        if (entryChangeDetails.isRemoved()) {
            DependentsSet allClasses = previous.getAllClasses();
            if (allClasses.isDependencyToAll()) {
                return allClasses;
            }
            return this.previousCompilation.getDependents(allClasses.getDependentClasses(), previous.getAllConstants(allClasses));
        }
        if (entryChangeDetails.isModified()) {
            ClasspathEntrySnapshot currentSnapshot = this.classpathSnapshot.getSnapshot(classpathEntry);
            AffectedClasses affected = currentSnapshot.getAffectedClassesSince(previous);
            DependentsSet altered = affected.getAltered();
            if (altered.isDependencyToAll()) {
                return altered;
            }
            if (this.classpathSnapshot.isAnyClassDuplicated(affected.getAdded())) {
                return DependentsSet.dependencyToAll("at least one of the classes of modified classpath entry '" + classpathEntry + "' is already present in the classpath");
            }
            final HashSet dependentClasses = Sets.newHashSet(altered.getDependentClasses());
            final LinkedList queue = Lists.newLinkedList((Iterable)dependentClasses);
            while (!queue.isEmpty()) {
                final String dependentClass = (String)queue.poll();
                this.classpathSnapshot.forEachSnapshot((Action<? super ClasspathEntrySnapshot>)new Action<ClasspathEntrySnapshot>(){

                    public void execute(ClasspathEntrySnapshot classpathEntrySnapshot) {
                        if (classpathEntrySnapshot != previous) {
                            ClassSetAnalysisData data = classpathEntrySnapshot.getData().getClassAnalysis();
                            Set<String> children = data.getChildren(dependentClass);
                            for (String child : children) {
                                if (!dependentClasses.add(child)) continue;
                                queue.add(child);
                            }
                        }
                    }
                });
            }
            return this.previousCompilation.getDependents(dependentClasses, currentSnapshot.getRelevantConstants(previous, dependentClasses));
        }
        throw new IllegalArgumentException("Unknown input file details provided: " + entryChangeDetails);
    }
}

