/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathCompareStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class IgnoredPathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final IgnoredPathFingerprintingStrategy INSTANCE = new IgnoredPathFingerprintingStrategy();

    private IgnoredPathFingerprintingStrategy() {
        super("IGNORED_PATH", IgnoredPathCompareStrategy.INSTANCE);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<FileSystemSnapshot> roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet processedEntries = new HashSet();
        for (FileSystemSnapshot root : roots) {
            root.accept(new FileSystemSnapshotVisitor(){

                @Override
                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    return true;
                }

                @Override
                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    String absolutePath = fileSnapshot.getAbsolutePath();
                    if (processedEntries.add(absolutePath)) {
                        builder.put((Object)absolutePath, (Object)IgnoredPathFileSystemLocationFingerprint.create(fileSnapshot.getType(), fileSnapshot.getHash()));
                    }
                }

                @Override
                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                }
            });
        }
        return builder.build();
    }
}

