/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Properties;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.editor.TabAction;
import net.sf.sdedit.ui.PanelGraphicDevice;
import net.sf.sdedit.ui.impl.DiagramTab;
import org.freehep.graphicsbase.util.export.ExportDialog;

public class ExportAction
extends TabAction<DiagramTab>
implements Constants {
    private static final long serialVersionUID = -8534175701798362565L;
    private ExportDialog exportDialog;
    private Properties properties = new Properties();
    private AbstractPaintDevice exportDevice;
    private PanelGraphicDevice exportGraphic;

    public ExportAction(Editor editor) {
        super(DiagramTab.class, editor.getUI());
        this.putValue("Name", Shortcuts.getShortcut(22) + "E&xport...");
        this.putValue("IconName", "image");
        this.putValue("ActionID", "EXPORT");
        this.putValue("ShortDescription", "Export diagram as bitmap or vector graphics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _actionPerformed(DiagramTab tab, ActionEvent e) {
        Diagram diagram = tab.getDiagram();
        if (diagram == null) {
            return;
        }
        this.exportDevice = (AbstractPaintDevice)diagram.getPaintDevice();
        this.exportGraphic = (PanelGraphicDevice)this.exportDevice.getGraphicDevice();
        if (this.exportDevice.isEmpty()) {
            return;
        }
        try {
            File file = tab.getFile();
            if (this.exportDialog == null) {
                this.exportDialog = new ExportDialog("Quick Sequence Diagram Editor");
                this.exportDialog.setUserProperties(this.properties);
                if (file != null) {
                    this.properties.setProperty("org.freehep.graphicsbase.util.export.ExportDialog.SaveAsFile", file.getAbsolutePath());
                }
            } else {
                File current;
                String fileName = this.properties.getProperty("org.freehep.graphicsbase.util.export.ExportDialog.SaveAsFile");
                File file2 = current = fileName != null ? new File(fileName) : null;
                if (current != null && current.exists()) {
                    File dir = current.getParentFile();
                    current = file == null ? new File(dir, "untitled") : new File(dir, file.getName());
                    this.properties.setProperty("org.freehep.graphicsbase.util.export.ExportDialog.SaveAsFile", current.getAbsolutePath());
                }
            }
            this.exportDialog.showExportDialog(tab, "Export via FreeHEP library (see http://www.freehep.org/vectorgraphics)", this.exportGraphic.getPanel().asJComponent(), "untitled");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.ui.errorMessage(ex, null, "Export failed");
        }
        finally {
            this.exportGraphic.setAntialiasing(true);
        }
    }
}

