/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.JPanel;
import net.sf.sdedit.ui.components.ATabbedPane;
import net.sf.sdedit.ui.components.ATabbedPaneListener;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.components.configuration.NamedDataObject;

public class MultiBeanPane
extends JPanel
implements ConfigurationUIListener,
PropertyChangeListener,
ATabbedPaneListener {
    private ATabbedPane tabbedPane;
    private LinkedList<ConfigurationUI<? extends NamedDataObject>> tabs;
    private LinkedList<Bean<? extends NamedDataObject>> beans;

    public MultiBeanPane() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new ATabbedPane();
        this.tabbedPane.addListener(this);
        this.add((Component)this.tabbedPane, "Center");
        this.beans = new LinkedList();
        this.tabs = new LinkedList();
    }

    public <B extends NamedDataObject> void add(Bean<B> bean) {
        ConfigurationUI<B> ui = new ConfigurationUI<B>(this, bean, null, null, null, "", false);
        ui.hideCategoryList();
        this.tabbedPane.addTab(ui, ((NamedDataObject)bean.getDataObject()).getName());
        this.beans.add(bean);
        this.tabs.add(ui);
    }

    public void saveTo(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        try {
            os = new BufferedOutputStream(os);
            os = new ObjectOutputStream(os);
            ((ObjectOutputStream)os).writeObject(this.beans);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        LinkedList beans = null;
        try {
            is = new BufferedInputStream(is);
            is = new ObjectInputStream(is);
            try {
                beans = (LinkedList)((ObjectInputStream)is).readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot read from: " + file.getAbsolutePath());
            }
        }
        finally {
            is.close();
        }
        for (Bean bean : beans) {
            this.add(bean);
        }
    }

    @Override
    public void applyConfiguration() {
    }

    @Override
    public void cancelConfiguration() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void tabClosing(Component tab) {
        int i = this.tabs.indexOf(tab);
        this.tabs.remove(i);
        this.beans.remove(i);
        this.tabbedPane.remove(tab);
    }
}

