/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CloudFunctionConfiguration;
import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.FilterRule;
import com.amazonaws.services.s3.model.LambdaConfiguration;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.QueueConfiguration;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.ReplicationDestinationConfig;
import com.amazonaws.services.s3.model.ReplicationRule;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.S3KeyFilter;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.s3.model.TopicConfiguration;
import com.amazonaws.services.s3.model.analytics.AnalyticsAndOperator;
import com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import com.amazonaws.services.s3.model.analytics.AnalyticsExportDestination;
import com.amazonaws.services.s3.model.analytics.AnalyticsFilter;
import com.amazonaws.services.s3.model.analytics.AnalyticsFilterPredicate;
import com.amazonaws.services.s3.model.analytics.AnalyticsPredicateVisitor;
import com.amazonaws.services.s3.model.analytics.AnalyticsPrefixPredicate;
import com.amazonaws.services.s3.model.analytics.AnalyticsS3BucketDestination;
import com.amazonaws.services.s3.model.analytics.AnalyticsTagPredicate;
import com.amazonaws.services.s3.model.analytics.StorageClassAnalysis;
import com.amazonaws.services.s3.model.analytics.StorageClassAnalysisDataExport;
import com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import com.amazonaws.services.s3.model.inventory.InventoryDestination;
import com.amazonaws.services.s3.model.inventory.InventoryFilter;
import com.amazonaws.services.s3.model.inventory.InventoryFilterPredicate;
import com.amazonaws.services.s3.model.inventory.InventoryPrefixPredicate;
import com.amazonaws.services.s3.model.inventory.InventoryS3BucketDestination;
import com.amazonaws.services.s3.model.inventory.InventorySchedule;
import com.amazonaws.services.s3.model.lifecycle.LifecycleAndOperator;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecyclePredicateVisitor;
import com.amazonaws.services.s3.model.lifecycle.LifecyclePrefixPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsAndOperator;
import com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import com.amazonaws.services.s3.model.metrics.MetricsFilter;
import com.amazonaws.services.s3.model.metrics.MetricsFilterPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsPredicateVisitor;
import com.amazonaws.services.s3.model.metrics.MetricsPrefixPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsTagPredicate;
import com.amazonaws.util.CollectionUtils;
import java.util.List;
import java.util.Map;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketVersioningConfiguration versioningConfiguration) {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("VersioningConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml2.start("Status").value(versioningConfiguration.getStatus()).end();
        Boolean mfaDeleteEnabled = versioningConfiguration.isMfaDeleteEnabled();
        if (mfaDeleteEnabled != null) {
            if (mfaDeleteEnabled.booleanValue()) {
                xml2.start("MfaDelete").value("Enabled").end();
            } else {
                xml2.start("MfaDelete").value("Disabled").end();
            }
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketAccelerateConfiguration accelerateConfiguration) {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("AccelerateConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml2.start("Status").value(accelerateConfiguration.getStatus()).end();
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration loggingConfiguration) {
        String logFilePrefix = loggingConfiguration.getLogFilePrefix();
        if (logFilePrefix == null) {
            logFilePrefix = "";
        }
        XmlWriter xml2 = new XmlWriter();
        xml2.start("BucketLoggingStatus", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (loggingConfiguration.isLoggingEnabled()) {
            xml2.start("LoggingEnabled");
            xml2.start("TargetBucket").value(loggingConfiguration.getDestinationBucketName()).end();
            xml2.start("TargetPrefix").value(loggingConfiguration.getLogFilePrefix()).end();
            xml2.end();
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketNotificationConfiguration notificationConfiguration) {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("NotificationConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        Map<String, NotificationConfiguration> configurations = notificationConfiguration.getConfigurations();
        for (Map.Entry<String, NotificationConfiguration> entry : configurations.entrySet()) {
            String configName = entry.getKey();
            NotificationConfiguration config = entry.getValue();
            if (config instanceof TopicConfiguration) {
                xml2.start("TopicConfiguration");
                xml2.start("Id").value(configName).end();
                xml2.start("Topic").value(((TopicConfiguration)config).getTopicARN()).end();
                this.addEventsAndFilterCriteria(xml2, config);
                xml2.end();
                continue;
            }
            if (config instanceof QueueConfiguration) {
                xml2.start("QueueConfiguration");
                xml2.start("Id").value(configName).end();
                xml2.start("Queue").value(((QueueConfiguration)config).getQueueARN()).end();
                this.addEventsAndFilterCriteria(xml2, config);
                xml2.end();
                continue;
            }
            if (config instanceof CloudFunctionConfiguration) {
                xml2.start("CloudFunctionConfiguration");
                xml2.start("Id").value(configName).end();
                xml2.start("InvocationRole").value(((CloudFunctionConfiguration)config).getInvocationRoleARN()).end();
                xml2.start("CloudFunction").value(((CloudFunctionConfiguration)config).getCloudFunctionARN()).end();
                this.addEventsAndFilterCriteria(xml2, config);
                xml2.end();
                continue;
            }
            if (!(config instanceof LambdaConfiguration)) continue;
            xml2.start("CloudFunctionConfiguration");
            xml2.start("Id").value(configName).end();
            xml2.start("CloudFunction").value(((LambdaConfiguration)config).getFunctionARN()).end();
            this.addEventsAndFilterCriteria(xml2, config);
            xml2.end();
        }
        xml2.end();
        return xml2.getBytes();
    }

    private void addEventsAndFilterCriteria(XmlWriter xml2, NotificationConfiguration config) {
        for (String event : config.getEvents()) {
            xml2.start("Event").value(event).end();
        }
        Filter filter2 = config.getFilter();
        if (filter2 != null) {
            this.validateFilter(filter2);
            xml2.start("Filter");
            if (filter2.getS3KeyFilter() != null) {
                this.validateS3KeyFilter(filter2.getS3KeyFilter());
                xml2.start("S3Key");
                for (FilterRule filterRule : filter2.getS3KeyFilter().getFilterRules()) {
                    xml2.start("FilterRule");
                    xml2.start("Name").value(filterRule.getName()).end();
                    xml2.start("Value").value(filterRule.getValue()).end();
                    xml2.end();
                }
                xml2.end();
            }
            xml2.end();
        }
    }

    private void validateFilter(Filter filter2) {
        if (filter2.getS3KeyFilter() == null) {
            throw new SdkClientException("Cannot have a Filter without any criteria");
        }
    }

    private void validateS3KeyFilter(S3KeyFilter s3KeyFilter) {
        if (CollectionUtils.isNullOrEmpty(s3KeyFilter.getFilterRules())) {
            throw new SdkClientException("Cannot have an S3KeyFilter without any filter rules");
        }
    }

    public byte[] convertToXmlByteArray(BucketReplicationConfiguration replicationConfiguration) {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("ReplicationConfiguration");
        Map<String, ReplicationRule> rules = replicationConfiguration.getRules();
        String role = replicationConfiguration.getRoleARN();
        xml2.start("Role").value(role).end();
        for (Map.Entry<String, ReplicationRule> entry : rules.entrySet()) {
            String ruleId = entry.getKey();
            ReplicationRule rule = entry.getValue();
            xml2.start("Rule");
            xml2.start("ID").value(ruleId).end();
            xml2.start("Prefix").value(rule.getPrefix()).end();
            xml2.start("Status").value(rule.getStatus()).end();
            ReplicationDestinationConfig config = rule.getDestinationConfig();
            xml2.start("Destination");
            xml2.start("Bucket").value(config.getBucketARN()).end();
            if (config.getStorageClass() != null) {
                xml2.start("StorageClass").value(config.getStorageClass()).end();
            }
            xml2.end();
            xml2.end();
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration websiteConfiguration) {
        RedirectRule redirectAllRequestsTo;
        XmlWriter xml2 = new XmlWriter();
        xml2.start("WebsiteConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (websiteConfiguration.getIndexDocumentSuffix() != null) {
            XmlWriter indexDocumentElement = xml2.start("IndexDocument");
            indexDocumentElement.start("Suffix").value(websiteConfiguration.getIndexDocumentSuffix()).end();
            indexDocumentElement.end();
        }
        if (websiteConfiguration.getErrorDocument() != null) {
            XmlWriter errorDocumentElement = xml2.start("ErrorDocument");
            errorDocumentElement.start("Key").value(websiteConfiguration.getErrorDocument()).end();
            errorDocumentElement.end();
        }
        if ((redirectAllRequestsTo = websiteConfiguration.getRedirectAllRequestsTo()) != null) {
            XmlWriter redirectAllRequestsElement = xml2.start("RedirectAllRequestsTo");
            if (redirectAllRequestsTo.getprotocol() != null) {
                xml2.start("Protocol").value(redirectAllRequestsTo.getprotocol()).end();
            }
            if (redirectAllRequestsTo.getHostName() != null) {
                xml2.start("HostName").value(redirectAllRequestsTo.getHostName()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyPrefixWith() != null) {
                xml2.start("ReplaceKeyPrefixWith").value(redirectAllRequestsTo.getReplaceKeyPrefixWith()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyWith() != null) {
                xml2.start("ReplaceKeyWith").value(redirectAllRequestsTo.getReplaceKeyWith()).end();
            }
            redirectAllRequestsElement.end();
        }
        if (websiteConfiguration.getRoutingRules() != null && websiteConfiguration.getRoutingRules().size() > 0) {
            XmlWriter routingRules = xml2.start("RoutingRules");
            for (RoutingRule rule : websiteConfiguration.getRoutingRules()) {
                this.writeRule(routingRules, rule);
            }
            routingRules.end();
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : config.getRules()) {
            this.writeRule(xml2, rule);
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("CORSConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (CORSRule rule : config.getRules()) {
            this.writeRule(xml2, rule);
        }
        xml2.end();
        return xml2.getBytes();
    }

    private void writeRule(XmlWriter xml2, BucketLifecycleConfiguration.Rule rule) {
        xml2.start("Rule");
        if (rule.getId() != null) {
            xml2.start("ID").value(rule.getId()).end();
        }
        this.writePrefix(xml2, rule);
        xml2.start("Status").value(rule.getStatus()).end();
        this.writeLifecycleFilter(xml2, rule.getFilter());
        this.addTransitions(xml2, rule.getTransitions());
        this.addNoncurrentTransitions(xml2, rule.getNoncurrentVersionTransitions());
        if (this.hasCurrentExpirationPolicy(rule)) {
            xml2.start("Expiration");
            if (rule.getExpirationInDays() != -1) {
                xml2.start("Days").value("" + rule.getExpirationInDays()).end();
            }
            if (rule.getExpirationDate() != null) {
                xml2.start("Date").value(ServiceUtils.formatIso8601Date(rule.getExpirationDate())).end();
            }
            if (rule.isExpiredObjectDeleteMarker()) {
                xml2.start("ExpiredObjectDeleteMarker").value("true").end();
            }
            xml2.end();
        }
        if (rule.getNoncurrentVersionExpirationInDays() != -1) {
            xml2.start("NoncurrentVersionExpiration");
            xml2.start("NoncurrentDays").value(Integer.toString(rule.getNoncurrentVersionExpirationInDays())).end();
            xml2.end();
        }
        if (rule.getAbortIncompleteMultipartUpload() != null) {
            xml2.start("AbortIncompleteMultipartUpload");
            xml2.start("DaysAfterInitiation").value(Integer.toString(rule.getAbortIncompleteMultipartUpload().getDaysAfterInitiation())).end();
            xml2.end();
        }
        xml2.end();
    }

    private void addTransitions(XmlWriter xml2, List<BucketLifecycleConfiguration.Transition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.Transition t : transitions) {
            if (t == null) continue;
            xml2.start("Transition");
            if (t.getDate() != null) {
                xml2.start("Date");
                xml2.value(ServiceUtils.formatIso8601Date(t.getDate()));
                xml2.end();
            }
            if (t.getDays() != -1) {
                xml2.start("Days");
                xml2.value(Integer.toString(t.getDays()));
                xml2.end();
            }
            xml2.start("StorageClass");
            xml2.value(t.getStorageClass().toString());
            xml2.end();
            xml2.end();
        }
    }

    private void addNoncurrentTransitions(XmlWriter xml2, List<BucketLifecycleConfiguration.NoncurrentVersionTransition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.NoncurrentVersionTransition t : transitions) {
            if (t == null) continue;
            xml2.start("NoncurrentVersionTransition");
            if (t.getDays() != -1) {
                xml2.start("NoncurrentDays");
                xml2.value(Integer.toString(t.getDays()));
                xml2.end();
            }
            xml2.start("StorageClass");
            xml2.value(t.getStorageClass().toString());
            xml2.end();
            xml2.end();
        }
    }

    private void writeLifecycleFilter(XmlWriter xml2, LifecycleFilter filter2) {
        if (filter2 == null) {
            return;
        }
        xml2.start("Filter");
        this.writeLifecycleFilterPredicate(xml2, filter2.getPredicate());
        xml2.end();
    }

    private void writeLifecycleFilterPredicate(XmlWriter xml2, LifecycleFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new LifecyclePredicateVisitorImpl(xml2));
    }

    private boolean hasCurrentExpirationPolicy(BucketLifecycleConfiguration.Rule rule) {
        return rule.getExpirationInDays() != -1 || rule.getExpirationDate() != null || rule.isExpiredObjectDeleteMarker();
    }

    private void writeRule(XmlWriter xml2, CORSRule rule) {
        xml2.start("CORSRule");
        if (rule.getId() != null) {
            xml2.start("ID").value(rule.getId()).end();
        }
        if (rule.getAllowedOrigins() != null) {
            for (String origin : rule.getAllowedOrigins()) {
                xml2.start("AllowedOrigin").value(origin).end();
            }
        }
        if (rule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods method : rule.getAllowedMethods()) {
                xml2.start("AllowedMethod").value(method.toString()).end();
            }
        }
        if (rule.getMaxAgeSeconds() != 0) {
            xml2.start("MaxAgeSeconds").value(Integer.toString(rule.getMaxAgeSeconds())).end();
        }
        if (rule.getExposedHeaders() != null) {
            for (String header : rule.getExposedHeaders()) {
                xml2.start("ExposeHeader").value(header).end();
            }
        }
        if (rule.getAllowedHeaders() != null) {
            for (String header : rule.getAllowedHeaders()) {
                xml2.start("AllowedHeader").value(header).end();
            }
        }
        xml2.end();
    }

    private void writeRule(XmlWriter xml2, RoutingRule rule) {
        xml2.start("RoutingRule");
        RoutingRuleCondition condition = rule.getCondition();
        if (condition != null) {
            xml2.start("Condition");
            xml2.start("KeyPrefixEquals");
            if (condition.getKeyPrefixEquals() != null) {
                xml2.value(condition.getKeyPrefixEquals());
            }
            xml2.end();
            if (condition.getHttpErrorCodeReturnedEquals() != null) {
                xml2.start("HttpErrorCodeReturnedEquals ").value(condition.getHttpErrorCodeReturnedEquals()).end();
            }
            xml2.end();
        }
        xml2.start("Redirect");
        RedirectRule redirect = rule.getRedirect();
        if (redirect != null) {
            if (redirect.getprotocol() != null) {
                xml2.start("Protocol").value(redirect.getprotocol()).end();
            }
            if (redirect.getHostName() != null) {
                xml2.start("HostName").value(redirect.getHostName()).end();
            }
            if (redirect.getReplaceKeyPrefixWith() != null) {
                xml2.start("ReplaceKeyPrefixWith").value(redirect.getReplaceKeyPrefixWith()).end();
            }
            if (redirect.getReplaceKeyWith() != null) {
                xml2.start("ReplaceKeyWith").value(redirect.getReplaceKeyWith()).end();
            }
            if (redirect.getHttpRedirectCode() != null) {
                xml2.start("HttpRedirectCode").value(redirect.getHttpRedirectCode()).end();
            }
        }
        xml2.end();
        xml2.end();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("Tagging");
        for (TagSet tagset : config.getAllTagSets()) {
            this.writeRule(xml2, tagset);
        }
        xml2.end();
        return xml2.getBytes();
    }

    public byte[] convertToXmlByteArray(InventoryConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("InventoryConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml2.start("Id").value(config.getId()).end();
        xml2.start("IsEnabled").value(String.valueOf(config.isEnabled())).end();
        xml2.start("IncludedObjectVersions").value(config.getIncludedObjectVersions()).end();
        this.writeInventoryDestination(xml2, config.getDestination());
        this.writeInventoryFilter(xml2, config.getInventoryFilter());
        this.addInventorySchedule(xml2, config.getSchedule());
        this.addInventoryOptionalFields(xml2, config.getOptionalFields());
        xml2.end();
        return xml2.getBytes();
    }

    private void writeInventoryDestination(XmlWriter xml2, InventoryDestination destination) {
        if (destination == null) {
            return;
        }
        xml2.start("Destination");
        InventoryS3BucketDestination s3BucketDestination = destination.getS3BucketDestination();
        if (s3BucketDestination != null) {
            xml2.start("S3BucketDestination");
            this.addParameterIfNotNull(xml2, "AccountId", s3BucketDestination.getAccountId());
            this.addParameterIfNotNull(xml2, "Bucket", s3BucketDestination.getBucketArn());
            this.addParameterIfNotNull(xml2, "Prefix", s3BucketDestination.getPrefix());
            this.addParameterIfNotNull(xml2, "Format", s3BucketDestination.getFormat());
            xml2.end();
        }
        xml2.end();
    }

    private void writeInventoryFilter(XmlWriter xml2, InventoryFilter inventoryFilter) {
        if (inventoryFilter == null) {
            return;
        }
        xml2.start("Filter");
        this.writeInventoryFilterPredicate(xml2, inventoryFilter.getPredicate());
        xml2.end();
    }

    private void writeInventoryFilterPredicate(XmlWriter xml2, InventoryFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (predicate instanceof InventoryPrefixPredicate) {
            this.writePrefix(xml2, ((InventoryPrefixPredicate)predicate).getPrefix());
        }
    }

    private void addInventorySchedule(XmlWriter xml2, InventorySchedule schedule) {
        if (schedule == null) {
            return;
        }
        xml2.start("Schedule");
        this.addParameterIfNotNull(xml2, "Frequency", schedule.getFrequency());
        xml2.end();
    }

    private void addInventoryOptionalFields(XmlWriter xml2, List<String> optionalFields) {
        if (CollectionUtils.isNullOrEmpty(optionalFields)) {
            return;
        }
        xml2.start("OptionalFields");
        for (String field : optionalFields) {
            xml2.start("Field").value(field).end();
        }
        xml2.end();
    }

    private void writeRule(XmlWriter xml2, TagSet tagset) {
        xml2.start("TagSet");
        for (String key2 : tagset.getAllTags().keySet()) {
            xml2.start("Tag");
            xml2.start("Key").value(key2).end();
            xml2.start("Value").value(tagset.getTag(key2)).end();
            xml2.end();
        }
        xml2.end();
    }

    private boolean hasTags(TagSet tagSet) {
        return tagSet != null && tagSet.getAllTags() != null && tagSet.getAllTags().size() > 0;
    }

    public byte[] convertToXmlByteArray(AnalyticsConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("AnalyticsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.addParameterIfNotNull(xml2, "Id", config.getId());
        this.writeAnalyticsFilter(xml2, config.getFilter());
        this.writeStorageClassAnalysis(xml2, config.getStorageClassAnalysis());
        xml2.end();
        return xml2.getBytes();
    }

    private void writeAnalyticsFilter(XmlWriter xml2, AnalyticsFilter filter2) {
        if (filter2 == null) {
            return;
        }
        xml2.start("Filter");
        this.writeAnalyticsFilterPredicate(xml2, filter2.getPredicate());
        xml2.end();
    }

    private void writeAnalyticsFilterPredicate(XmlWriter xml2, AnalyticsFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new AnalyticsPredicateVisitorImpl(xml2));
    }

    private void writeStorageClassAnalysis(XmlWriter xml2, StorageClassAnalysis storageClassAnalysis) {
        if (storageClassAnalysis == null) {
            return;
        }
        xml2.start("StorageClassAnalysis");
        if (storageClassAnalysis.getDataExport() != null) {
            StorageClassAnalysisDataExport dataExport = storageClassAnalysis.getDataExport();
            xml2.start("DataExport");
            this.addParameterIfNotNull(xml2, "OutputSchemaVersion", dataExport.getOutputSchemaVersion());
            this.writeAnalyticsExportDestination(xml2, dataExport.getDestination());
            xml2.end();
        }
        xml2.end();
    }

    private void writeAnalyticsExportDestination(XmlWriter xml2, AnalyticsExportDestination destination) {
        if (destination == null) {
            return;
        }
        xml2.start("Destination");
        if (destination.getS3BucketDestination() != null) {
            xml2.start("S3BucketDestination");
            AnalyticsS3BucketDestination s3BucketDestination = destination.getS3BucketDestination();
            this.addParameterIfNotNull(xml2, "Format", s3BucketDestination.getFormat());
            this.addParameterIfNotNull(xml2, "BucketAccountId", s3BucketDestination.getBucketAccountId());
            this.addParameterIfNotNull(xml2, "Bucket", s3BucketDestination.getBucketArn());
            this.addParameterIfNotNull(xml2, "Prefix", s3BucketDestination.getPrefix());
            xml2.end();
        }
        xml2.end();
    }

    public byte[] convertToXmlByteArray(MetricsConfiguration config) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("MetricsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.addParameterIfNotNull(xml2, "Id", config.getId());
        this.writeMetricsFilter(xml2, config.getFilter());
        xml2.end();
        return xml2.getBytes();
    }

    private void writeMetricsFilter(XmlWriter xml2, MetricsFilter filter2) {
        if (filter2 == null) {
            return;
        }
        xml2.start("Filter");
        this.writeMetricsFilterPredicate(xml2, filter2.getPredicate());
        xml2.end();
    }

    private void writeMetricsFilterPredicate(XmlWriter xml2, MetricsFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new MetricsPredicateVisitorImpl(xml2));
    }

    private void addParameterIfNotNull(XmlWriter xml2, String xmlTagName, String value) {
        if (value != null) {
            xml2.start(xmlTagName).value(value).end();
        }
    }

    private void writePrefix(XmlWriter xml2, BucketLifecycleConfiguration.Rule rule) {
        if (rule.getFilter() == null) {
            xml2.start("Prefix").value(rule.getPrefix() == null ? "" : rule.getPrefix()).end();
        } else if (rule.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix cannot be used with Filter. Use LifecyclePrefixPredicate to create a LifecycleFilter");
        }
    }

    private void writePrefix(XmlWriter xml2, String prefix) {
        this.addParameterIfNotNull(xml2, "Prefix", prefix);
    }

    private void writeTag(XmlWriter xml2, Tag tag) {
        if (tag == null) {
            return;
        }
        xml2.start("Tag");
        xml2.start("Key").value(tag.getKey()).end();
        xml2.start("Value").value(tag.getValue()).end();
        xml2.end();
    }

    private class MetricsPredicateVisitorImpl
    implements MetricsPredicateVisitor {
        private final XmlWriter xml;

        public MetricsPredicateVisitorImpl(XmlWriter xml2) {
            this.xml = xml2;
        }

        @Override
        public void visit(MetricsPrefixPredicate metricsPrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, metricsPrefixPredicate.getPrefix());
        }

        @Override
        public void visit(MetricsTagPredicate metricsTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, metricsTagPredicate.getTag());
        }

        @Override
        public void visit(MetricsAndOperator metricsAndOperator) {
            this.xml.start("And");
            for (MetricsFilterPredicate predicate : metricsAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }

    private class AnalyticsPredicateVisitorImpl
    implements AnalyticsPredicateVisitor {
        private final XmlWriter xml;

        public AnalyticsPredicateVisitorImpl(XmlWriter xml2) {
            this.xml = xml2;
        }

        @Override
        public void visit(AnalyticsPrefixPredicate analyticsPrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, analyticsPrefixPredicate.getPrefix());
        }

        @Override
        public void visit(AnalyticsTagPredicate analyticsTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, analyticsTagPredicate.getTag());
        }

        @Override
        public void visit(AnalyticsAndOperator analyticsAndOperator) {
            this.xml.start("And");
            for (AnalyticsFilterPredicate predicate : analyticsAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }

    private class LifecyclePredicateVisitorImpl
    implements LifecyclePredicateVisitor {
        private final XmlWriter xml;

        public LifecyclePredicateVisitorImpl(XmlWriter xml2) {
            this.xml = xml2;
        }

        @Override
        public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
        }

        @Override
        public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, lifecycleTagPredicate.getTag());
        }

        @Override
        public void visit(LifecycleAndOperator lifecycleAndOperator) {
            this.xml.start("And");
            for (LifecycleFilterPredicate predicate : lifecycleAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }
}

