/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;

public abstract class EdgeTree {
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;
    protected double maxY;
    protected double maxX;
    protected boolean splitX;
    protected EdgeTree left;
    protected EdgeTree right;
    protected final Edge tree;

    protected EdgeTree(double minLat, double maxLat, double minLon, double maxLon, double[] lats, double[] lons) {
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.maxY = maxLat;
        this.maxX = maxLon;
        this.tree = EdgeTree.createTree(lats, lons);
    }

    public PointValues.Relation relateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        double minLat = StrictMath.min(StrictMath.min(ay, by), cy);
        double minLon = StrictMath.min(StrictMath.min(ax, bx), cx);
        double maxLat = StrictMath.max(StrictMath.max(ay, by), cy);
        double maxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
        if (minLat <= this.maxY && minLon <= this.maxX) {
            PointValues.Relation relation = this.internalComponentRelateTriangle(ax, ay, bx, by, cx, cy);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relateTriangle(ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxLat >= this.minLat || this.splitX && maxLon >= this.minLon) && (relation = this.right.relateTriangle(ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon) {
        if (minLat <= this.maxY && minLon <= this.maxX) {
            PointValues.Relation relation = this.internalComponentRelate(minLat, maxLat, minLon, maxLon);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxLat >= this.minLat || this.splitX && maxLon >= this.minLon) && (relation = this.right.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    protected PointValues.Relation componentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        return null;
    }

    protected PointValues.Relation componentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        return null;
    }

    private PointValues.Relation internalComponentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        double minLat = StrictMath.min(StrictMath.min(ay, by), cy);
        double minLon = StrictMath.min(StrictMath.min(ax, bx), cx);
        double maxLat = StrictMath.max(StrictMath.max(ay, by), cy);
        double maxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
        if (maxLon < this.minLon || minLon > this.maxLon || maxLat < this.minLat || minLat > this.maxLat) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        PointValues.Relation shapeRelation = this.componentRelateTriangle(ax, ay, bx, by, cx, cy);
        if (shapeRelation != null) {
            return shapeRelation;
        }
        if (this.tree.crossesTriangle(ax, ay, bx, by, cx, cy)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    protected PointValues.Relation internalComponentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        if (maxLon < this.minLon || minLon > this.maxLon || maxLat < this.minLat || minLat > this.maxLat) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (minLat <= this.minLat && maxLat >= this.maxLat && minLon <= this.minLon && maxLon >= this.maxLon) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        PointValues.Relation shapeRelation = this.componentRelate(minLat, maxLat, minLon, maxLon);
        if (shapeRelation != null) {
            return shapeRelation;
        }
        if (this.tree.crosses(minLat, maxLat, minLon, maxLon)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    protected static EdgeTree createTree(EdgeTree[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator comparator = splitX ? (left, right) -> {
                int ret = Double.compare(left.minLon, right.minLon);
                if (ret == 0) {
                    ret = Double.compare(left.maxX, right.maxX);
                }
                return ret;
            } : (left, right) -> {
                int ret = Double.compare(left.minLat, right.minLat);
                if (ret == 0) {
                    ret = Double.compare(left.maxY, right.maxY);
                }
                return ret;
            };
            ArrayUtil.select(components, low, high + 1, mid, comparator);
        }
        EdgeTree newNode = components[mid];
        newNode.splitX = splitX;
        newNode.left = EdgeTree.createTree(components, low, mid - 1, !splitX);
        newNode.right = EdgeTree.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        return newNode;
    }

    private static Edge createTree(double[] lats, double[] lons) {
        Edge[] edges = new Edge[lats.length - 1];
        for (int i = 1; i < lats.length; ++i) {
            double lat1 = lats[i - 1];
            double lon1 = lons[i - 1];
            double lat2 = lats[i];
            double lon2 = lons[i];
            edges[i - 1] = new Edge(lat1, lon1, lat2, lon2, Math.min(lat1, lat2), Math.max(lat1, lat2));
        }
        Arrays.sort(edges, (left, right) -> {
            int ret = Double.compare(left.low, right.low);
            if (ret == 0) {
                ret = Double.compare(left.max, right.max);
            }
            return ret;
        });
        return EdgeTree.createTree(edges, 0, edges.length - 1);
    }

    private static Edge createTree(Edge[] edges, int low, int high) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        Edge newNode = edges[mid];
        newNode.left = EdgeTree.createTree(edges, low, mid - 1);
        newNode.right = EdgeTree.createTree(edges, mid + 1, high);
        if (newNode.left != null) {
            newNode.max = Math.max(newNode.max, newNode.left.max);
        }
        if (newNode.right != null) {
            newNode.max = Math.max(newNode.max, newNode.right.max);
        }
        return newNode;
    }

    static class Edge {
        final double lat1;
        final double lat2;
        final double lon1;
        final double lon2;
        final double low;
        double max;
        Edge left;
        Edge right;

        Edge(double lat1, double lon1, double lat2, double lon2, double low, double max) {
            this.lat1 = lat1;
            this.lon1 = lon1;
            this.lat2 = lat2;
            this.lon2 = lon2;
            this.low = low;
            this.max = max;
        }

        boolean crossesTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
            double minLat = StrictMath.min(StrictMath.min(ay, by), cy);
            double minLon = StrictMath.min(StrictMath.min(ax, bx), cx);
            double maxLat = StrictMath.max(StrictMath.max(ay, by), cy);
            double maxLon = StrictMath.max(StrictMath.max(ax, bx), cx);
            if (minLat <= this.max) {
                boolean outside;
                double dy = this.lat1;
                double ey = this.lat2;
                double dx = this.lon1;
                double ex = this.lon2;
                boolean bl = outside = dy < minLat && ey < minLat || dy > maxLat && ey > maxLat || dx < minLon && ex < minLon || dx > maxLon && ex > maxLon;
                if (!outside) {
                    if (GeoUtils.lineCrossesLine(ax, ay, bx, by, dx, dy, ex, ey)) {
                        return true;
                    }
                    if (GeoUtils.lineCrossesLine(bx, by, cx, cy, dx, dy, ex, ey)) {
                        return true;
                    }
                    if (GeoUtils.lineCrossesLine(cx, cy, ax, ay, dx, dy, ex, ey)) {
                        return true;
                    }
                }
                if (this.left != null && this.left.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                    return true;
                }
                if (this.right != null && maxLat >= this.low && this.right.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                    return true;
                }
            }
            return false;
        }

        boolean crosses(double minLat, double maxLat, double minLon, double maxLon) {
            if (minLat <= this.max) {
                boolean outside;
                double cy = this.lat1;
                double dy = this.lat2;
                double cx = this.lon1;
                double dx = this.lon2;
                boolean bl = outside = cy < minLat && dy < minLat || cy > maxLat && dy > maxLat || cx < minLon && dx < minLon || cx > maxLon && dx > maxLon;
                if (Rectangle.containsPoint(cy, cx, minLat, maxLat, minLon, maxLon) || Rectangle.containsPoint(dy, dx, minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
                if (!outside) {
                    if (GeoUtils.orient(cx, cy, dx, dy, minLon, maxLat) * GeoUtils.orient(cx, cy, dx, dy, maxLon, maxLat) <= 0 && GeoUtils.orient(minLon, maxLat, maxLon, maxLat, cx, cy) * GeoUtils.orient(minLon, maxLat, maxLon, maxLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (GeoUtils.orient(cx, cy, dx, dy, maxLon, maxLat) * GeoUtils.orient(cx, cy, dx, dy, maxLon, minLat) <= 0 && GeoUtils.orient(maxLon, maxLat, maxLon, minLat, cx, cy) * GeoUtils.orient(maxLon, maxLat, maxLon, minLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (GeoUtils.orient(cx, cy, dx, dy, maxLon, minLat) * GeoUtils.orient(cx, cy, dx, dy, minLon, minLat) <= 0 && GeoUtils.orient(maxLon, minLat, minLon, minLat, cx, cy) * GeoUtils.orient(maxLon, minLat, minLon, minLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (GeoUtils.orient(cx, cy, dx, dy, minLon, minLat) * GeoUtils.orient(cx, cy, dx, dy, minLon, maxLat) <= 0 && GeoUtils.orient(minLon, minLat, minLon, maxLat, cx, cy) * GeoUtils.orient(minLon, minLat, minLon, maxLat, dx, dy) <= 0) {
                        return true;
                    }
                }
                if (this.left != null && this.left.crosses(minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
                if (this.right != null && maxLat >= this.low && this.right.crosses(minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
            }
            return false;
        }
    }
}

