/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AbinitReader
extends AtomSetCollectionReader {
    private float[] znucl;
    private boolean inputOnly;
    private int nAtom;
    private int nType;
    private float[] typeArray;
    float[] cellLattice;

    @Override
    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
        this.setFractionalCoordinates(false);
        this.inputOnly = this.checkFilterKey("INPUT");
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("natom")) {
            this.readNoatom();
        } else if (this.line.contains("ntypat") || this.line.contains("ntype")) {
            this.readNotypes();
        } else if (this.line.contains("typat") || this.line.contains("type")) {
            this.readTypesequence();
        } else if (this.line.contains("Pseudopotential")) {
            this.readAtomSpecies();
        } else if (this.line.contains("Symmetries :")) {
            this.readSpaceGroup();
        } else if (this.line.contains("Real(R)+Recip(G)")) {
            this.readIntiallattice();
            if (this.inputOnly) {
                this.continuing = false;
            }
        } else if (this.line.contains("xcart")) {
            this.readAtoms();
        }
        return true;
    }

    private void readNoatom() throws Exception {
        String[] stringArray = this.getTokens();
        if (stringArray.length <= 2) {
            this.nAtom = this.parseIntStr(stringArray[1]);
        }
    }

    private void readNotypes() throws Exception {
        String[] stringArray = this.getTokens();
        if (stringArray.length <= 2) {
            this.nType = this.parseIntStr(stringArray[1]);
        }
    }

    private void readTypesequence() throws Exception {
        this.typeArray = new float[this.nAtom];
        this.fillFloatArray(this.line.substring(12), 0, this.typeArray);
    }

    private void readAtomSpecies() throws Exception {
        this.znucl = new float[this.nType];
        int n = 0;
        while (n < this.nType) {
            this.discardLinesUntilContains("zion");
            String[] stringArray = this.getTokens();
            this.znucl[n] = this.parseFloatStr(stringArray[stringArray[0] == "-" ? 1 : 0]);
            ++n;
        }
    }

    private void readSpaceGroup() throws Exception {
    }

    private void readIntiallattice() throws Exception {
        float f = 0.0f;
        this.cellLattice = new float[9];
        int n = 0;
        while (n < 9) {
            if (n % 3 == 0) {
                this.line = this.rd().substring(6);
                f = this.parseFloatStr(this.line);
            }
            this.cellLattice[n] = f * 0.5291772f;
            f = this.parseFloat();
            ++n;
        }
        this.applySymmetry();
    }

    private void applySymmetry() throws Exception {
        if (this.cellLattice == null) {
            return;
        }
        this.setSpaceGroupName("P1");
        int n = 0;
        while (n < 3) {
            this.addExplicitLatticeVector(n, this.cellLattice, n * 3);
            ++n;
        }
        Atom[] atomArray = this.asc.atoms;
        int n2 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        if (!this.iHaveFractionalCoordinates) {
            int n3 = this.asc.ac;
            while (--n3 >= n2) {
                this.setAtomCoord(atomArray[n3]);
            }
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtoms() throws Exception {
        Atom[] atomArray;
        this.asc.newAtomSet();
        this.iHaveFractionalCoordinates = false;
        int n = this.asc.ac;
        this.line = this.line.substring(12);
        while (this.line != null && !this.line.contains("x")) {
            atomArray = this.asc.addNewAtom();
            this.setAtomCoordScaled((Atom)atomArray, this.getTokens(), 0, 0.5291772f);
            this.rd();
        }
        this.discardLinesUntilContains("z");
        if (this.znucl == null) {
            this.znucl = new float[this.nType];
            this.fillFloatArray(this.line.substring(12), 0, this.znucl);
        }
        atomArray = this.asc.atoms;
        int n2 = 0;
        while (n2 < this.nAtom) {
            atomArray[n2 + n].elementNumber = (short)this.znucl[(int)this.typeArray[n2] - 1];
            ++n2;
        }
        this.applySymmetry();
    }
}

