/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

class UnixFileModeAttribute {
    static final int ALL_PERMISSIONS = 511;
    static final int ALL_READWRITE = 438;
    static final int TEMPFILE_PERMISSIONS = 448;

    private UnixFileModeAttribute() {
    }

    static int toUnixMode(Set<PosixFilePermission> perms) {
        int mode = 0;
        for (PosixFilePermission perm : perms) {
            if (perm == null) {
                throw new NullPointerException();
            }
            switch (perm) {
                case OWNER_READ: {
                    mode |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    mode |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    mode |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    mode |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    mode |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    mode |= 8;
                    break;
                }
                case OTHERS_READ: {
                    mode |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    mode |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    mode |= 1;
                }
            }
        }
        return mode;
    }

    static int toUnixMode(int defaultMode, FileAttribute<?> ... attrs) {
        int mode = defaultMode;
        for (FileAttribute<?> attr : attrs) {
            String name = attr.name();
            if (!name.equals("posix:permissions") && !name.equals("unix:permissions")) {
                throw new UnsupportedOperationException("'" + attr.name() + "' not supported as initial attribute");
            }
            mode = UnixFileModeAttribute.toUnixMode((Set)attr.value());
        }
        return mode;
    }
}

