/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.netbeans.lib.profiler.ui.components.LazyComboBox;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ui.Bundle;
import org.openide.util.Lookup;

public class ProjectSelector
extends LazyComboBox<Lookup.Provider> {
    public static final Lookup.Provider EXTERNAL_PROCESS = new Lookup.Provider(){

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    };

    public ProjectSelector(Populator populator) {
        super((LazyComboBox.Populator)populator);
        this.setRenderer(new ProjectNameRenderer());
    }

    public final Lookup.Provider getProject() {
        Lookup.Provider provider = (Lookup.Provider)this.getSelectedItem();
        return provider == EXTERNAL_PROCESS ? null : provider;
    }

    public final void setProject(Lookup.Provider provider) {
        this.setSelectedItem(provider == null ? EXTERNAL_PROCESS : provider);
    }

    public void resetProject(Lookup.Provider provider) {
        if (this.getProject() == provider) {
            this.resetModel();
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Font _plainFont;
        private Font _boldFont;
        private Renderer _renderer;

        private ProjectNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (this._renderer == null) {
                this._renderer = new Renderer();
            }
            this._renderer.setComponentOrientation(jLabel.getComponentOrientation());
            this._renderer.setOpaque(jLabel.isOpaque());
            this._renderer.setForeground(jLabel.getForeground());
            this._renderer.setBackground(jLabel.getBackground());
            this._renderer.setEnabled(jLabel.isEnabled());
            this._renderer.setBorder(jLabel.getBorder());
            if (object != EXTERNAL_PROCESS) {
                Lookup.Provider provider = (Lookup.Provider)object;
                this._renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                this._renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)provider));
                boolean bl3 = ProjectUtilities.getMainProject() == object;
                this._renderer.setFontEx(bl3 ? this.boldFont(jLabel) : this.plainFont(jLabel));
            } else {
                this._renderer.setText(Bundle.ProjectSelector_ExternalProcess());
                this._renderer.setIcon(Icons.getIcon((String)"GeneralIcons.JavaProcess"));
                this._renderer.setFontEx(this.plainFont(jLabel));
            }
            return this._renderer;
        }

        private Font plainFont(JLabel jLabel) {
            if (this._plainFont == null) {
                this._plainFont = jLabel.getFont().deriveFont(0);
            }
            return this._plainFont;
        }

        private Font boldFont(JLabel jLabel) {
            if (this._boldFont == null) {
                this._boldFont = jLabel.getFont().deriveFont(1);
            }
            return this._boldFont;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    public static class Populator
    extends LazyComboBox.Populator<Lookup.Provider> {
        protected Lookup.Provider initialProject() {
            return null;
        }

        protected Collection<Lookup.Provider> additionalProjects() {
            return Collections.EMPTY_SET;
        }

        protected final Lookup.Provider initial() {
            Lookup.Provider provider = this.initialProject();
            return provider == null ? EXTERNAL_PROCESS : provider;
        }

        protected final Lookup.Provider[] populate() {
            HashSet<Lookup.Provider> hashSet = new HashSet<Lookup.Provider>();
            hashSet.addAll(Arrays.asList(ProjectUtilities.getOpenedProjects()));
            hashSet.addAll(this.additionalProjects());
            ArrayList<Lookup.Provider> arrayList = new ArrayList<Lookup.Provider>();
            Lookup.Provider[] providerArray = hashSet.toArray(new Lookup.Provider[0]);
            arrayList.add(EXTERNAL_PROCESS);
            arrayList.addAll(Arrays.asList(ProjectUtilities.getSortedProjects((Lookup.Provider[])providerArray)));
            return arrayList.toArray(new Lookup.Provider[0]);
        }
    }
}

