/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Map;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

final class LazyNode
extends FilterNode {
    private Map<String, ?> map;

    LazyNode(Map<String, ?> map) {
        this(new AbstractNode(new Children.Array()), map);
    }

    private LazyNode(AbstractNode abstractNode, Map<String, ?> map) {
        super(abstractNode, new SwitchChildren(abstractNode));
        ((SwitchChildren)this.getChildren()).node = this;
        this.map = map;
        abstractNode.setName((String)map.get("name"));
        abstractNode.setDisplayName((String)map.get("displayName"));
        abstractNode.setShortDescription((String)map.get("shortDescription"));
        String string = (String)map.get("iconResource");
        if (string != null) {
            abstractNode.setIconBaseWithExtension(string);
        }
    }

    @Override
    public Action[] getActions(boolean bl) {
        return this.switchToOriginal().getActions(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Node switchToOriginal() {
        final Node[] nodeArray = new Node[]{null};
        LazyNode lazyNode = this;
        synchronized (lazyNode) {
            if (this.map == null) {
                return this.getOriginal();
            }
            nodeArray[0] = (Node)this.map.get("original");
            if (nodeArray[0] == null) {
                throw new IllegalArgumentException("Original Node from map " + this.map + " is null");
            }
            this.map = null;
        }
        FilterNode.Children.MUTEX.postWriteRequest(new Runnable(){

            @Override
            public void run() {
                LazyNode.this.changeOriginal(nodeArray[0], true);
            }
        });
        return nodeArray[0];
    }

    private static final class SwitchChildren
    extends FilterNode.Children {
        LazyNode node;

        public SwitchChildren(Node node) {
            super(node);
        }

        @Override
        protected void addNotify() {
            this.node.switchToOriginal();
            super.addNotify();
        }

        @Override
        public Node[] getNodes(boolean bl) {
            this.node.switchToOriginal();
            return super.getNodes(bl);
        }

        @Override
        public int getNodesCount(boolean bl) {
            this.node.switchToOriginal();
            return super.getNodesCount(bl);
        }

        @Override
        public Node findChild(String string) {
            this.node.switchToOriginal();
            return super.findChild(string);
        }
    }
}

