/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(highlighters);
    }

    boolean hitsExecutionNeeded(SearchContext context) {
        return context.highlight() != null && !PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query()).isEmpty();
    }

    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!this.hitsExecutionNeeded(context)) {
            return;
        }
        List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query());
        if (percolateQueries.isEmpty()) {
            throw new IllegalStateException("couldn't locate percolator query");
        }
        boolean singlePercolateQuery = percolateQueries.size() == 1;
        for (PercolateQuery percolateQuery : percolateQueries) {
            String fieldName = singlePercolateQuery ? "_percolator_document_slot" : "_percolator_document_slot_" + percolateQuery.getName();
            List ctxs = context.searcher().getIndexReader().leaves();
            IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
            PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
            LeafReaderContext percolatorLeafReaderContext = (LeafReaderContext)percolatorIndexSearcher.getIndexReader().leaves().get(0);
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
            for (SearchHit hit : hits) {
                DocumentField field;
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)hit.docId(), (List)ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                Query query = (Query)queryStore.getQueries(ctx).apply((Object)segmentDocId);
                if (query == null || (field = hit.field(fieldName)) == null) continue;
                for (Object matchedSlot : field.getValues()) {
                    int slot = (Integer)matchedSlot;
                    BytesReference document = percolateQuery.getDocuments().get(slot);
                    SubSearchContext subSearchContext = this.createSubSearchContext(context, percolatorLeafReaderContext, document, slot);
                    subSearchContext.parsedQuery(new ParsedQuery(query));
                    hitContext.reset(new SearchHit(slot, "unknown", new Text(hit.getType()), Collections.emptyMap()), percolatorLeafReaderContext, slot, percolatorIndexSearcher);
                    hitContext.cache().clear();
                    this.highlightPhase.hitExecute((SearchContext)subSearchContext, hitContext);
                    for (Map.Entry entry : hitContext.hit().getHighlightFields().entrySet()) {
                        String hlFieldName;
                        if (percolateQuery.getDocuments().size() == 1) {
                            hlFieldName = singlePercolateQuery ? (String)entry.getKey() : percolateQuery.getName() + "_" + (String)entry.getKey();
                            hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                            continue;
                        }
                        hlFieldName = singlePercolateQuery ? slot + "_" + (String)entry.getKey() : percolateQuery.getName() + "_" + slot + "_" + (String)entry.getKey();
                        hit.getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, ((HighlightField)entry.getValue()).fragments()));
                    }
                }
            }
        }
    }

    static List<PercolateQuery> locatePercolatorQuery(Query query) {
        if (query instanceof PercolateQuery) {
            return Collections.singletonList((PercolateQuery)query);
        }
        if (query instanceof BooleanQuery) {
            ArrayList<PercolateQuery> percolateQueries = new ArrayList<PercolateQuery>();
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                List<PercolateQuery> result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(clause.getQuery());
                if (result.isEmpty()) continue;
                percolateQueries.addAll(result);
            }
            return percolateQueries;
        }
        if (query instanceof DisjunctionMaxQuery) {
            ArrayList<PercolateQuery> percolateQueries = new ArrayList<PercolateQuery>();
            for (Query disjunct : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                List<PercolateQuery> result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(disjunct);
                if (result.isEmpty()) continue;
                percolateQueries.addAll(result);
            }
            return percolateQueries;
        }
        if (query instanceof ConstantScoreQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((ConstantScoreQuery)query).getQuery());
        }
        if (query instanceof BoostQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((BoostQuery)query).getQuery());
        }
        if (query instanceof FunctionScoreQuery) {
            return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((FunctionScoreQuery)query).getSubQuery());
        }
        return Collections.emptyList();
    }

    private SubSearchContext createSubSearchContext(SearchContext context, LeafReaderContext leafReaderContext, BytesReference source, int docId) {
        SubSearchContext subSearchContext = new SubSearchContext(context);
        subSearchContext.highlight(new SearchContextHighlight(context.highlight().fields()));
        subSearchContext.highlight().globalForceSource(true);
        subSearchContext.lookup().source().setSegmentAndDocument(leafReaderContext, docId);
        subSearchContext.lookup().source().setSource(source);
        return subSearchContext;
    }
}

