/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.sheets.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;

public class ExcelSheetRow
implements SheetRow {
    private static final DataFormatter FORMATTER = new DataFormatter();
    private final Row row;
    private final int firstIndex;
    private final int lastIndex;

    public ExcelSheetRow(Row row, int firstIndex, int lastIndex) {
        this.row = row;
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String get(int index) {
        String value;
        Cell cell = this.row.getCell(index += this.firstIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if ((value = ExcelSheetRow.getRowCellAsString(cell, index)) != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        return value;
    }

    @Override
    public int size() {
        return this.lastIndex - this.firstIndex + 1;
    }

    public static String getRowCellAsString(Cell cell, int index) {
        if (cell == null) {
            return null;
        }
        return FORMATTER.formatCellValue(cell);
    }
}

