/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.io.Serializable;
import org.grails.datastore.mapping.cache.TPCacheAdapter;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.LockableEntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.context.ApplicationEventPublisher;

public abstract class ThirdPartyCacheEntityPersister<T>
extends LockableEntityPersister {
    protected TPCacheAdapterRepository<T> cacheAdapterRepository;

    public ThirdPartyCacheEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
    }

    public ThirdPartyCacheEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher, TPCacheAdapterRepository<T> cacheAdapterRepository) {
        super(mappingContext, entity, session, publisher);
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    protected void updateTPCache(PersistentEntity persistentEntity, T e, Serializable id) {
        if (this.cacheAdapterRepository == null) {
            return;
        }
        TPCacheAdapter<T> cacheAdapter = this.cacheAdapterRepository.getTPCacheAdapter(persistentEntity);
        if (cacheAdapter != null) {
            cacheAdapter.cacheEntry(id, e);
        }
    }

    protected T getFromTPCache(PersistentEntity persistentEntity, Serializable id) {
        if (this.cacheAdapterRepository == null) {
            return null;
        }
        TPCacheAdapter<T> cacheAdapter = this.cacheAdapterRepository.getTPCacheAdapter(persistentEntity);
        if (cacheAdapter != null) {
            return cacheAdapter.getCachedEntry(id);
        }
        return null;
    }
}

