/*
 * Decompiled with CFR 0.152.
 */
package grails.build.support;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaClassRegistryChangeEvent;
import groovy.lang.MetaClassRegistryChangeEventListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;

public class MetaClassRegistryCleaner
implements MetaClassRegistryChangeEventListener {
    private Map<Class, Object> alteredClasses = new ConcurrentHashMap<Class, Object>();
    private Map<IdentityWeakReference, Object> alteredInstances = new ConcurrentHashMap<IdentityWeakReference, Object>();
    private static final Object NO_CUSTOM_METACLASS = new Object();
    private static boolean cleaning;
    private static final MetaClassRegistryCleaner INSTANCE;

    private MetaClassRegistryCleaner() {
    }

    public static MetaClassRegistryCleaner createAndRegister() {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        MetaClassRegistryChangeEventListener[] listeners = metaClassRegistry.getMetaClassRegistryChangeEventListeners();
        boolean registered = false;
        for (MetaClassRegistryChangeEventListener listener : listeners) {
            if (listener != INSTANCE) continue;
            registered = true;
            break;
        }
        if (!registered) {
            GroovySystem.getMetaClassRegistry().addMetaClassRegistryChangeEventListener((MetaClassRegistryChangeEventListener)INSTANCE);
        }
        return INSTANCE;
    }

    public static void cleanAndRemove(MetaClassRegistryCleaner cleaner) {
        cleaner.clean();
        GroovySystem.getMetaClassRegistry().removeMetaClassRegistryChangeEventListener((MetaClassRegistryChangeEventListener)cleaner);
    }

    public static void addAlteredMetaClass(Class cls, MetaClass altered) {
        MetaClassRegistryCleaner.INSTANCE.alteredClasses.put(cls, altered);
    }

    public void updateConstantMetaClass(MetaClassRegistryChangeEvent cmcu) {
        if (!cleaning) {
            MetaClass oldMetaClass = cmcu.getOldMetaClass();
            Class classToUpdate = cmcu.getClassToUpdate();
            Object instanceToUpdate = cmcu.getInstance();
            if (instanceToUpdate == null && cmcu.getNewMetaClass() instanceof ExpandoMetaClass) {
                this.updateMetaClassOfClass(oldMetaClass, classToUpdate);
            } else if (instanceToUpdate != null) {
                this.updateMetaClassOfInstance(oldMetaClass, instanceToUpdate);
            }
        }
    }

    private void updateMetaClassOfInstance(MetaClass oldMetaClass, Object instanceToUpdate) {
        IdentityWeakReference key = new IdentityWeakReference(instanceToUpdate);
        if (oldMetaClass != null) {
            Object current = this.alteredInstances.get(key);
            if (current == null || current == NO_CUSTOM_METACLASS) {
                this.alteredInstances.put(key, oldMetaClass);
            }
        } else {
            this.alteredInstances.put(key, NO_CUSTOM_METACLASS);
        }
    }

    private void updateMetaClassOfClass(MetaClass oldMetaClass, Class classToUpdate) {
        if (oldMetaClass != null && !oldMetaClass.getClass().getName().equals("groovy.mock.interceptor.MockProxyMetaClass")) {
            Object current = this.alteredClasses.get(classToUpdate);
            if (current == null) {
                this.alteredClasses.put(classToUpdate, oldMetaClass);
            }
        } else {
            this.alteredClasses.put(classToUpdate, NO_CUSTOM_METACLASS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clean() {
        try {
            cleaning = true;
            MetaClassRegistryImpl registry = (MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry();
            this.cleanMetaClassOfClass(registry);
            this.cleanMetaClassOfInstance(registry);
        }
        finally {
            cleaning = false;
        }
    }

    private void cleanMetaClassOfInstance(MetaClassRegistryImpl registry) {
        ArrayList<IdentityWeakReference> keys = new ArrayList<IdentityWeakReference>(this.alteredInstances.keySet());
        for (IdentityWeakReference key : keys) {
            Object instance = key.get();
            if (instance == null) continue;
            Object alteredMetaClass = this.alteredInstances.get(key);
            if (alteredMetaClass == NO_CUSTOM_METACLASS) {
                alteredMetaClass = null;
            }
            registry.setMetaClass(instance, (MetaClass)alteredMetaClass);
        }
        this.alteredInstances.clear();
    }

    private void cleanMetaClassOfClass(MetaClassRegistryImpl registry) {
        HashSet<Class> classes = new HashSet<Class>(this.alteredClasses.keySet());
        for (Class aClass : classes) {
            Object alteredMetaClass = this.alteredClasses.get(aClass);
            if (alteredMetaClass == NO_CUSTOM_METACLASS) {
                registry.removeMetaClass(aClass);
                continue;
            }
            registry.setMetaClass(aClass, (MetaClass)alteredMetaClass);
        }
        this.alteredClasses.clear();
    }

    static {
        INSTANCE = new MetaClassRegistryCleaner();
    }

    private static final class IdentityWeakReference
    extends WeakReference<Object> {
        private int hash;

        public IdentityWeakReference(Object referent) {
            super(referent);
            this.hash = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return this.get() == ((IdentityWeakReference)obj).get();
        }
    }
}

