/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.CU;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;

class TextRenderer {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private byte[] tmap;
    private boolean isInvalid;
    private static final byte[] translucency = new byte[]{7, 6, 5, 4, 3, 2, 1, 8};
    private static boolean working;
    private static final Map<Font, Map<String, TextRenderer>> htFont3d;
    private static final Map<Font, Map<String, TextRenderer>> htFont3dAntialias;

    static {
        htFont3d = new Hashtable<Font, Map<String, TextRenderer>>();
        htFont3dAntialias = new Hashtable<Font, Map<String, TextRenderer>>();
    }

    static synchronized void clearFontCache() {
        if (working) {
            return;
        }
        htFont3d.clear();
        htFont3dAntialias.clear();
    }

    static int plot(int n, int n2, int n3, int n4, int n5, String string, Font font, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf("<su") >= 0 || string.indexOf("<color") >= 0) {
            return TextRenderer.plotByCharacter(n, n2, n3, n4, n5, string, font, graphics3D, jmolRendererInterface, bl);
        }
        int n6 = font.getAscent();
        TextRenderer textRenderer = TextRenderer.getPlotText3D(n, n2 -= n6, graphics3D, string, font, bl);
        if (textRenderer.isInvalid) {
            return textRenderer.width;
        }
        if (bl && (n4 & 0xC0C0C0) == 0) {
            n4 |= 0x40404;
        }
        int n7 = textRenderer.height;
        int n8 = textRenderer.width;
        byte[] byArray = textRenderer.tmap;
        Graphics3D graphics3D2 = graphics3D;
        int n9 = graphics3D2.width;
        int n10 = graphics3D2.height;
        int[] nArray = graphics3D2.zbuf;
        Pixelator pixelator = graphics3D2.pixel;
        int n11 = graphics3D2.translucencyLog;
        if (jmolRendererInterface != null || (n < 0 || n + textRenderer.width > n9 || n2 < 0 || n2 + textRenderer.height > n10) && (jmolRendererInterface = graphics3D) != null) {
            int n12 = 0;
            int n13 = 0;
            while (n13 < n7) {
                int n14 = 0;
                while (n14 < n8) {
                    byte by;
                    if ((by = byArray[n12++]) != 0) {
                        jmolRendererInterface.plotImagePixel(n4, n + n14, n2 + n13, n3, by, n5, n9, n10, nArray, pixelator, n11);
                    }
                    ++n14;
                }
                ++n13;
            }
        } else {
            int n15 = 0;
            int n16 = 0;
            int n17 = n2 * n9 + n;
            while (n15 < n7) {
                int n18 = 0;
                while (n18 < n8) {
                    pixelator.addImagePixel(byArray[n16++], n11, n17++, n3, n4, n5);
                    ++n18;
                }
                ++n15;
                n17 += n9 - n8;
            }
        }
        return textRenderer.width;
    }

    /*
     * Unable to fully structure code
     */
    private static int plotByCharacter(int var0, int var1_1, int var2_2, int var3_3, int var4_4, String var5_5, Font var6_6, Graphics3D var7_7, JmolRendererInterface var8_8, boolean var9_9) {
        var10_10 = 0;
        var11_11 = var5_5.length();
        var12_12 = Math.round((float)var6_6.getHeight() * 0.25f);
        var13_13 = -Math.round((float)var6_6.getHeight() * 0.3f);
        var14_14 = 0;
        var15_15 = 0;
        while (var15_15 < var11_11) {
            if (var5_5.charAt(var15_15) != '<') ** GOTO lbl-1000
            if (var15_15 + 5 < var11_11 && var5_5.substring(var15_15, var15_15 + 6).equals("<color")) {
                var14_14 = var3_3;
                var16_16 = var5_5.indexOf(">", var15_15);
                if (var16_16 >= 0) {
                    var3_3 = CU.getArgbFromString(var5_5.substring(var15_15 + 7, var16_16).trim());
                    var15_15 = var16_16;
                }
            } else if (var15_15 + 7 < var11_11 && var5_5.substring(var15_15, var15_15 + 8).equals("</color>")) {
                var15_15 += 7;
                var3_3 = var14_14;
            } else if (var15_15 + 4 < var11_11 && var5_5.substring(var15_15, var15_15 + 5).equals("<sub>")) {
                var15_15 += 4;
                var1_1 += var12_12;
            } else if (var15_15 + 4 < var11_11 && var5_5.substring(var15_15, var15_15 + 5).equals("<sup>")) {
                var15_15 += 4;
                var1_1 += var13_13;
            } else if (var15_15 + 5 < var11_11 && var5_5.substring(var15_15, var15_15 + 6).equals("</sub>")) {
                var15_15 += 5;
                var1_1 -= var12_12;
            } else if (var15_15 + 5 < var11_11 && var5_5.substring(var15_15, var15_15 + 6).equals("</sup>")) {
                var15_15 += 5;
                var1_1 -= var13_13;
            } else lbl-1000:
            // 2 sources

            {
                var16_16 = TextRenderer.plot(var0 + var10_10, var1_1, var2_2, var3_3, var4_4, var5_5.substring(var15_15, var15_15 + 1), var6_6, var7_7, var8_8, var9_9);
                var10_10 += var16_16;
            }
            ++var15_15;
        }
        return var10_10;
    }

    private TextRenderer(String string, Font font) {
        this.ascent = font.getAscent();
        this.height = font.getHeight();
        this.width = font.stringWidth(string);
        if (this.width == 0) {
            return;
        }
        this.mapWidth = this.width;
        this.size = this.mapWidth * this.height;
    }

    private static synchronized TextRenderer getPlotText3D(int n, int n2, Graphics3D graphics3D, String string, Font font, boolean bl) {
        working = true;
        Map<Font, Map<String, TextRenderer>> map = bl ? htFont3dAntialias : htFont3d;
        Map<String, TextRenderer> map2 = map.get(font);
        TextRenderer textRenderer = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (map2 != null) {
            textRenderer = map2.get(string);
        } else {
            map2 = new Hashtable<String, TextRenderer>();
            bl2 = true;
        }
        if (textRenderer == null) {
            textRenderer = new TextRenderer(string, font);
            bl3 = true;
        }
        boolean bl4 = textRenderer.isInvalid = textRenderer.width == 0 || n + textRenderer.width <= 0 || n >= graphics3D.width || n2 + textRenderer.height <= 0 || n2 >= graphics3D.height;
        if (textRenderer.isInvalid) {
            return textRenderer;
        }
        if (bl2) {
            map.put(font, map2);
        }
        if (bl3) {
            textRenderer.setTranslucency(string, font, graphics3D);
            map2.put(string, textRenderer);
        }
        working = false;
        return textRenderer;
    }

    private void setTranslucency(String string, Font font, Graphics3D graphics3D) {
        int[] nArray = graphics3D.apiPlatform.getTextPixels(string, font, graphics3D.platform.getGraphicsForTextOrImage(this.mapWidth, this.height), graphics3D.platform.offscreenImage, this.mapWidth, this.height, this.ascent);
        if (nArray == null) {
            return;
        }
        this.tmap = new byte[this.size];
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n] & 0xFF;
            if (n2 == 0) continue;
            this.tmap[n] = translucency[n2 >> 5];
        }
    }
}

