/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BugReportSender
extends Thread {
    public static final BugReportSendingHandler FALLBACK_BUGREPORT_SENDING_HANDLER;
    private static volatile BugReportSendingHandler handler;
    private final String statusText;
    private String errorMessage;

    protected BugReportSender(String statusText) {
        super("Bug report sender");
        this.statusText = statusText;
    }

    @Override
    public void run() {
        try {
            String debugTextPasteId = this.pasteDebugText();
            String bugUrl = BugReportSender.getJOSMTicketURL() + "?pdata_stored=" + debugTextPasteId;
            this.errorMessage = handler.sendingBugReport(bugUrl, this.statusText);
            if (this.errorMessage != null) {
                Logging.warn(this.errorMessage);
                handler.failed(this.errorMessage, this.statusText);
            }
        }
        catch (BugReportSenderException e) {
            Logging.warn(e);
            this.errorMessage = e.getMessage();
            handler.failed(this.errorMessage, this.statusText);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String pasteDebugText() throws BugReportSenderException {
        try {
            String text = Utils.strip(this.statusText);
            String pdata = Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8));
            String postQuery = "pdata=" + URLEncoder.encode(pdata, "UTF-8");
            HttpClient client = HttpClient.create(new URL(BugReportSender.getJOSMTicketURL()), "POST").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(postQuery.getBytes(StandardCharsets.UTF_8));
            HttpClient.Response connection = client.connect();
            if (connection.getResponseCode() >= 500) {
                throw new BugReportSenderException("Internal server error.");
            }
            try (InputStream in = connection.getContent();){
                String string = BugReportSender.retrieveDebugToken(XmlUtils.parseSafeDOM(in));
                return string;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException t) {
            throw new BugReportSenderException(t);
        }
    }

    private static String getJOSMTicketURL() {
        return Config.getUrls().getJOSMWebsite() + "/josmticket";
    }

    private static String retrieveDebugToken(Document document) throws XPathExpressionException, BugReportSenderException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String status = (String)xpath.compile("/josmticket/@status").evaluate(document, XPathConstants.STRING);
        if (!"ok".equals(status)) {
            String message = (String)xpath.compile("/josmticket/error/text()").evaluate(document, XPathConstants.STRING);
            if (message.isEmpty()) {
                message = "Error in server response but server did not tell us what happened.";
            }
            throw new BugReportSenderException(message);
        }
        String token = (String)xpath.compile("/josmticket/preparedid/text()").evaluate(document, XPathConstants.STRING);
        if (token.isEmpty()) {
            throw new BugReportSenderException("Server did not respond with a prepared id.");
        }
        return token;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public static BugReportSender reportBug(String statusText) {
        BugReportSender sender = new BugReportSender(statusText);
        sender.start();
        return sender;
    }

    public static void setBugReportSendingHandler(BugReportSendingHandler bugReportSendingHandler) {
        handler = Objects.requireNonNull(bugReportSendingHandler, "bugReportSendingHandler");
    }

    static {
        handler = FALLBACK_BUGREPORT_SENDING_HANDLER = new BugReportSendingHandler(){

            @Override
            public String sendingBugReport(String bugUrl, String statusText) {
                return OpenBrowser.displayUrl(bugUrl);
            }

            @Override
            public void failed(String errorMessage, String statusText) {
                Logging.error("Unable to send bug report: {0}\n{1}", errorMessage, statusText);
            }
        };
    }

    private static class BugReportSenderException
    extends Exception {
        BugReportSenderException(String message) {
            super(message);
        }

        BugReportSenderException(Throwable cause) {
            super(cause);
        }
    }

    public static interface BugReportSendingHandler {
        public String sendingBugReport(String var1, String var2);

        public void failed(String var1, String var2);
    }
}

