/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(string, n, inetAddress, n2);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) throws IOException, UnknownHostException {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public synchronized void close() throws IOException {
        if (this.protocol != null) {
            this.protocol.close();
        }
        super.close();
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public synchronized SSLSession getSession() {
        BCSSLConnection bCSSLConnection = this.getConnection();
        return bCSSLConnection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : bCSSLConnection.getSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (!this.context.isSupportedCipherSuites(stringArray)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun && bl != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = bl;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized void startHandshake() throws IOException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(super.getInputStream(), super.getOutputStream());
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol(super.getInputStream(), super.getOutputStream());
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
            }
        }
        finally {
            this.handshakeSession = null;
        }
    }

    public String getPeerHost() {
        String string;
        int n;
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress != null && (n = (string = inetAddress.toString()).lastIndexOf(47)) > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public int getPeerPort() {
        return this.getPort();
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        this.connection = provSSLConnection;
    }

    synchronized void handshakeIfNecessary() throws IOException {
        if (!this.initialHandshakeBegun) {
            this.startHandshake();
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            byte[] byArray = new byte[1];
            int n = ProvSSLSocketDirect.this.protocol.readApplicationData(byArray, 0, 1);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            return ProvSSLSocketDirect.this.protocol.readApplicationData(byArray, n, n2);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        public void write(int n) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            byte[] byArray = new byte[]{(byte)n};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary();
                ProvSSLSocketDirect.this.protocol.writeApplicationData(byArray, n, n2);
            }
        }
    }
}

