/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new TlsCertificate[0]);
    protected TlsCertificate[] certificateList;

    public Certificate(TlsCertificate[] tlsCertificateArray) {
        if (tlsCertificateArray == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = tlsCertificateArray;
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int n) {
        return this.certificateList[n];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n2 = 0;
        for (n = 0; n < this.certificateList.length; ++n) {
            byArray = this.certificateList[n].getEncoded();
            vector.addElement(byArray);
            n2 += byArray.length + 3;
        }
        TlsUtils.checkUint24(n2);
        TlsUtils.writeUint24(n2, outputStream);
        for (n = 0; n < vector.size(); ++n) {
            byArray = (byte[])vector.elementAt(n);
            TlsUtils.writeOpaque24(byArray, outputStream);
        }
    }

    public static Certificate parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        Object[] objectArray;
        int n = TlsUtils.readUint24(inputStream);
        if (n == 0) {
            return EMPTY_CHAIN;
        }
        byte[] byArray = TlsUtils.readFully(n, inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<TlsCertificate> vector = new Vector<TlsCertificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream);
            vector.addElement(tlsContext.getCrypto().createCertificate((byte[])objectArray));
        }
        objectArray = new TlsCertificate[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (byte)((TlsCertificate)vector.elementAt(i));
        }
        return new Certificate((TlsCertificate[])objectArray);
    }

    protected TlsCertificate[] cloneCertificateList() {
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, tlsCertificateArray, 0, tlsCertificateArray.length);
        return tlsCertificateArray;
    }
}

