/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey) {
        TlsSigner tlsSigner;
        if (privateKey instanceof RSAPrivateKey || "RSA".equals(privateKey.getAlgorithm())) {
            tlsSigner = new JcaTlsRSASigner(jcaTlsCrypto, privateKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equals(privateKey.getAlgorithm())) {
            tlsSigner = new JcaTlsDSASigner(jcaTlsCrypto, privateKey);
        } else if (privateKey instanceof ECPrivateKey || "EC".equals(privateKey.getAlgorithm())) {
            tlsSigner = new JcaTlsECDSASigner(jcaTlsCrypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return tlsSigner;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, JcaDefaultTlsCredentialedSigner.makeSigner(jcaTlsCrypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

