/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final Constructor<AlgorithmParameterSpec> specConstructor = JceAEADCipherImpl.initSpecConstructor();
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private SecretKey key;

    private static Constructor<AlgorithmParameterSpec> initSpecConstructor() {
        try {
            Class<AlgorithmParameterSpec> clazz = AccessController.doPrivileged(new PrivilegedAction<Class<AlgorithmParameterSpec>>(){

                @Override
                public Class<AlgorithmParameterSpec> run() {
                    try {
                        return Class.forName("javax.crypto.spec.GCMParameterSpec", true, IvParameterSpec.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            return clazz.getConstructor(Integer.TYPE, byte[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JceAEADCipherImpl(Cipher cipher, String string, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = string;
        this.cipherMode = bl ? 1 : 2;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) {
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    @Override
    public void init(byte[] byArray, int n, byte[] byArray2) {
        try {
            if (specConstructor != null) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = specConstructor.newInstance(n * 8, byArray);
                    this.cipher.init(this.cipherMode, (Key)this.key, algorithmParameterSpec);
                    if (byArray2 != null && byArray2.length > 0) {
                        this.cipher.updateAAD(byArray2);
                    }
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw generalSecurityException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(byArray, n * 8, byArray2));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    @Override
    public int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }
}

