/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jruby.RubySymbol;
import org.jruby.ast.IterNode;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.ClosureInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRClosure
extends IRScope {
    public final Label startLabel;
    public final Label endLabel;
    public final int closureId;
    private boolean isBeginEndBlock;
    private boolean isEND;
    private Signature signature;
    private IterNode source;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private IRBlockBody body;
    private Handle handle;
    private static final ByteList CLOSURE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95});
    private static final ByteList CLOSURE_CLONE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95, 67, 76, 79, 78, 69, 95});

    protected IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, ByteList prefix) {
        super(manager, lexicalParent, null, lineNumber, staticScope);
        this.startLabel = this.getNewLabel(prefix + "START");
        this.endLabel = this.getNewLabel(prefix + "END");
        this.closureId = lexicalParent.getNextClosureId();
        ByteList name2 = prefix.dup();
        name2.append(Integer.toString(this.closureId).getBytes());
        this.setName(manager.getRuntime().newSymbol(name2));
        this.body = null;
    }

    protected IRClosure(IRClosure c, IRScope lexicalParent, int closureId, RubySymbol fullName) {
        super(c, lexicalParent);
        boolean shouldJit;
        this.closureId = closureId;
        super.setName(fullName);
        this.startLabel = this.getNewLabel(this.getId() + "_START");
        this.endLabel = this.getNewLabel(this.getId() + "_END");
        this.body = this.getManager().isDryRun() ? null : ((shouldJit = this.getManager().getInstanceConfig().getCompileMode().shouldJIT()) ? new MixedModeIRBlockBody(c, c.getSignature()) : new InterpretedIRBlockBody(c, c.getSignature()));
        this.isEND = c.isEND;
        this.signature = c.signature;
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, boolean needsCoverage) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false, needsCoverage);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, isBeginEndBlock, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock, boolean needsCoverage) {
        this(manager, lexicalParent, lineNumber, staticScope, prefix);
        this.signature = signature;
        lexicalParent.addClosure(this);
        if (this.getManager().isDryRun()) {
            this.body = null;
        } else {
            boolean shouldJit = manager.getInstanceConfig().getCompileMode().shouldJIT();
            IRBlockBody iRBlockBody = this.body = shouldJit ? new MixedModeIRBlockBody(this, signature) : new InterpretedIRBlockBody(this, signature);
            if (staticScope != null && !isBeginEndBlock) {
                staticScope.setIRScope(this);
                staticScope.setScopeType(this.getScopeType());
            }
        }
        if (needsCoverage) {
            this.getFlags().add(IRFlags.CODE_COVERAGE);
        }
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new ClosureInterpreterContext(this, instructions);
        return this.interpreterContext;
    }

    @Override
    public InterpreterContext allocateInterpreterContext(Callable<List<Instr>> instructions) {
        try {
            this.interpreterContext = new ClosureInterpreterContext(this, instructions);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        return this.interpreterContext;
    }

    public void setIsEND() {
        this.isEND = true;
    }

    public boolean isEND() {
        return this.isEND;
    }

    public void setBeginEndBlock() {
        this.isBeginEndBlock = true;
    }

    @Override
    public boolean isBeginEndBlock() {
        return this.isBeginEndBlock;
    }

    @Override
    public int getNextClosureId() {
        return this.getLexicalParent().getNextClosureId();
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        throw new RuntimeException("Cannot get flip variables from closures.");
    }

    @Override
    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.CLOSURE);
    }

    @Override
    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        if (type2 == TemporaryVariableType.CLOSURE) {
            ++this.temporaryVariableIndex;
            return new TemporaryClosureVariable(this.closureId, this.temporaryVariableIndex);
        }
        return super.getNewTemporaryVariable(type2);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("CL" + this.closureId + "_LBL");
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.CLOSURE;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    @Override
    public boolean isFlipScope() {
        return false;
    }

    public String toStringBody() {
        return this.getId() + " = {\n" + this.toStringInstrs() + "\n}\n\n";
    }

    public BlockBody getBlockBody() {
        return this.body;
    }

    public boolean isNestedClosuresSafeForMethodConversion() {
        for (IRClosure closure : this.getClosures()) {
            if (closure.isNestedClosuresSafeForMethodConversion()) continue;
            return false;
        }
        return !this.getFlags().contains((Object)IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
    }

    public IRMethod convertToMethod(RubySymbol name2) {
        if (this.source == null || this.getFlags().contains((Object)IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES) || this.getFlags().contains((Object)IRFlags.RECEIVES_CLOSURE_ARG) || !this.isNestedClosuresSafeForMethodConversion()) {
            this.source = null;
            return null;
        }
        IterNode def = this.source;
        this.source = null;
        return new IRMethod(this.getManager(), this.getLexicalParent(), def, name2, true, this.getLine(), this.getStaticScope(), this.getFlags().contains((Object)IRFlags.CODE_COVERAGE));
    }

    public void setSource(IterNode iter) {
        this.source = iter;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.lookupExistingLVar(name2);
        if (lvar != null) {
            return lvar;
        }
        int newDepth = scopeDepth - 1;
        if (newDepth >= 0 && (lvar = this.getLexicalParent().findExistingLocalVariable(name2, newDepth)) != null) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        return lvar;
    }

    @Override
    public LocalVariable getNewLocalVariable(RubySymbol name2, int depth) {
        if (depth == 0 && !(this instanceof IRFor)) {
            ClosureLocalVariable lvar = new ClosureLocalVariable(name2, 0, this.getStaticScope().addVariableThisScope(name2.idString()));
            this.localVars.put(name2, lvar);
            return lvar;
        }
        if (!(this instanceof IRFor)) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        IRScope s2 = this;
        int d = depth;
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (d < 0) break;
        }
        return s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int depth) {
        LocalVariable lvar;
        IRScope s2 = this;
        int d = depth;
        if (depth > 0 && !(this instanceof IRFor)) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            lvar = s2.lookupExistingLVar(name2);
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (lvar != null || d < 0) break;
        }
        if (lvar == null) {
            lvar = s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
        } else {
            int lvarDepth = depth - (d + 1);
            if (lvar.getScopeDepth() != lvarDepth) {
                lvar = lvar.cloneForDepth(lvarDepth);
            }
        }
        return lvar;
    }

    protected IRClosure cloneForInlining(CloneInfo ii, IRClosure clone2) {
        clone2.isBeginEndBlock = this.isBeginEndBlock;
        SimpleCloneInfo clonedII = ii.cloneForCloningClosure(clone2);
        ArrayList<Instr> newInstrs = new ArrayList<Instr>(this.interpreterContext.getInstructions().length);
        for (Instr i2 : this.interpreterContext.getInstructions()) {
            newInstrs.add(i2.clone(clonedII));
        }
        clone2.allocateInterpreterContext(newInstrs);
        return clone2;
    }

    public IRClosure cloneForInlining(CloneInfo ii) {
        IRClosure clonedClosure;
        IRScope lexicalParent = ii.getScope();
        if (ii instanceof SimpleCloneInfo && !((SimpleCloneInfo)ii).isEnsureBlockCloneMode()) {
            clonedClosure = new IRClosure(this, lexicalParent, this.closureId, this.getName());
        } else {
            int id2 = lexicalParent.getNextClosureId();
            ByteList fullName = lexicalParent.getName().getBytes().dup();
            fullName.append(CLOSURE_CLONE);
            fullName.append(new Integer(id2).toString().getBytes());
            clonedClosure = new IRClosure(this, lexicalParent, id2, this.getManager().runtime.newSymbol(fullName));
        }
        lexicalParent.addClosure(clonedClosure);
        return this.cloneForInlining(ii, clonedClosure);
    }

    @Override
    public void setName(RubySymbol name2) {
        ByteList newName = this.getLexicalParent().getName().getBytes().dup();
        newName.append(name2.getBytes());
        super.setName(this.getManager().getRuntime().newSymbol(newName));
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }
}

