/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + "ApplicationInfo" : "ApplicationInfo";
    }

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(0);
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Element rootElement = JDOMUtil.load(ApplicationNamesInfo.class, resource);
            Element names2 = rootElement.getChild("names", rootElement.getNamespace());
            this.myProductName = names2.getAttributeValue("product");
            this.myFullProductName = names2.getAttributeValue("fullname", this.myProductName);
            this.myEditionName = names2.getAttributeValue("edition");
            this.myScriptName = names2.getAttributeValue("script");
            this.myDefaultLauncherName = names2.getAttributeValue("default-launcher-name", this.myScriptName);
            this.myMotto = names2.getAttributeValue("motto", "The Drive to Develop");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public String getProductName() {
        return this.myProductName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();
    }
}

