/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class DissectProcessor
extends AbstractProcessor {
    public static final String TYPE = "dissect";
    final String field;
    final boolean ignoreMissing;
    final String pattern;
    final String appendSeparator;
    final DissectParser dissectParser;

    DissectProcessor(String tag, String field, String pattern, String appendSeparator, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.pattern = pattern;
        this.appendSeparator = appendSeparator;
        this.dissectParser = new DissectParser(pattern, appendSeparator);
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        String input = (String)ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (input == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (input == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        this.dissectParser.parse(input).forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public DissectProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"field");
            String pattern = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"pattern");
            String appendSeparator = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"append_separator", (String)"");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new DissectProcessor(processorTag, field, pattern, appendSeparator, ignoreMissing);
        }
    }
}

