/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;

public class EncryptedMindMapNode
extends MindMapNodeModel {
    private boolean isAccessible = true;
    private boolean isStoringEncryptedContent = false;
    private boolean isDecrypted = true;
    private StringBuffer password = null;
    private String encryptedContent;
    private static ImageIcon encryptedIcon;
    private static ImageIcon decryptedIcon;
    private boolean isShuttingDown = false;

    public EncryptedMindMapNode(Object userObject, FreeMindMain frame, MindMap map) {
        super(userObject, frame, map);
        if (encryptedIcon == null) {
            encryptedIcon = MindIcon.factory("encrypted").getIcon();
        }
        if (decryptedIcon == null) {
            decryptedIcon = MindIcon.factory("decrypted").getIcon();
        }
        if (map != null) {
            this.updateIcon();
        }
    }

    @Override
    public void setMap(MindMap map) {
        super.setMap(map);
        this.updateIcon();
    }

    public boolean decrypt(StringBuffer givenPassword) {
        if (!this.checkPassword(givenPassword)) {
            return false;
        }
        this.setAccessible(true);
        if (!this.isDecrypted) {
            try {
                MindMapNodeModel node = null;
                String childXml = this.decryptXml(this.encryptedContent, this.password);
                if (childXml.startsWith("<map version=\"")) {
                    node = this.getNodeFromXml(childXml);
                } else {
                    String[] childs = childXml.split("<nodeseparator>");
                    String mapContent = "<map version=\"0.8.0\"><node TEXT=\"DUMMY\">";
                    for (int j = 0; j < childs.length; ++j) {
                        String nodeContent = childs[j];
                        mapContent = mapContent + nodeContent;
                    }
                    mapContent = mapContent + "</node></map>";
                    node = this.getNodeFromXml(mapContent);
                }
                int index = 0;
                ListIterator i = node.childrenUnfolded();
                while (i.hasNext()) {
                    MindMapNodeModel importNode = (MindMapNodeModel)i.next();
                    ((MindMapController)this.getModeController()).insertNodeInto(importNode, this, index++);
                }
                this.isDecrypted = true;
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                this.setAccessible(false);
            }
        }
        this.setFolded(false);
        this.getMap().getRegistry().registrySubtree(this, false);
        return true;
    }

    private void paste(MindMapNodeModel importNode) {
        ((MindMapController)this.getModeController()).paste(importNode, (MindMapNode)this);
    }

    private MindMapNodeModel getNodeFromXml(String childXml) throws IOException {
        MindMapNodeModel node = this.getMindMapMapModel().loadTree(new MindMapMapModel.StringReaderCreator(childXml), false);
        return node;
    }

    private MindMapMapModel getMindMapMapModel() {
        return (MindMapMapModel)this.getMap();
    }

    public boolean checkPassword(StringBuffer givenPassword) {
        if (this.password != null) {
            if (!this.equals(givenPassword, this.password)) {
                logger.warning("Wrong password supplied (cached!=given).");
                return false;
            }
            return true;
        }
        String decryptedNode = this.decryptXml(this.encryptedContent, givenPassword);
        if (decryptedNode == null) {
            logger.warning("Wrong password supplied (deciphered text is null).");
            return false;
        }
        if (!decryptedNode.startsWith("<node ") && !HtmlTools.getInstance().isWellformedXml(decryptedNode)) {
            logger.warning("Wrong password supplied (malformed deciphered text).");
            return false;
        }
        this.password = givenPassword;
        return true;
    }

    private boolean equals(StringBuffer givenPassword, StringBuffer password2) {
        if (givenPassword.length() != this.password.length()) {
            return false;
        }
        for (int i = 0; i < password2.length(); ++i) {
            char c2;
            char c1 = password2.charAt(i);
            if (c1 == (c2 = givenPassword.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void encrypt() {
        this.setFolded(true);
        this.setAccessible(false);
    }

    @Override
    public int getChildCount() {
        if (this.isAccessible()) {
            return super.getChildCount();
        }
        return 0;
    }

    @Override
    public ListIterator childrenFolded() {
        if (this.isAccessible()) {
            return super.childrenFolded();
        }
        return new Vector().listIterator();
    }

    @Override
    public ListIterator childrenUnfolded() {
        if (this.isAccessible() || this.isShuttingDown) {
            return super.childrenUnfolded();
        }
        return new Vector().listIterator();
    }

    @Override
    public boolean hasChildren() {
        if (this.isAccessible()) {
            return super.hasChildren();
        }
        return false;
    }

    public void updateIcon() {
        if (this.isAccessible()) {
            this.setStateIcon("encrypted", null);
            this.setStateIcon("decrypted", decryptedIcon);
        } else {
            this.setStateIcon("decrypted", null);
            this.setStateIcon("encrypted", encryptedIcon);
        }
    }

    public void setPassword(StringBuffer password) {
        this.password = password;
    }

    @Override
    public boolean isFolded() {
        if (this.isAccessible()) {
            return super.isFolded();
        }
        return true;
    }

    @Override
    public void setFolded(boolean folded) {
        if (this.isAccessible()) {
            super.setFolded(folded);
        } else {
            super.setFolded(true);
        }
    }

    @Override
    public void setAdditionalInfo(String info) {
        this.encryptedContent = info;
        this.setAccessible(false);
        this.isDecrypted = false;
    }

    @Override
    public String getAdditionalInfo() {
        if (this.isStoringEncryptedContent()) {
            return null;
        }
        return this.encryptedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLElement save(Writer writer, MindMapLinkRegistry registry, boolean saveHidden, boolean saveChildren) throws IOException {
        if (this.isStoringEncryptedContent()) {
            return super.save(writer, registry, saveHidden, saveChildren);
        }
        if (this.isDecrypted) {
            if (!this.isAccessible()) {
                throw new IOException("Should store contents of encrypted node " + this.getText() + ", but it is not accessible.");
            }
            this.setStoringEncryptedContent(true);
            try {
                this.generateEncryptedContent(registry);
            }
            finally {
                this.setStoringEncryptedContent(false);
            }
        }
        boolean oldIsVisible = this.isAccessible();
        this.setAccessible(false);
        XMLElement ret = null;
        try {
            ret = super.save(writer, registry, saveHidden, saveChildren);
        }
        finally {
            this.setAccessible(oldIsVisible);
        }
        return ret;
    }

    private void generateEncryptedContent(MindMapLinkRegistry registry) throws IOException {
        StringWriter sWriter = new StringWriter();
        this.getMindMapMapModel().getXml(sWriter, true, this);
        StringBuffer childXml = sWriter.getBuffer();
        this.encryptedContent = this.encryptXml(childXml);
    }

    private String encryptXml(StringBuffer childXml) {
        try {
            Tools.SingleDesEncrypter encrypter = new Tools.SingleDesEncrypter(this.password);
            String encrypted = encrypter.encrypt(childXml.toString());
            return encrypted;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            throw new IllegalArgumentException("Can't encrypt the node.");
        }
    }

    private String decryptXml(String encryptedString, StringBuffer pwd) {
        Tools.SingleDesEncrypter encrypter = new Tools.SingleDesEncrypter(pwd);
        String decrypted = encrypter.decrypt(encryptedString);
        return decrypted;
    }

    public void setShuttingDown(boolean isShuttingDown) {
        this.isShuttingDown = isShuttingDown;
    }

    private void setAccessible(boolean isAccessible) {
        this.isAccessible = isAccessible;
        this.updateIcon();
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    @Override
    public void insert(MutableTreeNode pChild, int pIndex) {
        if (!this.isAccessible()) {
            throw new IllegalArgumentException("Trying to insert nodes into a ciphered node.");
        }
        super.insert(pChild, pIndex);
    }

    @Override
    public boolean isWriteable() {
        return this.isAccessible() && super.isWriteable();
    }

    public boolean isStoringEncryptedContent() {
        return this.isStoringEncryptedContent;
    }

    public void setStoringEncryptedContent(boolean pIsStoringEncryptedContent) {
        this.isStoringEncryptedContent = pIsStoringEncryptedContent;
    }
}

