/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.ArrayList;
import javajs.util.DF;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.T4;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;
import org.jmol.shape.Uccage;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.SimpleUnitCell;

public class UccageRenderer
extends CageRenderer {
    private final P3[] verticesT = new P3[8];
    private P3 fset0 = P3.new3(555.0f, 555.0f, 1.0f);
    private P3 cell0 = new P3();
    private P3 cell1 = new P3();
    private P3 offset = new P3();
    private P3 offsetT = new P3();
    private SymmetryInterface unitcell;
    private int lineheight;
    private int xpos;
    private int ypos;

    @Override
    protected void initRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n] = new P3();
        }
        this.tickEdges = BoxInfo.uccageTickEdges;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.font3d = this.vwr.gdata.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int n = this.vwr.getObjectMad10(5);
        if (n == 0 || this.vwr.isJmolDataFrame() || this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        this.colix = this.vwr.getObjectColix(5);
        boolean bl = C.renderPass2(this.colix);
        if (!this.isExport && bl != this.vwr.gdata.isPass2) {
            return bl;
        }
        this.render1(n);
        return false;
    }

    private void render1(int n) {
        int[][] nArray;
        boolean bl;
        this.g3d.setC(this.colix);
        this.unitcell = this.vwr.getCurrentUnitCell();
        if (this.unitcell == null) {
            return;
        }
        this.isPolymer = this.unitcell.isPolymer();
        this.isSlab = this.unitcell.isSlab();
        P3[] p3Array = this.unitcell.getUnitCellVerticesNoOffset();
        this.offset.setT(this.unitcell.getCartesianOffset());
        this.offsetT.setT(this.unitcell.getFractionalOrigin());
        this.unitcell.toCartesian(this.offsetT, true);
        this.offset.sub(this.offsetT);
        boolean bl2 = this.vwr.getBoolean(603979856);
        T3 t3 = this.unitcell.getUnitCellMultiplier();
        boolean bl3 = bl = t3 != null && t3.distanceSquared(this.fset0) != 0.0f;
        if (!bl) {
            t3 = this.fset0;
        }
        int n2 = t3 instanceof T4 ? (int)((T4)t3).w : 0;
        SimpleUnitCell.ijkToPoint3f((int)t3.x, this.cell0, 0, n2);
        SimpleUnitCell.ijkToPoint3f((int)t3.y, this.cell1, 1, n2);
        if (t3.z < 0.0f) {
            this.cell0.scale(-1.0f / t3.z);
            this.cell1.scale(-1.0f / t3.z);
        }
        float f = Math.abs(t3.z);
        Axes axes = (Axes)this.vwr.shm.getShape(34);
        if (axes != null && this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        P3[] p3Array2 = axes == null || this.vwr.getObjectMad10(1) == 0 || axes.axisXY.z != 0.0f || axes.fixedOrigin != null || axes.fixedOriginUC.lengthSquared() > 0.0f ? null : axes.axisPoints;
        boolean bl4 = this.isExport || this.vwr.getObjectMad10(1) == 0 || this.vwr.getFloat(0x22000002) < 2.0f || p3Array2 == null;
        P3[] p3Array3 = p3Array2;
        Object object = nArray = (Object)(bl2 ? BoxInfo.facePoints : null);
        if (t3.z == 0.0f) {
            this.offsetT.setT(this.cell0);
            this.unitcell.toCartesian(this.offsetT, true);
            this.offsetT.add(this.offset);
            p3Array3 = this.cell0.x == 0.0f && this.cell0.y == 0.0f && this.cell0.z == 0.0f ? p3Array2 : null;
            int n3 = 0;
            int n4 = 255;
            int n5 = 255;
            P3[] p3Array4 = BoxInfo.unitCubePoints;
            int n6 = 8;
            while (--n6 >= 0) {
                P3 p3 = P3.new3(p3Array4[n6].x * (this.cell1.x - this.cell0.x), p3Array4[n6].y * (this.cell1.y - this.cell0.y), p3Array4[n6].z * (this.cell1.z - this.cell0.z));
                this.unitcell.toCartesian(p3, true);
                this.verticesT[n6].add2(p3, this.offsetT);
            }
            this.renderCage(n, this.verticesT, nArray, p3Array3, n3, n4, n5, 1.0f);
        } else {
            int n7 = (int)this.cell0.x;
            while ((float)n7 < this.cell1.x) {
                int n8 = (int)this.cell0.y;
                while ((float)n8 < this.cell1.y) {
                    int n9 = (int)this.cell0.z;
                    while ((float)n9 < this.cell1.z) {
                        int n10;
                        if (bl) {
                            this.offsetT.set(n7, n8, n9);
                            this.offsetT.scale(f);
                            this.unitcell.toCartesian(this.offsetT, true);
                            this.offsetT.add(this.offset);
                            p3Array3 = n7 == 0 && n8 == 0 && n9 == 0 ? p3Array2 : null;
                            n10 = bl4 || p3Array3 == null ? 0 : 3;
                        } else {
                            this.offsetT.setT(this.offset);
                            n10 = bl4 ? 0 : 3;
                        }
                        int n11 = 255;
                        int n12 = 255;
                        int n13 = 8;
                        while (--n13 >= 0) {
                            this.verticesT[n13].add2(p3Array[n13], this.offsetT);
                        }
                        this.renderCage(n, this.verticesT, nArray, p3Array3, n10, n11, n12, f);
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        this.renderInfo();
    }

    private void renderInfo() {
        Object object;
        String string;
        if (this.isExport || !this.vwr.getBoolean(603979828) || this.unitcell.isSimple() || this.vwr.isPreviewOnly || !this.vwr.gdata.setC(this.vwr.cm.colixBackgroundContrast) || this.vwr.gdata.getTextPosition() != 0) {
            return;
        }
        this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 14.0f * this.imageFontScaling));
        this.xpos = (int)Math.floor(5.0f * this.imageFontScaling);
        this.ypos = this.lineheight = (int)Math.floor(15.0f * this.imageFontScaling);
        String string2 = this.isPolymer ? "polymer" : (string = this.isSlab ? "slab" : this.unitcell.getSpaceGroupName());
        if (string != null) {
            if (string.startsWith("cell=!")) {
                string = "cell=inverse[" + string.substring(6) + "]";
            }
            if ((string = PT.rep(string, ";0,0,0", "")).indexOf("#") < 0 && (object = this.unitcell.getIntTableNumber()) != null) {
                string = String.valueOf(string) + " #" + (String)object;
            }
            if (!string.equals("-- [--]")) {
                this.drawInfo(string, 0, null);
            }
        }
        if ((object = this.unitcell.getMoreInfo()) != null) {
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                this.drawInfo((String)((ArrayList)object).get(n), 0, null);
                ++n;
            }
        }
        if (!this.vwr.getBoolean(603979937)) {
            return;
        }
        this.drawInfo("a=", 0, "\u00c5");
        if (!this.isPolymer) {
            this.drawInfo("b=", 1, "\u00c5");
        }
        if (!this.isPolymer && !this.isSlab) {
            this.drawInfo("c=", 2, "\u00c5");
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.drawInfo("\u03b1=", 3, "\u00b0");
                this.drawInfo("\u03b2=", 4, "\u00b0");
            }
            this.drawInfo("\u03b3=", 5, "\u00b0");
        }
    }

    private void drawInfo(String string, int n, String string2) {
        this.ypos += this.lineheight;
        if (string2 != null) {
            string = String.valueOf(string) + DF.formatDecimal(this.unitcell.getUnitCellInfoType(n), 3) + string2;
        }
        this.g3d.drawStringNoSlab(string, null, this.xpos, this.ypos, 0, (short)0);
    }
}

