/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleParser {
    private static final Set<String> STATEMENT_KEYWORDS = ContainerUtil.newHashSet("requires", "exports", "uses", "provides");
    private final JavaParser myParser;

    public ModuleParser(@NotNull JavaParser parser) {
        if (parser == null) {
            ModuleParser.$$$reportNull$$$0(0);
        }
        this.myParser = parser;
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker modifierList;
        String text2;
        if (builder == null) {
            ModuleParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker module2 = builder.mark();
        PsiBuilder.Marker firstAnnotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType type2 = builder.getTokenType();
        String string = text2 = type2 == JavaTokenType.IDENTIFIER ? builder.getTokenText() : null;
        if (!"open".equals(text2) && !"module".equals(text2)) {
            module2.rollbackTo();
            return null;
        }
        PsiBuilder.Marker marker = modifierList = firstAnnotation != null ? firstAnnotation.precede() : builder.mark();
        if ("open".equals(text2)) {
            ModuleParser.mapAndAdvance(builder, JavaTokenType.OPEN_KEYWORD);
            text2 = builder.getTokenText();
        }
        JavaParserUtil.done(modifierList, JavaElementType.MODIFIER_LIST);
        if (!"module".equals(text2)) {
            module2.drop();
            ModuleParser.parseExtras(builder, JavaErrorMessages.message("expected.module.declaration", new Object[0]));
            return module2;
        }
        ModuleParser.mapAndAdvance(builder, JavaTokenType.MODULE_KEYWORD);
        if (ModuleParser.parseName(builder) == null) {
            module2.drop();
            if (builder.getTokenType() != null) {
                ModuleParser.parseExtras(builder, JavaErrorMessages.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            return module2;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACE)) {
            if (builder.getTokenType() != null) {
                ModuleParser.parseExtras(builder, JavaErrorMessages.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            }
        } else {
            this.parseModuleContent(builder);
        }
        JavaParserUtil.done(module2, JavaElementType.MODULE);
        if (builder.getTokenType() != null) {
            ModuleParser.parseExtras(builder, JavaErrorMessages.message("unexpected.tokens", new Object[0]));
        }
        return module2;
    }

    private static PsiBuilder.Marker parseName(PsiBuilder builder) {
        PsiBuilder.Marker nameElement = builder.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            IElementType t;
            if ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER) {
                if (!idExpected) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaTokenType.DOT) break;
                if (idExpected) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            nameElement.done(JavaElementType.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private void parseModuleContent(PsiBuilder builder) {
        IElementType token;
        PsiBuilder.Marker invalid = null;
        while ((token = builder.getTokenType()) != null && token != JavaTokenType.RBRACE) {
            if (token == JavaTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaErrorMessages.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement2 = this.parseStatement(builder);
            if (statement2 == null) {
                if (invalid == null) {
                    invalid = builder.mark();
                }
                builder.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaErrorMessages.message("expected.module.statement", new Object[0]), statement2);
            invalid = null;
        }
        if (invalid != null) {
            invalid.error(JavaErrorMessages.message("expected.module.statement", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACE) && invalid == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
        }
    }

    private PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        String kw = builder.getTokenText();
        if ("requires".equals(kw)) {
            return ModuleParser.parseRequiresStatement(builder);
        }
        if ("exports".equals(kw)) {
            return this.parseExportsStatement(builder);
        }
        if ("opens".equals(kw)) {
            return this.parseOpensStatement(builder);
        }
        if ("uses".equals(kw)) {
            return this.parseUsesStatement(builder);
        }
        if ("provides".equals(kw)) {
            return this.parseProvidesStatement(builder);
        }
        return null;
    }

    private static PsiBuilder.Marker parseRequiresStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.REQUIRES_KEYWORD);
        PsiBuilder.Marker modifierList = builder.mark();
        while (true) {
            if (PsiBuilderUtil.expect(builder, ElementType.MODIFIER_BIT_SET)) {
                continue;
            }
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER || !"transitive".equals(builder.getTokenText())) break;
            ModuleParser.mapAndAdvance(builder, JavaTokenType.TRANSITIVE_KEYWORD);
        }
        JavaParserUtil.done(modifierList, JavaElementType.MODIFIER_LIST);
        if (ModuleParser.parseNameRef(builder) != null) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement2.done(JavaElementType.REQUIRES_STATEMENT);
        return statement2;
    }

    private PsiBuilder.Marker parseExportsStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.EXPORTS_KEYWORD);
        return this.parsePackageStatement(builder, statement2, JavaElementType.EXPORTS_STATEMENT);
    }

    private PsiBuilder.Marker parseOpensStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.OPENS_KEYWORD);
        return this.parsePackageStatement(builder, statement2, JavaElementType.OPENS_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parsePackageStatement(PsiBuilder builder, PsiBuilder.Marker statement2, IElementType type2) {
        boolean hasError = false;
        if (this.parseClassOrPackageRef(builder) != null) {
            if ("to".equals(builder.getTokenText())) {
                PsiBuilder.Marker ref;
                ModuleParser.mapAndAdvance(builder, JavaTokenType.TO_KEYWORD);
                do {
                    ref = ModuleParser.parseNameRef(builder);
                } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement2.done(type2);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            ModuleParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    private PsiBuilder.Marker parseUsesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.USES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) != null) {
            JavaParserUtil.semicolon(builder);
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement2.done(JavaElementType.USES_STATEMENT);
        return statement2;
    }

    private PsiBuilder.Marker parseProvidesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement2 = builder.mark();
        boolean hasError = false;
        ModuleParser.mapAndAdvance(builder, JavaTokenType.PROVIDES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if ("with".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.WITH_KEYWORD);
            hasError = this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.WITH_KEYWORD, JavaElementType.PROVIDES_WITH_LIST, JavaTokenType.COMMA);
        } else if (!hasError) {
            IElementType next = builder.getTokenType();
            if (next == JavaTokenType.IDENTIFIER && !STATEMENT_KEYWORDS.contains(builder.getTokenText())) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                marker.error(JavaErrorMessages.message("expected.with", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement2.done(JavaElementType.PROVIDES_STATEMENT);
        return statement2;
    }

    private static PsiBuilder.Marker parseNameRef(PsiBuilder builder) {
        PsiBuilder.Marker name = ModuleParser.parseName(builder);
        if (name == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
        }
        return name;
    }

    private static void mapAndAdvance(PsiBuilder builder, IElementType keyword) {
        builder.remapCurrentToken(keyword);
        builder.advanceLexer();
    }

    private static void parseExtras(PsiBuilder builder, @NotNull String message) {
        if (message == null) {
            ModuleParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker extras = builder.mark();
        while (builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        extras.error(message);
    }

    private PsiBuilder.Marker parseClassOrPackageRef(PsiBuilder builder) {
        return this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/ModuleParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/ModuleParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseExtras";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

