/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J(\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\u0010J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "delegationBySpecifiers", "", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "fields", "", "Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "addInitCode", "", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateDelegateCallForFunctionMember", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overriddenDescriptor", "delegateName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "generateDelegateCallForPropertyMember", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateDelegated", "generateDelegates", "toClass", "field", "getSuperClass", "Field", "js.translator"})
public final class DelegationTranslator
extends AbstractTranslator {
    private final ClassDescriptor classDescriptor;
    private final List<KtDelegatedSuperTypeEntry> delegationBySpecifiers;
    private final Map<KtDelegatedSuperTypeEntry, Field> fields;

    public final void addInitCode(@NotNull List<JsStatement> statements) {
        Intrinsics.checkParameterIsNotNull(statements, "statements");
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            JsExpression delegateInitExpr;
            JsNameRef lhs;
            JsNode jsNode;
            TranslationContext context;
            KtExpression expression2;
            Field field;
            if (this.fields.get(specifier) == null) {
                Intrinsics.throwNpe();
            }
            if (!field.getGenerateField()) continue;
            if (specifier.getDelegateExpression() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(expression2, "specifier.delegateExpression!!");
            Intrinsics.checkExpressionValueIsNotNull(this.context().innerBlock(), "context().innerBlock()");
            Intrinsics.checkExpressionValueIsNotNull(Translation.translateAsExpression(expression2, context), "Translation.translateAsE\u2026sion(expression, context)");
            Collection collection = statements;
            JsBlock jsBlock = context.dynamicContext().jsBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "context.dynamicContext().jsBlock()");
            List<JsStatement> list2 = jsBlock.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "context.dynamicContext().jsBlock().statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
            Intrinsics.checkExpressionValueIsNotNull(JsAstUtils.pureFqn(field.getName(), (JsExpression)new JsThisRef()), "JsAstUtils.pureFqn(field.name, JsThisRef())");
            iterable = statements;
            JsBinaryOperation $receiver = jsNode = JsAstUtils.assignment(lhs, delegateInitExpr);
            $receiver.setSource(specifier);
            jsNode = jsNode.makeStmt();
            iterable.add(jsNode);
        }
    }

    public final void generateDelegated() {
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            ClassDescriptor classDescriptor2;
            if (this.getSuperClass(specifier) == null) continue;
            ClassDescriptor it = classDescriptor2;
            KtSuperTypeListEntry ktSuperTypeListEntry = specifier;
            Field field = this.fields.get(specifier);
            if (field == null) {
                Intrinsics.throwNpe();
            }
            this.generateDelegates(ktSuperTypeListEntry, it, field);
        }
    }

    private final ClassDescriptor getSuperClass(KtSuperTypeListEntry specifier) {
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "bindingContext()");
        ClassDescriptor classDescriptor2 = CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, bindingContext);
        if (classDescriptor2 == null) {
            String string = "ClassDescriptor of superType should not be null: " + specifier.getText();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return classDescriptor2;
    }

    private final void generateDelegates(KtSuperTypeListEntry specifier, ClassDescriptor toClass, Field field) {
        Map map2 = DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, this.classDescriptor, toClass, null, 4, null);
        for (Map.Entry entry : map2.entrySet()) {
            Object object = entry;
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)object.getKey();
            object = entry;
            CallableMemberDescriptor overriddenDescriptor2 = (CallableMemberDescriptor)object.getValue();
            object = descriptor2;
            if (object instanceof PropertyDescriptor) {
                this.generateDelegateCallForPropertyMember(specifier, (PropertyDescriptor)descriptor2, field.getName());
                continue;
            }
            if (object instanceof FunctionDescriptor) {
                CallableMemberDescriptor callableMemberDescriptor = overriddenDescriptor2;
                if (callableMemberDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                this.generateDelegateCallForFunctionMember(specifier, (FunctionDescriptor)descriptor2, (FunctionDescriptor)callableMemberDescriptor, field.getName());
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Expected property or function " + descriptor2);
        }
    }

    private final void generateDelegateCallForPropertyMember(KtSuperTypeListEntry specifier, PropertyDescriptor descriptor2, JsName delegateName) {
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.name.asString()");
        String propertyName = string;
        Function1<PropertyGetterDescriptor, JsFunction> generateDelegateGetterFunction$ = new Function1<PropertyGetterDescriptor, JsFunction>(this, delegateName, descriptor2, propertyName, specifier){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ JsName $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;
            final /* synthetic */ KtSuperTypeListEntry $specifier;

            @NotNull
            public final JsFunction invoke(@NotNull PropertyGetterDescriptor getterDescriptor) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(getterDescriptor, "getterDescriptor");
                JsNameRef delegateRef = new JsNameRef(this.$delegateName, (JsExpression)new JsThisRef());
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName jsName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(getterDescriptor);
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "context().getNameForDescriptor(getterDescriptor)");
                    JsName getterName = jsName;
                    String string = Namer.getReceiverParameterName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getReceiverParameterName()");
                    String receiver2 = string;
                    jsExpression = new JsInvocation((JsExpression)new JsNameRef(getterName, (JsExpression)delegateRef), new JsNameRef(receiver2));
                } else {
                    jsExpression = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                }
                JsExpression returnExpression = jsExpression;
                returnExpression.source(this.$specifier);
                JsFunction jsFunction = TranslationUtils.simpleReturnFunction(DelegationTranslator.access$context(this.this$0).getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), returnExpression);
                Intrinsics.checkExpressionValueIsNotNull(jsFunction, "simpleReturnFunction(con\u2026ation), returnExpression)");
                JsFunction jsFunction2 = jsFunction;
                jsFunction2.setSource(this.$specifier);
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName jsName = jsFunction2.getScope().declareName(Namer.getReceiverParameterName());
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "jsFunction.scope.declare\u2026tReceiverParameterName())");
                    JsName receiverName = jsName;
                    jsFunction2.getParameters().add(new JsParameter(receiverName));
                }
                return jsFunction2;
            }
            {
                this.this$0 = delegationTranslator;
                this.$delegateName = jsName;
                this.$descriptor = propertyDescriptor2;
                this.$propertyName = string;
                this.$specifier = ktSuperTypeListEntry;
                super(1);
            }
        };
        Function1<PropertySetterDescriptor, JsFunction> generateDelegateSetterFunction$ = new Function1<PropertySetterDescriptor, JsFunction>(this, specifier, delegateName, descriptor2, propertyName){
            final /* synthetic */ DelegationTranslator this$0;
            final /* synthetic */ KtSuperTypeListEntry $specifier;
            final /* synthetic */ JsName $delegateName;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ String $propertyName;

            @NotNull
            public final JsFunction invoke(@NotNull PropertySetterDescriptor setterDescriptor) {
                JsExpression jsExpression;
                boolean bl;
                Intrinsics.checkParameterIsNotNull(setterDescriptor, "setterDescriptor");
                JsProgram jsProgram = DelegationTranslator.access$context(this.this$0).program();
                Intrinsics.checkExpressionValueIsNotNull(jsProgram, "context().program()");
                JsFunction jsFunction = new JsFunction(jsProgram.getRootScope(), "setter for " + setterDescriptor.getName().asString());
                jsFunction.setSource(this.$specifier);
                boolean bl2 = bl = setterDescriptor.getValueParameters().size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Setter must have 1 parameter";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                JsParameter defaultParameter = new JsParameter(JsScope.declareTemporary());
                JsNameRef jsNameRef = defaultParameter.getName().makeRef();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "defaultParameter.name.makeRef()");
                JsNameRef defaultParameterRef = jsNameRef;
                JsNameRef delegateRef = new JsNameRef(this.$delegateName, (JsExpression)new JsThisRef());
                if (DescriptorUtils.isExtension(this.$descriptor)) {
                    JsName jsName = DelegationTranslator.access$context(this.this$0).getNameForDescriptor(setterDescriptor);
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "context().getNameForDescriptor(setterDescriptor)");
                    JsName setterName = jsName;
                    JsNameRef setterNameRef = new JsNameRef(setterName, (JsExpression)delegateRef);
                    JsName jsName2 = jsFunction.getScope().declareName(Namer.getReceiverParameterName());
                    Intrinsics.checkExpressionValueIsNotNull(jsName2, "jsFunction.scope.declare\u2026tReceiverParameterName())");
                    JsName extensionFunctionReceiverName = jsName2;
                    jsFunction.getParameters().add(new JsParameter(extensionFunctionReceiverName));
                    jsExpression = new JsInvocation((JsExpression)setterNameRef, new JsNameRef(extensionFunctionReceiverName), defaultParameterRef);
                } else {
                    JsNameRef propertyNameRef = new JsNameRef(this.$propertyName, (JsExpression)delegateRef);
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(propertyNameRef, defaultParameterRef);
                    Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "JsAstUtils.assignment(pr\u2026Ref, defaultParameterRef)");
                    jsExpression = jsBinaryOperation;
                }
                JsExpression setExpression = jsExpression;
                jsFunction.getParameters().add(defaultParameter);
                JsExpression jsExpression2 = setExpression;
                JsFunction jsFunction2 = jsFunction;
                JsExpression $receiver = jsExpression2;
                $receiver.setSource(this.$specifier);
                JsExpression jsExpression3 = jsExpression2;
                JsStatement jsStatement = jsExpression3.makeStmt();
                jsFunction2.setBody(new JsBlock(jsStatement));
                return jsFunction;
            }
            {
                this.this$0 = delegationTranslator;
                this.$specifier = ktSuperTypeListEntry;
                this.$delegateName = jsName;
                this.$descriptor = propertyDescriptor2;
                this.$propertyName = string;
                super(1);
            }
        };
        Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer> generateDelegateAccessor$ = new Function2<PropertyAccessorDescriptor, JsFunction, JsPropertyInitializer>(this){
            final /* synthetic */ DelegationTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function2) {
                Intrinsics.checkParameterIsNotNull(accessorDescriptor, "accessorDescriptor");
                Intrinsics.checkParameterIsNotNull(function2, "function");
                JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, accessorDescriptor, DelegationTranslator.access$context(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "translateFunctionAsEcma5\u2026sorDescriptor, context())");
                return jsPropertyInitializer;
            }
            {
                this.this$0 = delegationTranslator;
                super(2);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateGetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateGetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor$3;
            final /* synthetic */ generateDelegateCallForPropertyMember.1 $generateDelegateGetterFunction$1;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertyGetterDescriptor propertyGetterDescriptor = this.$descriptor.getGetter();
                if (propertyGetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
                }
                Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor, "descriptor.getter ?: thr\u2026ptor should not be null\")");
                PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
                return this.$generateDelegateAccessor$3.invoke(getterDescriptor, this.$generateDelegateGetterFunction$1.invoke(getterDescriptor));
            }
            {
                this.$descriptor = propertyDescriptor2;
                this.$generateDelegateAccessor$3 = var2_2;
                this.$generateDelegateGetterFunction$1 = var3_3;
                super(0);
            }
        };
        Function0<JsPropertyInitializer> generateDelegateSetter$ = new Function0<JsPropertyInitializer>(descriptor2, generateDelegateAccessor$, generateDelegateSetterFunction$){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ generateDelegateCallForPropertyMember.3 $generateDelegateAccessor$3;
            final /* synthetic */ generateDelegateCallForPropertyMember.2 $generateDelegateSetterFunction$2;

            @NotNull
            public final JsPropertyInitializer invoke() {
                PropertySetterDescriptor propertySetterDescriptor = this.$descriptor.getSetter();
                if (propertySetterDescriptor == null) {
                    throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
                }
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor, "descriptor.setter ?: thr\u2026ptor should not be null\")");
                PropertySetterDescriptor setterDescriptor = propertySetterDescriptor;
                return this.$generateDelegateAccessor$3.invoke(setterDescriptor, this.$generateDelegateSetterFunction$2.invoke(setterDescriptor));
            }
            {
                this.$descriptor = propertyDescriptor2;
                this.$generateDelegateAccessor$3 = var2_2;
                this.$generateDelegateSetterFunction$2 = var3_3;
                super(0);
            }
        };
        if (DescriptorUtilsKt.isExtensionProperty(descriptor2) || TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor, "descriptor.getter!!");
            PropertyGetterDescriptor getter2 = propertyGetterDescriptor;
            TranslationContext translationContext = this.context();
            TranslationContext translationContext2 = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext2, "context()");
            translationContext.addDeclarationStatement(UtilsKt.addFunctionToPrototype(translationContext2, this.classDescriptor, getter2, generateDelegateGetterFunction$.invoke(getter2)));
            if (descriptor2.isVar()) {
                PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                if (propertySetterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor, "descriptor.setter!!");
                PropertySetterDescriptor setter2 = propertySetterDescriptor;
                TranslationContext translationContext3 = this.context();
                TranslationContext translationContext4 = this.context();
                Intrinsics.checkExpressionValueIsNotNull(translationContext4, "context()");
                translationContext3.addDeclarationStatement(UtilsKt.addFunctionToPrototype(translationContext4, this.classDescriptor, setter2, generateDelegateSetterFunction$.invoke(setter2)));
            }
        } else {
            JsObjectLiteral literal = new JsObjectLiteral(true);
            List<JsPropertyInitializer> list2 = literal.getPropertyInitializers();
            Intrinsics.checkExpressionValueIsNotNull(list2, "literal.propertyInitializers");
            PropertyTranslatorKt.addGetterAndSetter(list2, descriptor2, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(generateDelegateGetter$){
                final /* synthetic */ generateDelegateCallForPropertyMember.4 $generateDelegateGetter$4;

                @NotNull
                public final JsPropertyInitializer invoke() {
                    return this.$generateDelegateGetter$4.invoke();
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "generateDelegateGetter";
                }

                public final String getSignature() {
                    return "invoke()Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;";
                }
                {
                    this.$generateDelegateGetter$4 = var1_1;
                    super(0);
                }
            }, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(generateDelegateSetter$){
                final /* synthetic */ generateDelegateCallForPropertyMember.5 $generateDelegateSetter$5;

                @NotNull
                public final JsPropertyInitializer invoke() {
                    return this.$generateDelegateSetter$5.invoke();
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "generateDelegateSetter";
                }

                public final String getSignature() {
                    return "invoke()Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;";
                }
                {
                    this.$generateDelegateSetter$5 = var1_1;
                    super(0);
                }
            });
            TranslationContext translationContext = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
            UtilsKt.addAccessorsToPrototype(translationContext, this.classDescriptor, descriptor2, literal);
        }
    }

    private final void generateDelegateCallForFunctionMember(KtSuperTypeListEntry specifier, FunctionDescriptor descriptor2, FunctionDescriptor overriddenDescriptor2, JsName delegateName) {
        JsNameRef delegateRef = new JsNameRef(delegateName, (JsExpression)new JsThisRef());
        JsExpression jsExpression = delegateRef;
        TranslationContext translationContext = this.context().newDeclaration(overriddenDescriptor2);
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context().newDeclaration(overriddenDescriptor)");
        JsStatement statement2 = UtilsKt.generateDelegateCall(this.classDescriptor, descriptor2, overriddenDescriptor2, jsExpression, translationContext, true, specifier);
        this.context().addDeclarationStatement(statement2);
    }

    /*
     * WARNING - void declaration
     */
    public DelegationTranslator(@NotNull KtPureClassOrObject classDeclaration, @NotNull TranslationContext context) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        ClassDescriptor classDescriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "BindingUtils.getClassDes\u2026text(), classDeclaration)");
        this.classDescriptor = classDescriptor2;
        List<KtSuperTypeListEntry> list2 = classDeclaration.getSuperTypeListEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, "classDeclaration.superTypeListEntries");
        Iterable iterable = list2;
        DelegationTranslator delegationTranslator = this;
        Iterator<KtDelegatedSuperTypeEntry> iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        delegationTranslator.delegationBySpecifiers = object;
        delegationTranslator = this;
        delegationTranslator.fields = object = (Map)new LinkedHashMap();
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            JsName delegateName;
            String idForMangling;
            FqNameUnsafe classFqName;
            KtExpression expression2;
            if (specifier.getDelegateExpression() == null) {
                throw (Throwable)new IllegalArgumentException("delegate expression should not be null: " + specifier.getText());
            }
            Intrinsics.checkExpressionValueIsNotNull(expression2, "specifier.delegateExpres\u2026null: ${specifier.text}\")");
            BindingContext bindingContext = this.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "bindingContext()");
            PropertyDescriptor propertyDescriptor2 = CodegenUtil.getDelegatePropertyIfAny(expression2, this.classDescriptor, bindingContext);
            BindingContext bindingContext2 = this.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "bindingContext()");
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor2, bindingContext2)) {
                JsName delegateName2;
                PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
                if (propertyDescriptor3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(context.getNameForDescriptor(propertyDescriptor3), "context.getNameForDescriptor(propertyDescriptor!!)");
                Map<KtDelegatedSuperTypeEntry, Field> $i$f$filterIsInstanceTo = this.fields;
                Field $i$f$filterIsInstance = new Field(delegateName2, false);
                $i$f$filterIsInstanceTo.put(specifier, $i$f$filterIsInstance);
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(DescriptorUtils.getFqName(this.classDescriptor), "DescriptorUtils.getFqName(classDescriptor)");
            Intrinsics.checkExpressionValueIsNotNull(classFqName.asString(), "classFqName.asString()");
            String string = Namer.getDelegatePrefix();
            Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getDelegatePrefix()");
            String suggestedName = NameSuggestion.Companion.getStableMangledName(string, idForMangling);
            Intrinsics.checkExpressionValueIsNotNull(context.getScopeForDescriptor(this.classDescriptor).declareFreshName(suggestedName + "_0"), "context.getScopeForDescr\u2026ame(\"${suggestedName}_0\")");
            Map<KtDelegatedSuperTypeEntry, Field> map2 = this.fields;
            Field field = new Field(delegateName, true);
            map2.put(specifier, field);
        }
    }

    public static final /* synthetic */ TranslationContext access$context(DelegationTranslator $this) {
        return $this.context();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "generateField", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsName;Z)V", "getGenerateField", "()Z", "getName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
    private static final class Field {
        @NotNull
        private final JsName name;
        private final boolean generateField;

        @NotNull
        public final JsName getName() {
            return this.name;
        }

        public final boolean getGenerateField() {
            return this.generateField;
        }

        public Field(@NotNull JsName name, boolean generateField) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.name = name;
            this.generateField = generateField;
        }
    }
}

