/*
 * This declarations of the PIC16F610 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:22:56 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F610_H__
#define __PIC16F610_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTC_ADDR              0x0007
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define VRCON_ADDR              0x0019
#define CM1CON0_ADDR            0x001A
#define CM2CON0_ADDR            0x001B
#define CM2CON1_ADDR            0x001C
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISC_ADDR              0x0087
#define PIE1_ADDR               0x008C
#define PCON_ADDR               0x008E
#define OSCTUNE_ADDR            0x0090
#define ANSEL_ADDR              0x0091
#define WPU_ADDR                0x0095
#define WPUA_ADDR               0x0095
#define IOC_ADDR                0x0096
#define IOCA_ADDR               0x0096
#define SRCON0_ADDR             0x0099
#define SRCON1_ADDR             0x009A

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RAIF               : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned RAIE               : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RAIF                   0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RAIE                   0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C1IF               : 1;
    unsigned C2IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _T1IF                   0x01
#define _C1IF                   0x08
#define _C2IF                   0x10

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1GE             : 1;
    unsigned T1GINV             : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1GE                 0x40
#define _T1GINV                 0x80

//==============================================================================


//==============================================================================
//        VRCON Bits

extern __at(0x0019) __sfr VRCON;

typedef union
  {
  struct
    {
    unsigned VR0                : 1;
    unsigned VR1                : 1;
    unsigned VR2                : 1;
    unsigned VR3                : 1;
    unsigned VP6EN              : 1;
    unsigned VRR                : 1;
    unsigned C2VREN             : 1;
    unsigned C1VREN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVREN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned VR                 : 4;
    unsigned                    : 4;
    };
  } __VRCONbits_t;

extern __at(0x0019) volatile __VRCONbits_t VRCONbits;

#define _VR0                    0x01
#define _VR1                    0x02
#define _VR2                    0x04
#define _VR3                    0x08
#define _VP6EN                  0x10
#define _FVREN                  0x10
#define _VRR                    0x20
#define _C2VREN                 0x40
#define _C1VREN                 0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x001A) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned                    : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x001A) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x001B) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned                    : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x001B) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x001C) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned T1GSS                : 1;
  unsigned C2HYS                : 1;
  unsigned C1HYS                : 1;
  unsigned T1ACS                : 1;
  unsigned                      : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x001C) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _T1GSS                  0x02
#define _C2HYS                  0x04
#define _C1HYS                  0x08
#define _T1ACS                  0x10
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RAPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RAPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C1IE               : 1;
    unsigned C2IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _T1IE                   0x01
#define _C1IE                   0x08
#define _C2IE                   0x10

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BOD            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BOD                0x01
#define _NOT_POR                0x02

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0090) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0090) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x0091) __sfr ANSEL;

typedef struct
  {
  unsigned ANS0                 : 1;
  unsigned ANS1                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANS4                 : 1;
  unsigned ANS5                 : 1;
  unsigned ANS6                 : 1;
  unsigned ANS7                 : 1;
  } __ANSELbits_t;

extern __at(0x0091) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS4                   0x10
#define _ANS5                   0x20
#define _ANS6                   0x40
#define _ANS7                   0x80

//==============================================================================


//==============================================================================
//        WPU Bits

extern __at(0x0095) __sfr WPU;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned                    : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned                    : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WPUbits_t;

extern __at(0x0095) volatile __WPUbits_t WPUbits;

#define _WPUA0                  0x01
#define _WPU0                   0x01
#define _WPUA1                  0x02
#define _WPU1                   0x02
#define _WPUA2                  0x04
#define _WPU2                   0x04
#define _WPUA4                  0x10
#define _WPU4                   0x10
#define _WPUA5                  0x20
#define _WPU5                   0x20

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x0095) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned                    : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned                    : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WPUAbits_t;

extern __at(0x0095) volatile __WPUAbits_t WPUAbits;

#define _WPUA_WPUA0             0x01
#define _WPUA_WPU0              0x01
#define _WPUA_WPUA1             0x02
#define _WPUA_WPU1              0x02
#define _WPUA_WPUA2             0x04
#define _WPUA_WPU2              0x04
#define _WPUA_WPUA4             0x10
#define _WPUA_WPU4              0x10
#define _WPUA_WPUA5             0x20
#define _WPUA_WPU5              0x20

//==============================================================================


//==============================================================================
//        IOC Bits

extern __at(0x0096) __sfr IOC;

typedef union
  {
  struct
    {
    unsigned IOCA0              : 1;
    unsigned IOCA1              : 1;
    unsigned IOCA2              : 1;
    unsigned IOCA3              : 1;
    unsigned IOCA4              : 1;
    unsigned IOCA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOC0               : 1;
    unsigned IOC1               : 1;
    unsigned IOC2               : 1;
    unsigned IOC3               : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOC                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned IOCA               : 6;
    unsigned                    : 2;
    };
  } __IOCbits_t;

extern __at(0x0096) volatile __IOCbits_t IOCbits;

#define _IOCA0                  0x01
#define _IOC0                   0x01
#define _IOCA1                  0x02
#define _IOC1                   0x02
#define _IOCA2                  0x04
#define _IOC2                   0x04
#define _IOCA3                  0x08
#define _IOC3                   0x08
#define _IOCA4                  0x10
#define _IOC4                   0x10
#define _IOCA5                  0x20
#define _IOC5                   0x20

//==============================================================================


//==============================================================================
//        IOCA Bits

extern __at(0x0096) __sfr IOCA;

typedef union
  {
  struct
    {
    unsigned IOCA0              : 1;
    unsigned IOCA1              : 1;
    unsigned IOCA2              : 1;
    unsigned IOCA3              : 1;
    unsigned IOCA4              : 1;
    unsigned IOCA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOC0               : 1;
    unsigned IOC1               : 1;
    unsigned IOC2               : 1;
    unsigned IOC3               : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCA               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned IOC                : 6;
    unsigned                    : 2;
    };
  } __IOCAbits_t;

extern __at(0x0096) volatile __IOCAbits_t IOCAbits;

#define _IOCA_IOCA0             0x01
#define _IOCA_IOC0              0x01
#define _IOCA_IOCA1             0x02
#define _IOCA_IOC1              0x02
#define _IOCA_IOCA2             0x04
#define _IOCA_IOC2              0x04
#define _IOCA_IOCA3             0x08
#define _IOCA_IOC3              0x08
#define _IOCA_IOCA4             0x10
#define _IOCA_IOC4              0x10
#define _IOCA_IOCA5             0x20
#define _IOCA_IOC5              0x20

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x0099) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRCLKEN            : 1;
    unsigned                    : 1;
    unsigned PULSR              : 1;
    unsigned PULSS              : 1;
    unsigned C2REN              : 1;
    unsigned C1SEN              : 1;
    unsigned SR0                : 1;
    unsigned SR1                : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SR                 : 2;
    };
  } __SRCON0bits_t;

extern __at(0x0099) volatile __SRCON0bits_t SRCON0bits;

#define _SRCLKEN                0x01
#define _PULSR                  0x04
#define _PULSS                  0x08
#define _C2REN                  0x10
#define _C1SEN                  0x20
#define _SR0                    0x40
#define _SR1                    0x80

//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x009A) __sfr SRCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SRCS0              : 1;
    unsigned SRCS1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SRCS               : 2;
    };
  } __SRCON1bits_t;

extern __at(0x009A) volatile __SRCON1bits_t SRCON1bits;

#define _SRCS0                  0x40
#define _SRCS1                  0x80

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _LP_OSC                 0x3FF8  // LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_XT                0x3FF9  // XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _XT_OSC                 0x3FF9  // XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_HS                0x3FFA  // HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _HS_OSC                 0x3FFA  // HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN.
#define _FOSC_EC                0x3FFB  // EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN.
#define _EC_OSC                 0x3FFB  // EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN.
#define _FOSC_INTOSCIO          0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTRC_OSC_NOCLKOUT     0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTOSCIO               0x3FFC  // INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _FOSC_INTOSCCLK         0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTRC_OSC_CLKOUT       0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _INTOSC                 0x3FFD  // INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN.
#define _FOSC_EXTRCIO           0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC_OSC_NOCLKOUT     0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRCIO                0x3FFE  // RCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _FOSC_EXTRCCLK          0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC_OSC_CLKOUT       0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _EXTRC                  0x3FFF  // RC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, RC on RA5/OSC1/CLKIN.
#define _WDTE_OFF               0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // MCLR pin function is MCLR.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _IOSCFS_4MHZ            0x3F7F  // 4 MHz.
#define _IOSCFS4                0x3F7F  // 4 MHz.
#define _IOSCFS_8MHZ            0x3FFF  // 8 MHz.
#define _IOSCFS8                0x3FFF  // 8 MHz.
#define _BOREN_OFF              0x3CFF  // BOR Disabled.
#define _BOD_OFF                0x3CFF  // BOR Disabled.
#define _BOR_OFF                0x3CFF  // BOR Disabled.
#define _BOREN_NSLEEP           0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOD_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOR_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BOD_ON                 0x3FFF  // BOR enabled.
#define _BOR_ON                 0x3FFF  // BOR enabled.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ANS0                    ANSELbits.ANS0                  // bit 0
#define ANS1                    ANSELbits.ANS1                  // bit 1
#define ANS4                    ANSELbits.ANS4                  // bit 4
#define ANS5                    ANSELbits.ANS5                  // bit 5
#define ANS6                    ANSELbits.ANS6                  // bit 6
#define ANS7                    ANSELbits.ANS7                  // bit 7

#define C1CH0                   CM1CON0bits.C1CH0               // bit 0
#define C1CH1                   CM1CON0bits.C1CH1               // bit 1
#define C1R                     CM1CON0bits.C1R                 // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C2CH0                   CM2CON0bits.C2CH0               // bit 0
#define C2CH1                   CM2CON0bits.C2CH1               // bit 1
#define C2R                     CM2CON0bits.C2R                 // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2SYNC                  CM2CON1bits.C2SYNC              // bit 0
#define T1GSS                   CM2CON1bits.T1GSS               // bit 1
#define C2HYS                   CM2CON1bits.C2HYS               // bit 2
#define C1HYS                   CM2CON1bits.C1HYS               // bit 3
#define T1ACS                   CM2CON1bits.T1ACS               // bit 4
#define MC2OUT                  CM2CON1bits.MC2OUT              // bit 6
#define MC1OUT                  CM2CON1bits.MC1OUT              // bit 7

#define RAIF                    INTCONbits.RAIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define RAIE                    INTCONbits.RAIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCA0                   IOCbits.IOCA0                   // bit 0, shadows bit in IOCbits
#define IOC0                    IOCbits.IOC0                    // bit 0, shadows bit in IOCbits
#define IOCA1                   IOCbits.IOCA1                   // bit 1, shadows bit in IOCbits
#define IOC1                    IOCbits.IOC1                    // bit 1, shadows bit in IOCbits
#define IOCA2                   IOCbits.IOCA2                   // bit 2, shadows bit in IOCbits
#define IOC2                    IOCbits.IOC2                    // bit 2, shadows bit in IOCbits
#define IOCA3                   IOCbits.IOCA3                   // bit 3, shadows bit in IOCbits
#define IOC3                    IOCbits.IOC3                    // bit 3, shadows bit in IOCbits
#define IOCA4                   IOCbits.IOCA4                   // bit 4, shadows bit in IOCbits
#define IOC4                    IOCbits.IOC4                    // bit 4, shadows bit in IOCbits
#define IOCA5                   IOCbits.IOCA5                   // bit 5, shadows bit in IOCbits
#define IOC5                    IOCbits.IOC5                    // bit 5, shadows bit in IOCbits

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RAPU                OPTION_REGbits.NOT_RAPU         // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BOD                 PCONbits.NOT_BOD                // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0, shadows bit in PIE1bits
#define T1IE                    PIE1bits.T1IE                   // bit 0, shadows bit in PIE1bits
#define C1IE                    PIE1bits.C1IE                   // bit 3
#define C2IE                    PIE1bits.C2IE                   // bit 4

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0, shadows bit in PIR1bits
#define T1IF                    PIR1bits.T1IF                   // bit 0, shadows bit in PIR1bits
#define C1IF                    PIR1bits.C1IF                   // bit 3
#define C2IF                    PIR1bits.C2IF                   // bit 4

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define SRCLKEN                 SRCON0bits.SRCLKEN              // bit 0
#define PULSR                   SRCON0bits.PULSR                // bit 2
#define PULSS                   SRCON0bits.PULSS                // bit 3
#define C2REN                   SRCON0bits.C2REN                // bit 4
#define C1SEN                   SRCON0bits.C1SEN                // bit 5
#define SR0                     SRCON0bits.SR0                  // bit 6
#define SR1                     SRCON0bits.SR1                  // bit 7

#define SRCS0                   SRCON1bits.SRCS0                // bit 6
#define SRCS1                   SRCON1bits.SRCS1                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1GE                  T1CONbits.TMR1GE                // bit 6
#define T1GINV                  T1CONbits.T1GINV                // bit 7

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define VR0                     VRCONbits.VR0                   // bit 0
#define VR1                     VRCONbits.VR1                   // bit 1
#define VR2                     VRCONbits.VR2                   // bit 2
#define VR3                     VRCONbits.VR3                   // bit 3
#define VP6EN                   VRCONbits.VP6EN                 // bit 4, shadows bit in VRCONbits
#define FVREN                   VRCONbits.FVREN                 // bit 4, shadows bit in VRCONbits
#define VRR                     VRCONbits.VRR                   // bit 5
#define C2VREN                  VRCONbits.C2VREN                // bit 6
#define C1VREN                  VRCONbits.C1VREN                // bit 7

#define WPUA0                   WPUbits.WPUA0                   // bit 0, shadows bit in WPUbits
#define WPU0                    WPUbits.WPU0                    // bit 0, shadows bit in WPUbits
#define WPUA1                   WPUbits.WPUA1                   // bit 1, shadows bit in WPUbits
#define WPU1                    WPUbits.WPU1                    // bit 1, shadows bit in WPUbits
#define WPUA2                   WPUbits.WPUA2                   // bit 2, shadows bit in WPUbits
#define WPU2                    WPUbits.WPU2                    // bit 2, shadows bit in WPUbits
#define WPUA4                   WPUbits.WPUA4                   // bit 4, shadows bit in WPUbits
#define WPU4                    WPUbits.WPU4                    // bit 4, shadows bit in WPUbits
#define WPUA5                   WPUbits.WPUA5                   // bit 5, shadows bit in WPUbits
#define WPU5                    WPUbits.WPU5                    // bit 5, shadows bit in WPUbits

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F610_H__
