/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.BitRateControl;

public class BitRateAdapter
implements BitRateControl,
ActionListener {
    protected int value;
    protected int min;
    protected int max;
    protected boolean settable;
    protected TextComp textComp;

    public BitRateAdapter(int initialBitRate, int minBitRate, int maxBitRate, boolean settable) {
        this.value = initialBitRate;
        this.min = minBitRate;
        this.max = maxBitRate;
        this.settable = settable;
    }

    public int getBitRate() {
        return this.value;
    }

    public int setBitRate(int newValue) {
        if (this.settable) {
            if (newValue < this.min) {
                newValue = this.min;
            }
            if (newValue > this.max) {
                newValue = this.max;
            }
            this.value = newValue;
            if (this.textComp != null) {
                this.textComp.setValue(Integer.toString(newValue));
            }
            return this.value;
        }
        return -1;
    }

    public int getMinSupportedBitRate() {
        return this.min;
    }

    public int getMaxSupportedBitRate() {
        return this.max;
    }

    protected String getName() {
        return "Bit Rate";
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), Integer.toString(this.value), 7, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.textComp != null) {
            this.setBitRate(this.textComp.getIntValue());
        }
    }
}

