/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapdump.impl;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshot;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapdump.HeapDump;
import com.sun.tools.visualvm.heapviewer.HeapViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class HeapDumpView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(HeapDumpView.class.getName());

    public HeapDumpView(HeapDump heapDump) {
        this(heapDump, DataSourceDescriptorFactory.getDescriptor((DataSource)heapDump));
    }

    private HeapDumpView(HeapDump heapDump, DataSourceDescriptor descriptor) {
        super((DataSource)heapDump, descriptor.getName(), descriptor.getIcon(), 0, HeapDumpView.isClosableView(heapDump));
    }

    protected DataViewComponent createComponent() {
        HeapDump heapDump = (HeapDump)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(heapDump).getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private static boolean isClosableView(HeapDump heapDump) {
        if (!heapDump.isVisible()) {
            return false;
        }
        DataSource owner = heapDump.getOwner();
        if (owner == null) {
            return false;
        }
        while (owner != null && owner != DataSource.ROOT) {
            if (owner instanceof ApplicationSnapshot) {
                return true;
            }
            if (!owner.isVisible()) {
                return false;
            }
            owner = owner.getOwner();
        }
        return owner == DataSource.ROOT;
    }

    private static class MasterViewSupport
    extends JPanel {
        private JLabel progressLabel;
        private JPanel contentsPanel;

        public MasterViewSupport(HeapDump heapDump) {
            File file = heapDump.getFile();
            this.initComponents(file != null);
            if (file != null) {
                this.loadHeap(file);
            }
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Heap_Dump"), null, (JComponent)new ScrollableContainer((JComponent)this));
        }

        private void initComponents(boolean hasDump) {
            this.setLayout(new BorderLayout());
            String label = hasDump ? NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump") : NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump_failed");
            this.progressLabel = new JLabel(label, 0);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.add((Component)this.progressLabel, "Center");
            this.contentsPanel.setOpaque(false);
            this.add((Component)this.contentsPanel, "Center");
            this.setOpaque(false);
        }

        private void loadHeap(final File file) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        final HeapViewer heapViewer = new HeapViewer(file);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                contentsPanel.remove(progressLabel);
                                contentsPanel.add((Component)heapViewer.getComponent(), "Center");
                                contentsPanel.revalidate();
                                contentsPanel.repaint();
                            }
                        });
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.throwing(HeapDumpView.class.getName(), "loadHeap", ex);
                    }
                    catch (IOException ex) {
                        LOGGER.throwing(HeapDumpView.class.getName(), "loadHeap", ex);
                    }
                }
            });
        }
    }
}

