/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.java.ClassNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceReferenceNode;
import com.sun.tools.visualvm.heapviewer.java.PrimitiveNode;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.ui.UIThresholds;
import com.sun.tools.visualvm.heapviewer.utils.NodesComputer;
import com.sun.tools.visualvm.heapviewer.utils.ProgressIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;

public abstract class JavaFieldsProvider
extends HeapViewerNode.Provider {
    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        List<FieldValue> fields = this.getFields(parent, heap);
        return JavaFieldsProvider.getNodes(fields, parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    static HeapViewerNode[] getNodes(final List<FieldValue> fields, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        if (fields == null) {
            return null;
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(fields.size(), UIThresholds.MAX_INSTANCE_FIELDS){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            @Override
            protected HeapViewerNode createNode(Integer index) {
                FieldValue field = (FieldValue)fields.get(index);
                return field instanceof ObjectFieldValue ? new InstanceReferenceNode.Field((ObjectFieldValue)field, false) : new PrimitiveNode.Field(field);
            }

            @Override
            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator<Integer> iterator = 1.integerIterator(index, fields.size());
                return new ProgressIterator<Integer>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaFieldsProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaFieldsProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaFieldsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    protected abstract List<FieldValue> getFields(HeapViewerNode var1, Heap var2);

    public static class ClassFieldsProvider
    extends JavaFieldsProvider {
        @Override
        public String getName() {
            return Bundle.ClassFieldsProvider_Name();
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("java_objects");
        }

        @Override
        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof ClassNode) {
                JavaClass javaClass = ((ClassNode)parent).getJavaClass();
                return javaClass != null && !javaClass.isArray();
            }
            return false;
        }

        @Override
        protected List<FieldValue> getFields(HeapViewerNode parent, Heap heap) {
            JavaClass jclass = HeapViewerNode.getValue(parent, DataType.CLASS, heap);
            return jclass == null ? null : jclass.getStaticFieldValues();
        }
    }

    public static class InstanceFieldsProvider
    extends JavaFieldsProvider {
        private boolean includeStaticFields = true;
        private boolean includeInstanceFields = true;

        @Override
        public String getName() {
            return Bundle.InstanceFieldsProvider_Name();
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("java_");
        }

        @Override
        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof InstanceNode && !InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)((InstanceNode)parent).getMode())) {
                Instance instance = ((InstanceNode)parent).getInstance();
                return instance != null && !instance.getJavaClass().isArray();
            }
            return false;
        }

        @Override
        protected List<FieldValue> getFields(HeapViewerNode parent, Heap heap) {
            Instance instance = HeapViewerNode.getValue(parent, DataType.INSTANCE, heap);
            if (instance == null) {
                return null;
            }
            if (this.includeStaticFields == this.includeInstanceFields) {
                ArrayList<FieldValue> fields = new ArrayList<FieldValue>(instance.getFieldValues());
                fields.addAll(instance.getStaticFieldValues());
                return fields;
            }
            if (this.includeInstanceFields) {
                return instance.getFieldValues();
            }
            return instance.getStaticFieldValues();
        }
    }
}

