/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.merge;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenToolchainMerger {
    public void merge(PersistedToolchains dominant, PersistedToolchains recessive, String recessiveSourceLevel) {
        if (dominant == null || recessive == null) {
            return;
        }
        recessive.setSourceLevel(recessiveSourceLevel);
        this.shallowMerge(dominant.getToolchains(), recessive.getToolchains(), recessiveSourceLevel);
    }

    private void shallowMerge(List<ToolchainModel> dominant, List<ToolchainModel> recessive, String recessiveSourceLevel) {
        Object key2;
        LinkedHashMap<Object, ToolchainModel> merged = new LinkedHashMap<Object, ToolchainModel>();
        for (ToolchainModel dominantModel : dominant) {
            key2 = this.getToolchainModelKey(dominantModel);
            merged.put(key2, dominantModel);
        }
        for (ToolchainModel recessiveModel : recessive) {
            key2 = this.getToolchainModelKey(recessiveModel);
            ToolchainModel dominantModel = (ToolchainModel)merged.get(key2);
            if (dominantModel == null) {
                recessiveModel.setSourceLevel(recessiveSourceLevel);
                dominant.add(recessiveModel);
                continue;
            }
            this.mergeToolchainModel_Configuration(dominantModel, recessiveModel);
        }
    }

    protected void mergeToolchainModel_Configuration(ToolchainModel target, ToolchainModel source2) {
        Xpp3Dom src = (Xpp3Dom)source2.getConfiguration();
        if (src != null) {
            Xpp3Dom tgt = (Xpp3Dom)target.getConfiguration();
            tgt = tgt == null ? Xpp3Dom.mergeXpp3Dom(new Xpp3Dom(src), tgt) : Xpp3Dom.mergeXpp3Dom(tgt, src);
            target.setConfiguration(tgt);
        }
    }

    protected Object getToolchainModelKey(ToolchainModel model) {
        return model;
    }
}

