/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.view.HighlightSearchEntry;

public class HighlighterManager
extends Observable {
    static HighlighterManager hilighterManager = null;
    private LinkedList<HighlightSearchEntry> highlights = new LinkedList();
    private List<SoftObserver> observers = new ArrayList<SoftObserver>();

    public static HighlighterManager getInstance() {
        if (hilighterManager == null) {
            hilighterManager = new HighlighterManager();
        }
        return hilighterManager;
    }

    public void reinitHighlights(LinkedList<HighlightSearchEntry> list) {
        this.highlights = (LinkedList)list.clone();
        this.setChanged();
        this.notifyObservers(null);
    }

    public void addHighlightEntry(String token, SearchMatch.Location type, boolean isActive) {
        HighlightSearchEntry entry = new HighlightSearchEntry(token, type, Color.red, isActive);
        this.addHighlightEntry(entry);
    }

    public void addHighlightEntry(HighlightSearchEntry entry) {
        this.highlights.add(entry);
        this.setChanged();
        this.notifyObservers(entry);
    }

    public void removeHighlightEntry(int id) {
        this.highlights.remove(id);
        this.setChanged();
        this.notifyObservers(null);
    }

    public LinkedList<HighlightSearchEntry> getHighlights() {
        return (LinkedList)this.highlights.clone();
    }

    @Override
    public synchronized void addObserver(Observer obs) {
        if (obs == null) {
            throw new NullPointerException();
        }
        boolean observerContained = false;
        Iterator<SoftObserver> it = this.observers.iterator();
        while (it.hasNext()) {
            Observer other = (Observer)it.next().get();
            if (other == null) {
                it.remove();
                continue;
            }
            if (!obs.equals(other)) continue;
            observerContained = true;
            break;
        }
        if (!observerContained) {
            this.observers.add(new SoftObserver(obs));
        }
    }

    @Override
    public synchronized void deleteObserver(Observer obs) {
        Iterator<SoftObserver> it = this.observers.iterator();
        while (it.hasNext()) {
            Observer other = (Observer)it.next().get();
            if (other == null) {
                it.remove();
                continue;
            }
            if (!obs.equals(other)) continue;
            it.remove();
            break;
        }
    }

    private synchronized void deleteSoftObserver(SoftObserver obs) {
        this.observers.remove(obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object arg) {
        Observer[] arrLocal;
        HighlighterManager highlighterManager = this;
        synchronized (highlighterManager) {
            if (!this.hasChanged()) {
                return;
            }
            arrLocal = new Observer[this.observers.size()];
            arrLocal = this.observers.toArray(arrLocal);
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            arrLocal[i].update(this, arg);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public synchronized int countObservers() {
        return this.observers.size();
    }

    private class SoftObserver
    extends SoftReference<Observer>
    implements Observer {
        public SoftObserver(Observer referent) {
            super(referent);
        }

        @Override
        public void update(Observable o, Object arg) {
            Observer observer = (Observer)this.get();
            if (observer != null) {
                observer.update(o, arg);
            } else {
                HighlighterManager.this.deleteSoftObserver(this);
            }
        }
    }
}

