/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int selfCompactDataOfs;
    protected Set<Integer> compactDataOfs;
    protected int nChildren;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super(cPUCCTContainer, prestimeCPUCCTNode, cPUCCTContainer.getMethodIdForNodeOfs(n));
        this.selfCompactDataOfs = n;
        this.compactDataOfs = new HashSet<Integer>();
        this.compactDataOfs.add(this.selfCompactDataOfs);
        this.container = cPUCCTContainer;
        this.nChildren = cPUCCTContainer.getNChildrenForNodeOfs(n);
        this.nCalls = cPUCCTContainer.getNCallsForNodeOfs(n);
        this.sleepTime0 = cPUCCTContainer.getSleepTime0ForNodeOfs(n);
        this.totalTime0 = cPUCCTContainer.getTotalTime0ForNodeOfs(n);
        if (cPUCCTContainer.collectingTwoTimeStamps) {
            this.totalTime1 = cPUCCTContainer.getTotalTime1ForNodeOfs(n);
        }
        this.waitTime0 = cPUCCTContainer.getWaitTime0ForNodeOfs(n);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray) {
        super(cPUCCTContainer, null, -1);
        this.setThreadNode();
        this.children = prestimeCPUCCTNodeArray;
        this.nChildren = prestimeCPUCCTNodeArray == null ? 0 : prestimeCPUCCTNodeArray.length;
        for (int i = 0; i < this.nChildren; ++i) {
            if (prestimeCPUCCTNodeArray[i] == null) continue;
            prestimeCPUCCTNodeArray[i].parent = this;
        }
    }

    PrestimeCPUCCTNodeBacked() {
    }

    @Override
    PrestimeCPUCCTNode createCopy() {
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked();
        this.setupCopy(prestimeCPUCCTNodeBacked);
        return prestimeCPUCCTNodeBacked;
    }

    void setupCopy(PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
        super.setupCopy(prestimeCPUCCTNodeBacked);
        prestimeCPUCCTNodeBacked.selfCompactDataOfs = this.selfCompactDataOfs;
        prestimeCPUCCTNodeBacked.compactDataOfs = this.compactDataOfs;
        prestimeCPUCCTNodeBacked.nChildren = this.nChildren;
    }

    @Override
    public CCTNode createFilteredNode() {
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked();
        this.setupFilteredNode(prestimeCPUCCTNodeBacked);
        return prestimeCPUCCTNodeBacked;
    }

    protected void setupFilteredNode(PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
        super.setupFilteredNode(prestimeCPUCCTNodeBacked);
        prestimeCPUCCTNodeBacked.nChildren = prestimeCPUCCTNodeBacked.children.length;
    }

    @Override
    public void merge(CCTNode cCTNode) {
        super.merge(cCTNode);
        this.nChildren = this.children.length;
    }

    public PrestimeCPUCCTNodeBacked createRootCopy() {
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
        prestimeCPUCCTNodeBacked.parent = null;
        prestimeCPUCCTNodeBacked.compactDataOfs.clear();
        prestimeCPUCCTNodeBacked.compactDataOfs.addAll(this.compactDataOfs);
        prestimeCPUCCTNodeBacked.children = null;
        prestimeCPUCCTNodeBacked.nChildren = this.nChildren;
        prestimeCPUCCTNodeBacked.methodId = this.methodId;
        prestimeCPUCCTNodeBacked.nCalls = this.nCalls;
        prestimeCPUCCTNodeBacked.sleepTime0 = this.sleepTime0;
        prestimeCPUCCTNodeBacked.totalTime0 = this.totalTime0;
        prestimeCPUCCTNodeBacked.totalTime1 = this.totalTime1;
        prestimeCPUCCTNodeBacked.waitTime0 = this.waitTime0;
        return prestimeCPUCCTNodeBacked;
    }

    @Override
    public CCTNode getChild(int n) {
        this.getChildren();
        if (n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.compactDataOfs.iterator();
        while (object.hasNext()) {
            int n = object.next();
            int n2 = this.container.getNChildrenForNodeOfs(n);
            for (int i = 0; i < n2; ++i) {
                PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked(this.container, this, this.container.getChildOfsForNodeOfs(n, i));
                int n3 = arrayList.indexOf(prestimeCPUCCTNodeBacked);
                if (n3 != -1) {
                    ((PrestimeCPUCCTNodeBacked)arrayList.get(n3)).merge(prestimeCPUCCTNodeBacked);
                    continue;
                }
                arrayList.add(prestimeCPUCCTNodeBacked);
            }
        }
        if (this.hasSelfTimeChild()) {
            object = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
            ((PrestimeCPUCCTNodeBacked)object).setSelfTimeNode();
            arrayList.add(object);
        }
        this.nChildren = arrayList.size();
        this.children = arrayList.toArray(new PrestimeCPUCCTNode[0]);
        return this.children;
    }

    @Override
    public boolean isLeaf() {
        if (this.nChildren == 0) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        return this.children.length == 0;
    }

    private boolean hasSelfTimeChild() {
        return !this.isThreadNode() && !this.isFiltered() && this.compactDataOfs.size() == 1;
    }

    protected void merge(PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
    }

    @Override
    protected void resetChildren() {
    }

    @Override
    public void setSelfTimeNode() {
        super.setSelfTimeNode();
        this.nChildren = 0;
        this.children = null;
        int n = this.selfCompactDataOfs;
        this.totalTime0 = this.container.getSelfTime0ForNodeOfs(n);
        if (this.container.collectingTwoTimeStamps) {
            this.totalTime1 = this.container.getSelfTime1ForNodeOfs(n);
        }
    }

    @Override
    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.nChildren;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float f = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return f < 100.0f ? f : 100.0f;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<node>" + string2);
        stringBuffer.append(string).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(string2);
        CCTNode cCTNode = this.getParent();
        stringBuffer.append(string).append(" <Parent>").append(this.replaceHTMLCharacters(cCTNode == null ? "none" : ((PrestimeCPUCCTNodeBacked)this.getParent()).getNodeName())).append("</Parent>").append(string2);
        stringBuffer.append(string).append(" <Time_Relative>").append(percentFormat.format(cCTNode != null ? (double)this.getTotalTime0InPerCent() / 100.0 : 100.0)).append("</Time_Relative>").append(string2);
        stringBuffer.append(string).append(" <Time>").append(cCTNode != null ? Long.valueOf(this.getTotalTime0()) : "N/A").append("</Time>").append(string2);
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append(string).append(" <Time-CPU>").append(this.getTotalTime1()).append("</Time-CPU>").append(string2);
        }
        stringBuffer.append(string).append(" <Invocations>").append(cCTNode != null ? this.getNCalls() : 1).append("</Invocations>").append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportXMLData(exportDataDumper, string + "  ");
            }
        } else if (this.nChildren > 0) {
            int n = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportXMLData(exportDataDumper, string + "  ");
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n;
        }
        stringBuffer = new StringBuffer(string + "</node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">.");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</td><td class=\"right\">").append(this.getTotalTime0());
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append("</td><td class=\"right\">").append(this.getTotalTime1());
        }
        stringBuffer.append("</td><td class=\"right\">").append(this.getNCalls()).append("</td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportHTMLData(exportDataDumper, n + 1);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportHTMLData(exportDataDumper, n + 1);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0InPerCent()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0()).append(string3).append(string);
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append(string3).append(this.getTotalTime1()).append(string3).append(string);
        }
        stringBuffer.append(string3).append(this.getNCalls()).append(string3).append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportCSVData(string, n + 1, exportDataDumper);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    public static void setPercentFormat(NumberFormat numberFormat) {
        percentFormat = numberFormat;
    }
}

